/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.command.CommandJED;
import fi.dy.masa.justenoughdimensions.config.Configs;
import fi.dy.masa.justenoughdimensions.config.DimensionConfigEntry;
import fi.dy.masa.justenoughdimensions.config.DimensionTypeEntry;
import fi.dy.masa.justenoughdimensions.network.MessageSyncDimensions;
import fi.dy.masa.justenoughdimensions.network.PacketHandler;
import fi.dy.masa.justenoughdimensions.util.ConfigFileUtils;
import fi.dy.masa.justenoughdimensions.util.JEDJsonUtils;
import fi.dy.masa.justenoughdimensions.world.JEDWorldProperties;
import fi.dy.masa.justenoughdimensions.world.WorldProviderSurfaceJED;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class DimensionConfig {
    private static DimensionConfig instance;
    private final File configDirJED;
    private final File dimensionConfigFileGlobal;
    private final Set<Integer> registeredDimensions = new HashSet<Integer>();
    private final Map<Integer, DimensionConfigEntry> dimensions = new HashMap<Integer, DimensionConfigEntry>();
    private final Map<Integer, NBTTagCompound> customWorldInfo = new HashMap<Integer, NBTTagCompound>();
    private final Map<Integer, NBTTagCompound> onetimeWorldInfo = new HashMap<Integer, NBTTagCompound>();
    private final Map<String, Integer> worldInfoKeys = new HashMap<String, Integer>();
    private final Map<String, Integer> jedKeys = new HashMap<String, Integer>();
    private final Map<String, Integer> jedKeysListTypes = new HashMap<String, Integer>();
    private JsonObject dimBuilderData = new JsonObject();
    private File currentDimensionConfigFile;
    private String currentConfigId = "__default";
    private int currentConfigVersion;

    private DimensionConfig(File configDirCommon) {
        instance = this;
        this.configDirJED = new File(configDirCommon, "justenoughdimensions");
        this.dimensionConfigFileGlobal = new File(this.configDirJED, "dimensions.json");
        this.initWorldInfoKeys();
    }

    public static DimensionConfig init(File configDirCommon) {
        return new DimensionConfig(configDirCommon);
    }

    public static DimensionConfig instance() {
        return instance;
    }

    public File getGlobalJEDConfigDir() {
        return this.configDirJED;
    }

    public Collection<DimensionConfigEntry> getRegisteredDimensions() {
        ArrayList<DimensionConfigEntry> list = new ArrayList<DimensionConfigEntry>();
        for (int dim : this.registeredDimensions) {
            DimensionConfigEntry entry = this.dimensions.get(dim);
            if (entry == null) continue;
            list.add(entry);
        }
        return list;
    }

    @Nullable
    public DimensionConfigEntry getDimensionConfigFor(int dimension) {
        return this.dimensions.get(dimension);
    }

    private void initWorldInfoKeys() {
        this.worldInfoKeys.put("RandomSeed", 4);
        this.worldInfoKeys.put("generatorName", 8);
        this.worldInfoKeys.put("generatorVersion", 3);
        this.worldInfoKeys.put("generatorOptions", 8);
        this.worldInfoKeys.put("GameType", 3);
        this.worldInfoKeys.put("MapFeatures", 1);
        this.worldInfoKeys.put("SpawnX", 3);
        this.worldInfoKeys.put("SpawnY", 3);
        this.worldInfoKeys.put("SpawnZ", 3);
        this.worldInfoKeys.put("Time", 4);
        this.worldInfoKeys.put("DayTime", 4);
        this.worldInfoKeys.put("LastPlayed", 4);
        this.worldInfoKeys.put("SizeOnDisk", 4);
        this.worldInfoKeys.put("LevelName", 8);
        this.worldInfoKeys.put("version", 3);
        this.worldInfoKeys.put("clearWeatherTime", 3);
        this.worldInfoKeys.put("rainTime", 3);
        this.worldInfoKeys.put("raining", 1);
        this.worldInfoKeys.put("thunderTime", 3);
        this.worldInfoKeys.put("thundering", 1);
        this.worldInfoKeys.put("hardcore", 1);
        this.worldInfoKeys.put("initialized", 1);
        this.worldInfoKeys.put("allowCommands", 1);
        this.worldInfoKeys.put("Difficulty", 1);
        this.worldInfoKeys.put("DifficultyLocked", 1);
        this.worldInfoKeys.put("BorderCenterX", 6);
        this.worldInfoKeys.put("BorderCenterZ", 6);
        this.worldInfoKeys.put("BorderSize", 6);
        this.worldInfoKeys.put("BorderSizeLerpTime", 4);
        this.worldInfoKeys.put("BorderSizeLerpTarget", 6);
        this.worldInfoKeys.put("BorderSafeZone", 6);
        this.worldInfoKeys.put("BorderDamagePerBlock", 6);
        this.worldInfoKeys.put("BorderWarningBlocks", 3);
        this.worldInfoKeys.put("BorderWarningTime", 3);
        this.jedKeys.put("CanRespawnHere", 1);
        this.jedKeys.put("CloudColor", 8);
        this.jedKeys.put("CloudHeight", 3);
        this.jedKeys.put("Colors", 9);
        this.jedKeys.put("CustomDayCycle", 1);
        this.jedKeys.put("DayLength", 3);
        this.jedKeys.put("FogColor", 8);
        this.jedKeys.put("ForceGameMode", 1);
        this.jedKeys.put("LightBrightness", 9);
        this.jedKeys.put("NightLength", 3);
        this.jedKeys.put("RespawnDimension", 3);
        this.jedKeys.put("SkyColor", 8);
        this.jedKeys.put("SkyDisableFlags", 1);
        this.jedKeys.put("SkyRenderer", 8);
        this.jedKeys.put("SkyRenderType", 1);
        this.jedKeysListTypes.put("Colors", 10);
        this.jedKeysListTypes.put("LightBrightness", 5);
    }

    public boolean useCustomWorldInfoFor(int dimension) {
        return this.customWorldInfo.containsKey(dimension) || this.onetimeWorldInfo.containsKey(dimension);
    }

    public void setWorldInfoValues(int dimension, NBTTagCompound tagIn, WorldInfoType type) {
        Map<Integer, NBTTagCompound> map = type == WorldInfoType.ONE_TIME ? this.onetimeWorldInfo : this.customWorldInfo;
        NBTTagCompound dimNBT = map.get(dimension);
        if (dimNBT != null) {
            tagIn.func_179237_a(dimNBT);
        }
    }

    public void readDimensionConfig() {
        this.readDimensionConfig(DimensionManager.getCurrentSaveRootDirectory());
    }

    public void readDimensionConfig(File worldDir) {
        if (worldDir != null) {
            File configDir = new File(new File(worldDir, "data"), "justenoughdimensions");
            File configFile = new File(configDir, "dimensions.json");
            if (Configs.copyDimensionConfigToWorld) {
                ConfigFileUtils.createDirIfNotExists(configDir);
                File configGlobal = this.dimensionConfigFileGlobal;
                if (configGlobal.exists() && configGlobal.isFile() && configGlobal.canRead()) {
                    ConfigFileUtils.tryCopyOrMoveConfigIfMissingOrOlder(configFile, configGlobal, ConfigFileUtils.FileAction.COPY, new ConfigComparatorDimensionConfig());
                }
            }
            if (Configs.usePerWorldDimensionConfig && configFile.exists() && configFile.isFile() && configFile.canRead()) {
                this.currentDimensionConfigFile = configFile;
                this.readDimensionConfigFromFile(this.currentDimensionConfigFile);
                return;
            }
        }
        this.currentDimensionConfigFile = this.dimensionConfigFileGlobal;
        this.readDimensionConfigFromFile(this.currentDimensionConfigFile);
    }

    private void readDimensionConfigFromFile(File configFile) {
        this.customWorldInfo.clear();
        this.onetimeWorldInfo.clear();
        this.dimensions.clear();
        this.currentConfigId = "__default";
        this.currentConfigVersion = 0;
        JEDWorldProperties.clearWorldProperties();
        if (configFile != null && configFile.exists() && configFile.isFile() && configFile.canRead()) {
            String fileName = configFile.getAbsolutePath();
            JsonElement rootElement = JEDJsonUtils.parseJsonFile(configFile);
            if (rootElement != null) {
                JustEnoughDimensions.logInfo("Reading the dimension config from file '{}'", fileName);
                this.parseDimensionConfig(rootElement);
            } else {
                JustEnoughDimensions.logger.warn("The dimension config in file '{}' was empty or invalid", (Object)fileName);
            }
        } else {
            JustEnoughDimensions.logger.warn("No 'dimensions.json' file found; neither global nor per-world");
        }
        this.restoreMissingVanillaDimensions();
    }

    private void restoreMissingVanillaDimensions() {
        for (int dim = -1; dim < 2; ++dim) {
            if (this.dimensions.containsKey(dim) || DimensionManager.isDimensionRegistered((int)dim)) continue;
            JustEnoughDimensions.logInfo("Dimension {} was not registered, and not found in the current JED config. Registering the normal vanilla dimension for it.", dim);
            DimensionManager.registerDimension((int)dim, (DimensionType)this.getVanillaDimensionType(dim));
        }
    }

    private DimensionType getVanillaDimensionType(int dim) {
        switch (dim) {
            case 1: {
                return DimensionType.THE_END;
            }
            case -1: {
                return DimensionType.NETHER;
            }
        }
        return DimensionType.OVERWORLD;
    }

    public void registerDimensions() {
        for (DimensionConfigEntry entry : this.dimensions.values()) {
            this.registerDimension(entry.getDimension(), entry);
        }
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSyncDimensions(this.getRegisteredDimensions()));
    }

    public void registerNonOverrideDimensions() {
        for (DimensionConfigEntry entry : this.dimensions.values()) {
            if (DimensionManager.isDimensionRegistered((int)entry.getDimension())) continue;
            this.registerDimension(entry.getDimension(), entry);
        }
    }

    public void doEarlyDimensionRegistrations() {
        for (DimensionConfigEntry entry : this.dimensions.values()) {
            if (DimensionManager.isDimensionRegistered((int)entry.getDimension())) {
                if (Configs.enableUnregisteringDimensions && entry.getUnregister()) {
                    JustEnoughDimensions.logInfo("Unregistering dimension {}...", entry.getDimension());
                    DimensionManager.unregisterDimension((int)entry.getDimension());
                    continue;
                }
                if (!Configs.enableReplacingRegisteredDimensions || !entry.getOverride()) continue;
                this.registerDimension(entry.getDimension(), entry);
                continue;
            }
            if (!entry.getShouldLoadOnStart()) continue;
            this.registerDimension(entry.getDimension(), entry);
        }
    }

    private boolean registerDimension(int dimension, DimensionConfigEntry entry) {
        if (entry.getUnregister() || !entry.hasDimensionTypeEntry()) {
            return false;
        }
        if (!DimensionManager.isDimensionRegistered((int)dimension)) {
            JustEnoughDimensions.logInfo("Registering a dimension with ID {}", dimension);
            DimensionType type = entry.getDimensionTypeEntry().getOrRegisterDimensionType(dimension);
            DimensionManager.registerDimension((int)dimension, (DimensionType)type);
            this.registeredDimensions.add(dimension);
            return true;
        }
        if (Configs.enableReplacingRegisteredDimensions && entry.getOverride()) {
            if (DimensionManager.getWorld((int)dimension) == null) {
                JustEnoughDimensions.logInfo("Overriding dimension {}", dimension);
                DimensionManager.unregisterDimension((int)dimension);
                DimensionManager.registerDimension((int)dimension, (DimensionType)entry.getDimensionTypeEntry().getOrRegisterDimensionType(dimension));
                this.registeredDimensions.add(dimension);
                return true;
            }
            JustEnoughDimensions.logger.warn("Dimension {} is already registered and currently loaded, can't override it", (Object)dimension);
        } else {
            JustEnoughDimensions.logger.warn("Dimension {} is already registered, skipping it", (Object)dimension);
        }
        return false;
    }

    public String registerDimensionFromConfig(int dimension) throws CommandException {
        DimensionConfigEntry entry = this.dimensions.get(dimension);
        if (entry != null) {
            if (entry.getUnregister()) {
                CommandJED.throwNumber("register.from.config.unregister.set", dimension);
            }
            if (this.registerDimension(dimension, entry)) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSyncDimensions(this.getRegisteredDimensions()));
                return entry.getDescription();
            }
            CommandJED.throwNumber("register.from.config", dimension);
        }
        CommandJED.throwNumber("register.not.in.config", dimension);
        return "";
    }

    public String registerNewDimension(int dimension) throws CommandException {
        DimensionConfigEntry entry = new DimensionConfigEntry(dimension);
        entry.setDimensionTypeEntry(this.createDefaultDimensionTypeEntry(dimension));
        return this.registerNewDimension(dimension, entry);
    }

    private String registerNewDimension(int dimension, DimensionConfigEntry entry) throws CommandException {
        boolean success = this.registerDimension(dimension, entry);
        if (!success) {
            CommandJED.throwNumber("dimension.already.registered", dimension);
        }
        this.dimensions.put(dimension, entry);
        this.saveConfig();
        PacketHandler.INSTANCE.sendToAll((IMessage)new MessageSyncDimensions(this.getRegisteredDimensions()));
        return entry.getDescription();
    }

    public String registerNewDimension(int dimension, String name, String suffix, boolean keepLoaded, String providerClassName, boolean override) throws CommandException {
        Class<? extends WorldProvider> providerClass = DimensionTypeEntry.getProviderClass(providerClassName);
        if (providerClass == null) {
            CommandJED.throwCommand("invalid.worldprovider.name", providerClassName);
        }
        DimensionConfigEntry entry = new DimensionConfigEntry(dimension);
        entry.setDimensionTypeEntry(new DimensionTypeEntry(dimension, name, suffix, keepLoaded, providerClass));
        entry.setOverride(override);
        return this.registerNewDimension(dimension, entry);
    }

    public void unregisterCustomDimensions() {
        Iterator<Integer> iter = this.registeredDimensions.iterator();
        while (iter.hasNext()) {
            int dimension = iter.next();
            if (dimension == 0 || !DimensionManager.isDimensionRegistered((int)dimension) || DimensionManager.getWorld((int)dimension) != null) continue;
            JustEnoughDimensions.logInfo("Unregistering dimension {}", dimension);
            DimensionManager.unregisterDimension((int)dimension);
            iter.remove();
        }
    }

    public void removeDimensionAndSaveConfig(int dimension) {
        this.removeDimension(dimension);
        this.saveConfig();
    }

    private void removeDimension(int dimension) {
        this.dimensions.remove(dimension);
        this.customWorldInfo.remove(dimension);
        this.onetimeWorldInfo.remove(dimension);
        JEDWorldProperties.removePropertiesFrom(dimension);
    }

    private void saveConfig() {
        ArrayList<DimensionConfigEntry> dims = new ArrayList<DimensionConfigEntry>(this.dimensions.values());
        Collections.sort(dims);
        JsonObject root = new JsonObject();
        JsonArray array = new JsonArray();
        for (DimensionConfigEntry dimEntry : dims) {
            array.add((JsonElement)dimEntry.toJson());
        }
        JsonObject objVersion = new JsonObject();
        objVersion.add("id", (JsonElement)new JsonPrimitive(this.currentConfigId));
        objVersion.add("version", (JsonElement)new JsonPrimitive((Number)this.currentConfigVersion));
        root.add("config_version", (JsonElement)objVersion);
        root.add("dimensions", (JsonElement)array);
        try {
            FileWriter writer = new FileWriter(this.currentDimensionConfigFile);
            writer.write(JEDJsonUtils.GSON_PRETTY.toJson((JsonElement)root));
            writer.close();
        }
        catch (IOException e) {
            JustEnoughDimensions.logger.warn("Failed to write dimension config to file '{}'", (Object)this.currentDimensionConfigFile.getAbsolutePath(), (Object)e);
        }
    }

    @Nullable
    private static Pair<String, Integer> getConfigVersion(JsonElement rootElement) {
        JsonObject root;
        JsonObject objVersion;
        if (rootElement != null && rootElement.isJsonObject() && (objVersion = JEDJsonUtils.getNestedObject(root = rootElement.getAsJsonObject(), "config_version", false)) != null) {
            String id = JEDJsonUtils.getStringOrDefault(objVersion, "id", "__default", true);
            int ver = JEDJsonUtils.getIntegerOrDefault(objVersion, "version", 0);
            return Pair.of((Object)id, (Object)ver);
        }
        return null;
    }

    private void parseDimensionConfig(JsonElement rootElement) throws IllegalStateException {
        if (rootElement == null || !rootElement.isJsonObject()) {
            JustEnoughDimensions.logger.warn("The dimension config is missing the root object!");
            return;
        }
        JsonObject root = rootElement.getAsJsonObject();
        Pair<String, Integer> version = DimensionConfig.getConfigVersion(rootElement);
        if (version != null) {
            this.currentConfigId = (String)version.getLeft();
            this.currentConfigVersion = (Integer)version.getRight();
        }
        if (root.has("dimensions") && root.get("dimensions").isJsonArray()) {
            JsonArray array = rootElement.getAsJsonObject().get("dimensions").getAsJsonArray();
            int count = 0;
            for (JsonElement el : array) {
                JsonObject object = el.getAsJsonObject();
                if (!object.has("dim") || !object.get("dim").isJsonPrimitive()) continue;
                this.parseDimensionConfigEntry(object.get("dim").getAsInt(), object);
                ++count;
            }
            JustEnoughDimensions.logInfo("Read {} dimension entries from the config", count);
        }
    }

    private void parseDimensionConfigEntry(int dimension, JsonObject object) {
        DimensionConfigEntry configEntry = DimensionConfigEntry.fromJson(dimension, object);
        if (configEntry.getWorldInfoJson() != null) {
            this.customWorldInfo.put(dimension, this.parseAndGetCustomWorldInfoValues(dimension, configEntry.getWorldInfoJson()));
        }
        if (configEntry.getOneTimeWorldInfoJson() != null) {
            this.onetimeWorldInfo.put(dimension, this.parseAndGetCustomWorldInfoValues(dimension, configEntry.getOneTimeWorldInfoJson()));
        }
        this.dimensions.put(dimension, configEntry);
    }

    private DimensionTypeEntry createDefaultDimensionTypeEntry(int dimension) {
        DimensionTypeEntry dte = new DimensionTypeEntry(dimension, "DIM" + dimension, "dim_" + dimension, false, WorldProviderSurfaceJED.class);
        JustEnoughDimensions.logInfo("Created a default DimensionTypeEntry for dimension {}: {}", dimension, dte.getDescription());
        return dte;
    }

    public void dimbuilderClear() {
        this.dimBuilderData = new JsonObject();
    }

    public void dimbuilderDimtype(int id, String name, String suffix, String keepLoaded, String worldProvider) {
        JsonObject dimType = JEDJsonUtils.getOrCreateNestedObject(this.dimBuilderData, "dimensiontype");
        dimType.add("id", (JsonElement)new JsonPrimitive((Number)id));
        dimType.add("name", (JsonElement)new JsonPrimitive(name));
        dimType.add("suffix", (JsonElement)new JsonPrimitive(suffix));
        dimType.add("keeploaded", (JsonElement)new JsonPrimitive(keepLoaded));
        dimType.add("worldprovider", (JsonElement)new JsonPrimitive(worldProvider));
    }

    public void dimbuilderSet(String key, String value, WorldInfoType type) {
        JsonObject obj = this.dimBuilderData;
        if (key.equals("override") || key.equals("unregister") || key.equals("biome") || key.equals("disable_teleporting_from") || key.equals("disable_teleporting_to")) {
            obj.add(key, (JsonElement)new JsonPrimitive(value));
        } else if (key.equals("id") || key.equals("name") || key.equals("suffix") || key.equals("keeploaded") || key.equals("worldprovider") || key.equals("existing_dimensiontype")) {
            JEDJsonUtils.getOrCreateNestedObject(obj, "dimensiontype").add(key, (JsonElement)new JsonPrimitive(value));
        } else if (key.equals("worldinfo") || key.equals("worldinfo_onetime")) {
            JEDJsonUtils.getOrCreateNestedObject(obj, type.getKeyName());
        } else {
            if (this.isJEDProperty(key)) {
                obj = JEDJsonUtils.getOrCreateNestedObject(obj, "jed");
            } else {
                obj = JEDJsonUtils.getOrCreateNestedObject(obj, type.getKeyName());
                if (this.worldInfoKeys.get(key) == null) {
                    obj = JEDJsonUtils.getOrCreateNestedObject(obj, "GameRules");
                }
            }
            obj.add(key, (JsonElement)new JsonPrimitive(value));
        }
    }

    public boolean dimbuilderRemove(String key, WorldInfoType type) {
        JsonObject obj = this.dimBuilderData;
        if (key.equals("override") || key.equals("unregister") || key.equals("biome") || key.equals("disable_teleporting_from") || key.equals("disable_teleporting_to") || key.equals("jed") || key.equals("worldinfo") || key.equals("worldinfo_onetime")) {
            return obj.remove(key) != null;
        }
        if (key.equals("id") || key.equals("name") || key.equals("suffix") || key.equals("keeploaded") || key.equals("worldprovider") || key.equals("existing_dimensiontype")) {
            return (obj = JEDJsonUtils.getNestedObject(obj, "dimensiontype", false)) != null ? obj.remove(key) != null : false;
        }
        if (this.isJEDProperty(key)) {
            boolean success;
            boolean bl = (obj = JEDJsonUtils.getNestedObject(obj, "jed", false)) != null ? obj.remove(key) != null : (success = false);
            if (obj != null && obj.size() == 0) {
                this.dimBuilderData.remove("jed");
            }
            return success;
        }
        if ((obj = JEDJsonUtils.getNestedObject(obj, type.getKeyName(), false)) != null) {
            if (obj.has(key)) {
                return obj.remove(key) != null;
            }
            return (obj = JEDJsonUtils.getNestedObject(obj, "GameRules", false)) != null && obj.remove(key) != null;
        }
        return false;
    }

    public void dimbuilderList(@Nullable String key, WorldInfoType type, ICommandSender sender) throws CommandException {
        if (key != null) {
            JsonPrimitive prim = this.getDimbuilderPrimitive(key, type);
            if (prim != null) {
                sender.func_145747_a((ITextComponent)new TextComponentString(key + " = " + prim.getAsString()));
            } else {
                CommandJED.throwCommand("dimbuilder.list", key);
            }
        } else {
            JustEnoughDimensions.logger.info("==== Dim Builder list start ====");
            JustEnoughDimensions.logger.info("\n" + JEDJsonUtils.GSON_PRETTY.toJson((JsonElement)this.dimBuilderData));
            JustEnoughDimensions.logger.info("==== Dim Builder list end ====");
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("jed.commands.info.output.printed.to.console", new Object[0]));
        }
    }

    public boolean dimbuilderReadFrom(int dimension) {
        DimensionConfigEntry entry = this.dimensions.get(dimension);
        if (entry != null) {
            this.dimBuilderData = entry.toJson();
            this.dimBuilderData.remove("dim");
            return true;
        }
        return false;
    }

    public void dimbuilderSaveAs(int dimension) {
        this.removeDimension(dimension);
        this.parseDimensionConfigEntry(dimension, this.dimBuilderData);
        this.saveConfig();
    }

    public void dimbuilderCreateAs(int dimension) throws CommandException {
        this.dimbuilderSaveAs(dimension);
        this.registerDimensionFromConfig(dimension);
    }

    @Nullable
    private JsonPrimitive getDimbuilderPrimitive(String key, WorldInfoType type) {
        JsonObject obj = this.dimBuilderData;
        if ((key.equals("override") || key.equals("unregister") || key.equals("biome") || key.equals("disable_teleporting_from") || key.equals("disable_teleporting_to")) && obj.has(key) && obj.get(key).isJsonPrimitive()) {
            return obj.get(key).getAsJsonPrimitive();
        }
        if (key.equals("id") || key.equals("name") || key.equals("suffix") || key.equals("keeploaded") || key.equals("worldprovider") || key.equals("existing_dimensiontype")) {
            if (obj.has("dimensiontype") && obj.get("dimensiontype").isJsonObject()) {
                return (obj = obj.get("dimensiontype").getAsJsonObject()).has(key) && obj.get(key).isJsonPrimitive() ? obj.get(key).getAsJsonPrimitive() : null;
            }
            return null;
        }
        if (this.isJEDProperty(key)) {
            return (obj = JEDJsonUtils.getNestedObject(obj, "jed", false)) != null && obj.has(key) && obj.get(key).isJsonPrimitive() ? obj.get(key).getAsJsonPrimitive() : null;
        }
        if (obj.has(type.getKeyName()) && obj.get(type.getKeyName()).isJsonObject()) {
            if ((obj = obj.get(type.getKeyName()).getAsJsonObject()).has(key) && obj.get(key).isJsonPrimitive()) {
                return obj.get(key).getAsJsonPrimitive();
            }
            if (obj.has("GameRules") && obj.get("GameRules").isJsonObject()) {
                return (obj = obj.get("GameRules").getAsJsonObject()).has(key) && obj.get(key).isJsonPrimitive() ? obj.get(key).getAsJsonPrimitive() : null;
            }
        }
        return null;
    }

    private NBTTagCompound parseAndGetCustomWorldInfoValues(int dimension, JsonObject object) throws IllegalStateException {
        NBTTagCompound nbt = new NBTTagCompound();
        for (Map.Entry entry : object.entrySet()) {
            JsonElement element = (JsonElement)entry.getValue();
            String key = (String)entry.getKey();
            NBTBase tag = this.getTagForWorldInfoValue(key, element);
            if (tag == null) continue;
            nbt.func_74782_a(key, tag);
        }
        return nbt;
    }

    private boolean isJEDProperty(String key) {
        return this.jedKeys.get(key) != null;
    }

    @Nullable
    private NBTBase getTagForWorldInfoValue(String key, JsonElement element) {
        if (key.equals("RandomSeed") && element.isJsonPrimitive()) {
            try {
                long seed = Long.parseLong(element.getAsString());
                return new NBTTagLong(seed);
            }
            catch (NumberFormatException e) {
                String seedStr = element.getAsString();
                return new NBTTagLong(seedStr.isEmpty() ? JustEnoughDimensions.RAND.nextLong() : (long)seedStr.hashCode());
            }
        }
        if (element.isJsonObject()) {
            NBTTagCompound tag = new NBTTagCompound();
            JsonObject obj = element.getAsJsonObject();
            if (key.equals("GameRules")) {
                for (Map.Entry entry : obj.entrySet()) {
                    JsonElement el = (JsonElement)entry.getValue();
                    if (el.isJsonPrimitive()) {
                        tag.func_74778_a((String)entry.getKey(), el.getAsString());
                        continue;
                    }
                    JustEnoughDimensions.logger.warn("Invalid GameRule value: '{} = {}'", entry.getKey(), (Object)el);
                }
            }
            return tag;
        }
        Integer type = this.worldInfoKeys.get(key);
        if (type != null) {
            return this.getTagForType(key, type, element);
        }
        JustEnoughDimensions.logger.warn("Unrecognized option in worldinfo.values: '{} = {}'", (Object)key, (Object)element);
        return null;
    }

    @Nullable
    private NBTBase getTagForType(String key, int type, JsonElement element) {
        try {
            switch (type) {
                case 1: {
                    try {
                        String str = element.getAsString();
                        if (str != null && (str.equals("true") || str.equals("false"))) {
                            return new NBTTagByte(element.getAsBoolean() ? (byte)1 : 0);
                        }
                    }
                    catch (Exception str) {
                        // empty catch block
                    }
                    return new NBTTagByte(element.getAsByte());
                }
                case 2: {
                    return new NBTTagShort(element.getAsShort());
                }
                case 3: {
                    return new NBTTagInt(element.getAsInt());
                }
                case 4: {
                    return new NBTTagLong(element.getAsLong());
                }
                case 5: {
                    return new NBTTagFloat(element.getAsFloat());
                }
                case 6: {
                    return new NBTTagDouble(element.getAsDouble());
                }
                case 8: {
                    return new NBTTagString(element.getAsString());
                }
                case 9: {
                    if (!element.isJsonArray() || !this.jedKeysListTypes.containsKey(key)) break;
                    JsonArray arr = element.getAsJsonArray();
                    NBTTagList list = new NBTTagList();
                    int listType = this.jedKeysListTypes.get(key);
                    for (JsonElement el : arr) {
                        NBTBase tag = this.getTagForType("", listType, el);
                        if (tag == null) continue;
                        list.func_74742_a(tag);
                    }
                    return list;
                }
            }
        }
        catch (Exception e) {
            JustEnoughDimensions.logger.warn("Invalid/unexpected value: '{}' for key '{}'", (Object)key, (Object)element);
        }
        return null;
    }

    public static enum ColorType {
        FOLIAGE("FoliageColors"),
        GRASS("GrassColors"),
        WATER("WaterColors");

        private final String keyName;

        private ColorType(String keyName) {
            this.keyName = keyName;
        }

        public String getKeyName() {
            return this.keyName;
        }
    }

    public static enum WorldInfoType {
        REGULAR("worldinfo"),
        ONE_TIME("worldinfo_onetime");

        private final String keyName;

        private WorldInfoType(String keyName) {
            this.keyName = keyName;
        }

        public String getKeyName() {
            return this.keyName;
        }
    }

    private static class ConfigComparatorDimensionConfig
    extends ConfigFileUtils.ConfigComparator {
        private ConfigComparatorDimensionConfig() {
        }

        @Override
        public boolean shouldReplace(File fileToReplace, File replacementFile) {
            if (!fileToReplace.exists()) {
                return true;
            }
            if (fileToReplace.exists() && fileToReplace.isFile() && fileToReplace.canRead() && replacementFile.exists() && replacementFile.isFile() && replacementFile.canRead()) {
                Pair versionNew;
                JsonElement rootElementOld = JEDJsonUtils.parseJsonFile(fileToReplace);
                JsonElement rootElementNew = JEDJsonUtils.parseJsonFile(replacementFile);
                Pair versionOld = rootElementOld != null ? DimensionConfig.getConfigVersion(rootElementOld) : null;
                Pair pair = versionNew = rootElementNew != null ? DimensionConfig.getConfigVersion(rootElementNew) : null;
                if (versionOld != null && versionNew != null) {
                    return ((String)versionNew.getLeft()).equals(versionOld.getLeft()) && (Integer)versionNew.getRight() > (Integer)versionOld.getRight();
                }
            }
            return false;
        }
    }
}

