/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.tiles;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import xt9.deepmoblearning.DeepMobLearning;
import xt9.deepmoblearning.common.blocks.BlockTrialKeystone;
import xt9.deepmoblearning.common.capabilities.PlayerTrial;
import xt9.deepmoblearning.common.entity.EntityGlitch;
import xt9.deepmoblearning.common.handlers.BaseItemHandler;
import xt9.deepmoblearning.common.handlers.TrialKeyHandler;
import xt9.deepmoblearning.common.items.ItemTrialKey;
import xt9.deepmoblearning.common.network.RequestKeystoneItemMessage;
import xt9.deepmoblearning.common.network.UpdateKeystoneItemMessage;
import xt9.deepmoblearning.common.tiles.IGuiTile;
import xt9.deepmoblearning.common.trials.Trial;
import xt9.deepmoblearning.common.trials.TrialFactory;
import xt9.deepmoblearning.common.trials.TrialRuleset;
import xt9.deepmoblearning.common.trials.affix.ITrialAffix;
import xt9.deepmoblearning.common.util.BlockDistance;
import xt9.deepmoblearning.common.util.PlayerHelper;
import xt9.deepmoblearning.common.util.SoundHelper;
import xt9.deepmoblearning.common.util.TrialKey;

public class TileEntityTrialKeystone
extends TileEntity
implements ITickable,
IGuiTile {
    public static final String NBT_LONG_TILE_POS = "deepmoblearning:tilepos";
    private static final int ARENA_RADIUS = 21;
    private boolean active = false;
    private int ticksToNextWave = 0;
    private int waveMobTotal = 0;
    private int mobsSpawned = 0;
    private int mobsDefeated = 0;
    private int currentWave = 0;
    private int lastWave = 0;
    private long tickCount = 0L;
    private Trial trialData;
    private ItemStack activeKey = ItemStack.field_190927_a;
    private NonNullList<ITrialAffix> affixes = NonNullList.func_191196_a();
    private ThreadLocalRandom rand = ThreadLocalRandom.current();
    private final Set<EntityPlayerMP> participants = Collections.newSetFromMap(new WeakHashMap());
    public BaseItemHandler trialKey = new TrialKeyHandler(){

        protected void onContentsChanged(int slot) {
            if (!((TileEntityTrialKeystone)TileEntityTrialKeystone.this).field_145850_b.field_72995_K) {
                DeepMobLearning.network.sendToAllAround((IMessage)new UpdateKeystoneItemMessage(TileEntityTrialKeystone.this), new NetworkRegistry.TargetPoint(((TileEntityTrialKeystone)TileEntityTrialKeystone.this).field_145850_b.field_73011_w.getDimension(), (double)TileEntityTrialKeystone.this.field_174879_c.func_177958_n(), (double)TileEntityTrialKeystone.this.field_174879_c.func_177956_o(), (double)TileEntityTrialKeystone.this.field_174879_c.func_177952_p(), 64.0));
            }
            super.onContentsChanged(slot);
        }
    };

    public void func_73660_a() {
        ++this.tickCount;
        if (!this.field_145850_b.field_72995_K) {
            if (this.isTrialActive()) {
                this.disableFlying();
                this.participantBouncer();
                if (this.participants.isEmpty()) {
                    List<EntityPlayerMP> nearbyPlayers = PlayerHelper.getPlayersInArea(this.field_145850_b, this.func_174877_v(), 80, this.func_174877_v().func_177956_o() - 30, this.func_174877_v().func_177956_o() + 30);
                    nearbyPlayers.forEach(p -> PlayerHelper.sendMessage(p, new TextComponentString("Trial failed, all participants have died/left the arena")));
                    this.finishTrial(true, false);
                } else {
                    if (this.ticksToNextWave > 0) {
                        --this.ticksToNextWave;
                        if (this.ticksToNextWave == 0) {
                            this.nextWave();
                        }
                        return;
                    }
                    if (this.currentWave <= this.lastWave) {
                        if (this.mobsSpawned < this.waveMobTotal) {
                            if ((double)this.tickCount % (20.0 * this.trialData.getSpawnDelay()) == 0.0) {
                                this.spawnTrialMob();
                            }
                        } else if (this.mobsDefeated == this.waveMobTotal) {
                            if (this.currentWave == this.lastWave - 1) {
                                this.finishTrial(false, true);
                            } else {
                                this.sendWaveCountdown(100);
                                SoundHelper.playSound(this.field_145850_b, this.func_174877_v(), "waveCountdown");
                            }
                        }
                    } else {
                        this.resetTrial();
                    }
                }
                this.runAffixes();
                if (this.tickCount % 280L == 0L) {
                    this.spawnGlitch();
                }
                if (this.tickCount % 300L == 0L) {
                    this.updateState();
                }
            }
            if (this.tickCount % 100L == 0L) {
                this.func_70296_d();
            }
        }
    }

    private void disableFlying() {
        this.participants.forEach(p -> {
            if (!p.field_70128_L && !p.field_71075_bZ.field_75098_d) {
                p.field_71075_bZ.field_75101_c = false;
                p.field_71075_bZ.field_75100_b = false;
                p.func_71016_p();
            }
        });
    }

    private void participantBouncer() {
        this.participants.forEach(p -> {
            double distance = BlockDistance.getBlockDistance(this.func_174877_v(), p.func_180425_c());
            if (distance > 21.0) {
                this.participants.remove(p);
                this.clearPlayerCapability((EntityPlayerMP)p);
                PlayerHelper.sendMessage(p, new TextComponentString("You left the Trial"));
            }
        });
    }

    private void runAffixes() {
        this.affixes.forEach(ITrialAffix::run);
    }

    public void startTrial() {
        if (!this.hasTrialKey()) {
            return;
        }
        this.activeKey = this.getTrialKey();
        if (!this.areaIsClear()) {
            return;
        }
        if (!TrialKey.isAttuned(this.activeKey)) {
            return;
        }
        this.participants.addAll(PlayerHelper.getPlayersInArea(this.field_145850_b, this.func_174877_v(), 21, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177956_o() + 6));
        this.trialData = TrialFactory.createTrial(TrialKey.getMobKey(this.activeKey));
        this.lastWave = TrialRuleset.getMaxWaveFromTier(TrialKey.getTier(this.activeKey));
        this.waveMobTotal = this.trialData.getMobCountForWave(this.currentWave);
        this.affixes = TrialKey.getAffixes(this.activeKey, this.field_174879_c, this.field_145850_b);
        this.trialKey.setStackInSlot(0, ItemStack.field_190927_a);
        this.active = true;
        this.updateCapability();
        this.updateState();
        this.sendWaveStart();
    }

    private void sendWaveCountdown(int ticks) {
        this.ticksToNextWave = ticks;
        this.participants.forEach(participant -> PlayerHelper.sendMessageToOverlay(participant, "WaveCountdown"));
    }

    private void sendWaveStart() {
        SoundHelper.playSound(this.field_145850_b, this.func_174877_v(), "waveStart");
        this.participants.forEach(p -> PlayerHelper.sendMessageToOverlay(p, "WaveNumber"));
    }

    private void nextWave() {
        ++this.currentWave;
        this.mobsDefeated = 0;
        this.mobsSpawned = 0;
        this.waveMobTotal = this.trialData.getMobCountForWave(this.currentWave);
        this.participants.clear();
        this.participants.addAll(PlayerHelper.getPlayersInArea(this.field_145850_b, this.func_174877_v(), 21, this.func_174877_v().func_177956_o(), this.func_174877_v().func_177956_o() + 6));
        this.updateCapability();
        this.sendWaveStart();
    }

    private void updateCapability() {
        this.participants.forEach(p -> {
            PlayerTrial cap = (PlayerTrial)PlayerHelper.getTrialCapability(p);
            cap.setWaveMobTotal(this.waveMobTotal);
            cap.setCurrentWave(this.currentWave);
            cap.setDefeated(this.mobsDefeated);
            cap.setLastWave(this.lastWave);
            cap.setTilePos(this.field_174879_c.func_177986_g());
            cap.setIsActive(this.active);
            cap.sync((EntityPlayerMP)p);
        });
    }

    private void clearPlayerCapability(EntityPlayerMP p) {
        PlayerTrial cap = (PlayerTrial)PlayerHelper.getTrialCapability(p);
        cap.setWaveMobTotal(0);
        cap.setCurrentWave(0);
        cap.setDefeated(0);
        cap.setLastWave(0);
        cap.setTilePos(0L);
        cap.setIsActive(false);
        cap.sync(p);
    }

    public void catchMobDeath() {
        ++this.mobsDefeated;
        this.updateCapability();
    }

    public void playerDied(EntityPlayerMP player) {
        this.participants.remove(player);
    }

    public void finishTrial(boolean abort, boolean sendMessages) {
        if (!abort) {
            if (sendMessages) {
                this.participants.forEach(p -> PlayerHelper.sendMessageToOverlay(p, "TrialCompleted"));
                SoundHelper.playSound(this.field_145850_b, this.func_174877_v(), "trialWon");
            }
            NonNullList<ItemStack> rewards = TrialFactory.getRewards(this.activeKey);
            rewards.forEach(stack -> {
                EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 2), (double)this.field_174879_c.func_177952_p(), stack);
                item.func_174869_p();
                this.field_145850_b.func_72838_d((Entity)item);
            });
        } else if (this.isTrialActive() && sendMessages) {
            this.participants.forEach(p -> PlayerHelper.sendMessageToOverlay(p, "TrialAborted"));
        }
        this.resetTrial();
    }

    public void resetTrial() {
        this.active = false;
        this.waveMobTotal = 0;
        this.mobsSpawned = 0;
        this.mobsDefeated = 0;
        this.lastWave = 0;
        this.currentWave = 0;
        this.ticksToNextWave = 0;
        this.updateCapability();
        this.participants.clear();
    }

    private void spawnTrialMob() {
        EntityLiving e = this.trialData.getTrialPrimaryEntity(this.field_145850_b);
        int randomX = this.field_174879_c.func_177958_n() + this.rand.nextInt(-5, 5);
        int randomY = this.field_174879_c.func_177956_o() + this.rand.nextInt(0, 1);
        int randomZ = this.field_174879_c.func_177952_p() + this.rand.nextInt(-5, 5);
        e.func_70012_b((double)randomX, (double)randomY, (double)randomZ, 0.0f, 0.0f);
        e.getEntityData().func_74772_a(NBT_LONG_TILE_POS, this.func_174877_v().func_177986_g());
        e.func_110163_bv();
        EntityPlayer target = e.field_70170_p.func_184139_a(e.func_180425_c(), 32.0, 5.0);
        if (target != null && target.func_70089_S()) {
            e.func_70624_b((EntityLivingBase)target);
        }
        this.affixes.forEach(affix -> affix.apply(e));
        this.field_145850_b.func_72838_d((Entity)e);
        ++this.mobsSpawned;
    }

    private void spawnGlitch() {
        int randomX = this.field_174879_c.func_177958_n() + this.rand.nextInt(-5, 5);
        int randomY = this.field_174879_c.func_177956_o() + this.rand.nextInt(0, 1);
        int randomZ = this.field_174879_c.func_177952_p() + this.rand.nextInt(-5, 5);
        if (this.rand.nextInt(1, 100) <= TrialRuleset.getGlitchSpawnChance(TrialKey.getTier(this.activeKey))) {
            EntityGlitch e = TrialRuleset.getGlitch(this.field_145850_b);
            e.func_70012_b(randomX, randomY, randomZ, 0.0f, 0.0f);
            e.func_110163_bv();
            EntityPlayer target = e.field_70170_p.func_184139_a(e.func_180425_c(), 32.0, 5.0);
            if (target != null && target.func_70089_S()) {
                e.func_70624_b((EntityLivingBase)target);
            }
            this.affixes.forEach(affix -> affix.applyToGlitch(e));
            this.field_145850_b.func_72838_d((Entity)e);
            this.participants.forEach(p -> PlayerHelper.sendMessageToOverlay(p, "GlitchNotification"));
            SoundHelper.playSound(this.field_145850_b, this.func_174877_v(), "glitchAlert");
        }
    }

    public boolean areaIsClear() {
        Iterable groundLayer = BlockPos.func_177980_a((BlockPos)new BlockPos(this.field_174879_c.func_177958_n() - 7, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() - 7), (BlockPos)new BlockPos(this.field_174879_c.func_177958_n() + 7, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() + 7));
        for (BlockPos blockPos : groundLayer) {
            if (this.field_145850_b.func_180495_p(blockPos).func_185913_b()) continue;
            return false;
        }
        Iterable airLayer = BlockPos.func_177980_a((BlockPos)new BlockPos(this.field_174879_c.func_177958_n() - 7, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() - 7), (BlockPos)new BlockPos(this.field_174879_c.func_177958_n() + 7, this.field_174879_c.func_177956_o() + 9, this.field_174879_c.func_177952_p() + 7));
        for (BlockPos blockPos : airLayer) {
            IBlockState state = this.field_145850_b.func_180495_p(blockPos);
            Block block = state.func_177230_c();
            if (block.isAir(state, (IBlockAccess)this.field_145850_b, blockPos) || block instanceof BlockTrialKeystone) continue;
            return false;
        }
        return true;
    }

    public boolean isTrialActive() {
        return this.active;
    }

    public ItemStack getTrialKey() {
        return this.trialKey.getStackInSlot(0);
    }

    public int getCurrentWave() {
        return this.currentWave;
    }

    public int getLastWave() {
        return this.lastWave;
    }

    public boolean hasTrialKey() {
        return this.getTrialKey().func_77973_b() instanceof ItemTrialKey;
    }

    public void updateState() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            DeepMobLearning.network.sendToServer((IMessage)new RequestKeystoneItemMessage(this));
        }
        super.onLoad();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 2, 1));
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 3, this.func_189515_b(new NBTTagCompound()));
    }

    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74757_a("active", this.active);
        compound.func_74768_a("currentWave", this.currentWave);
        compound.func_74768_a("lastWave", this.lastWave);
        compound.func_74768_a("mobsSpawned", this.mobsSpawned);
        compound.func_74768_a("mobsDefeated", this.mobsDefeated);
        compound.func_74768_a("waveMobTotal", this.waveMobTotal);
        compound.func_74782_a("inventory", (NBTBase)this.trialKey.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.active = compound.func_74767_n("active");
        this.currentWave = compound.func_74762_e("currentWave");
        this.lastWave = compound.func_74762_e("lastWave");
        this.mobsSpawned = compound.func_74762_e("mobsSpawned");
        this.mobsDefeated = compound.func_74762_e("mobsDefeated");
        this.waveMobTotal = compound.func_74762_e("waveMobTotal");
        this.trialKey.deserializeNBT(compound.func_74775_l("inventory"));
        super.func_145839_a(compound);
    }

    public boolean hasCapability(Capability capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == null) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.trialKey);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int getGuiID() {
        return 4;
    }
}

