/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.ores;

import appeng.recipes.ores.IOreListener;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryHandler {
    public static final OreDictionaryHandler INSTANCE = new OreDictionaryHandler();
    private final List<IOreListener> oreListeners = new ArrayList<IOreListener>();

    @SubscribeEvent
    public void onOreDictionaryRegister(OreDictionary.OreRegisterEvent event) {
        if (event.getName() == null || event.getOre().func_190926_b()) {
            return;
        }
        if (this.shouldCare(event.getName())) {
            for (IOreListener v : this.oreListeners) {
                v.oreRegistered(event.getName(), event.getOre());
            }
        }
    }

    private boolean shouldCare(String name) {
        return true;
    }

    public void observe(IOreListener n) {
        this.oreListeners.add(n);
        for (String name : OreDictionary.getOreNames()) {
            if (name == null || !this.shouldCare(name)) continue;
            for (ItemStack item : OreDictionary.getOres((String)name)) {
                if (item.func_190926_b()) continue;
                n.oreRegistered(name, item);
            }
        }
    }
}

