/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.infuse.InfuseType;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.recipe.inputs.AdvancedMachineInput;
import mekanism.common.recipe.inputs.ChemicalPairInput;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.inputs.GasInput;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.inputs.IntegerInput;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.recipe.machines.AmbientGasRecipe;
import mekanism.common.recipe.machines.BasicMachineRecipe;
import mekanism.common.recipe.machines.ChanceMachineRecipe;
import mekanism.common.recipe.machines.ChemicalInfuserRecipe;
import mekanism.common.recipe.machines.CombinerRecipe;
import mekanism.common.recipe.machines.CrusherRecipe;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.recipe.machines.DissolutionRecipe;
import mekanism.common.recipe.machines.DoubleMachineRecipe;
import mekanism.common.recipe.machines.EnrichmentRecipe;
import mekanism.common.recipe.machines.InjectionRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.machines.OsmiumCompressorRecipe;
import mekanism.common.recipe.machines.OxidationRecipe;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.machines.PurificationRecipe;
import mekanism.common.recipe.machines.SawmillRecipe;
import mekanism.common.recipe.machines.SeparatorRecipe;
import mekanism.common.recipe.machines.SmeltingRecipe;
import mekanism.common.recipe.machines.SolarNeutronRecipe;
import mekanism.common.recipe.machines.ThermalEvaporationRecipe;
import mekanism.common.recipe.machines.WasherRecipe;
import mekanism.common.recipe.outputs.ChanceOutput;
import mekanism.common.recipe.outputs.ChemicalPairOutput;
import mekanism.common.recipe.outputs.FluidOutput;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.recipe.outputs.MachineOutput;
import mekanism.common.recipe.outputs.PressurizedOutput;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public final class RecipeHandler {
    public static void addRecipe(Recipe recipeMap, MachineRecipe recipe) {
        recipeMap.put(recipe);
    }

    public static void removeRecipe(Recipe recipeMap, MachineRecipe recipe) {
        ArrayList<MachineInput> toRemove = new ArrayList<MachineInput>();
        for (Object o : recipeMap.get().keySet()) {
            MachineInput iterInput = (MachineInput)o;
            if (!iterInput.testEquality(recipe.getInput())) continue;
            toRemove.add(iterInput);
        }
        for (MachineInput iterInput : toRemove) {
            recipeMap.get().remove(iterInput);
        }
    }

    public static void addEnrichmentChamberRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.ENRICHMENT_CHAMBER, new EnrichmentRecipe(input, output));
    }

    public static void addOsmiumCompressorRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.OSMIUM_COMPRESSOR, new OsmiumCompressorRecipe(input, output));
    }

    @Deprecated
    public static void addCombinerRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.COMBINER, new CombinerRecipe(input, output));
    }

    public static void addCombinerRecipe(ItemStack input, ItemStack extra, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.COMBINER, new CombinerRecipe(input, extra, output));
    }

    public static void addCrusherRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.CRUSHER, new CrusherRecipe(input, output));
    }

    public static void addPurificationChamberRecipe(ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.PURIFICATION_CHAMBER, new PurificationRecipe(input, output));
    }

    public static void addMetallurgicInfuserRecipe(InfuseType infuse, int amount, ItemStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.METALLURGIC_INFUSER, new MetallurgicInfuserRecipe(new InfusionInput(infuse, amount, input), output));
    }

    public static void addChemicalInfuserRecipe(GasStack leftInput, GasStack rightInput, GasStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_INFUSER, new ChemicalInfuserRecipe(leftInput, rightInput, output));
    }

    public static void addChemicalOxidizerRecipe(ItemStack input, GasStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_OXIDIZER, new OxidationRecipe(input, output));
    }

    public static void addChemicalInjectionChamberRecipe(ItemStack input, Gas gas, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_INJECTION_CHAMBER, new InjectionRecipe(input, gas, output));
    }

    public static void addElectrolyticSeparatorRecipe(FluidStack fluid, double energy, GasStack leftOutput, GasStack rightOutput) {
        RecipeHandler.addRecipe(Recipe.ELECTROLYTIC_SEPARATOR, new SeparatorRecipe(fluid, energy, leftOutput, rightOutput));
    }

    public static void addPrecisionSawmillRecipe(ItemStack input, ItemStack primaryOutput, ItemStack secondaryOutput, double chance) {
        RecipeHandler.addRecipe(Recipe.PRECISION_SAWMILL, new SawmillRecipe(input, primaryOutput, secondaryOutput, chance));
    }

    public static void addPrecisionSawmillRecipe(ItemStack input, ItemStack primaryOutput) {
        RecipeHandler.addRecipe(Recipe.PRECISION_SAWMILL, new SawmillRecipe(input, primaryOutput));
    }

    public static void addChemicalDissolutionChamberRecipe(ItemStack input, GasStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_DISSOLUTION_CHAMBER, new DissolutionRecipe(input, output));
    }

    public static void addChemicalWasherRecipe(GasStack input, GasStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_WASHER, new WasherRecipe(input, output));
    }

    public static void addChemicalCrystallizerRecipe(GasStack input, ItemStack output) {
        RecipeHandler.addRecipe(Recipe.CHEMICAL_CRYSTALLIZER, new CrystallizerRecipe(input, output));
    }

    public static void addPRCRecipe(ItemStack inputSolid, FluidStack inputFluid, GasStack inputGas, ItemStack outputSolid, GasStack outputGas, double extraEnergy, int ticks) {
        RecipeHandler.addRecipe(Recipe.PRESSURIZED_REACTION_CHAMBER, new PressurizedRecipe(inputSolid, inputFluid, inputGas, outputSolid, outputGas, extraEnergy, ticks));
    }

    public static void addThermalEvaporationRecipe(FluidStack inputFluid, FluidStack outputFluid) {
        RecipeHandler.addRecipe(Recipe.THERMAL_EVAPORATION_PLANT, new ThermalEvaporationRecipe(inputFluid, outputFluid));
    }

    public static void addSolarNeutronRecipe(GasStack inputGas, GasStack outputGas) {
        RecipeHandler.addRecipe(Recipe.SOLAR_NEUTRON_ACTIVATOR, new SolarNeutronRecipe(inputGas, outputGas));
    }

    public static void addAmbientGas(int dimensionID, String ambientGasName) {
        RecipeHandler.addRecipe(Recipe.AMBIENT_ACCUMULATOR, new AmbientGasRecipe(dimensionID, ambientGasName));
    }

    public static MetallurgicInfuserRecipe getMetallurgicInfuserRecipe(InfusionInput input) {
        if (input.isValid()) {
            Map<InfusionInput, MetallurgicInfuserRecipe> recipes = Recipe.METALLURGIC_INFUSER.get();
            MetallurgicInfuserRecipe recipe = recipes.get(input);
            if (recipe == null) {
                recipe = recipes.get(input.wildCopy());
            }
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static ChemicalInfuserRecipe getChemicalInfuserRecipe(ChemicalPairInput input) {
        if (input.isValid()) {
            Map<ChemicalPairInput, ChemicalInfuserRecipe> recipes = Recipe.CHEMICAL_INFUSER.get();
            ChemicalInfuserRecipe recipe = recipes.get(input);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static CrystallizerRecipe getChemicalCrystallizerRecipe(GasInput input) {
        if (input.isValid()) {
            Map<GasInput, CrystallizerRecipe> recipes = Recipe.CHEMICAL_CRYSTALLIZER.get();
            CrystallizerRecipe recipe = recipes.get(input);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static WasherRecipe getChemicalWasherRecipe(GasInput input) {
        if (input.isValid()) {
            Map<GasInput, WasherRecipe> recipes = Recipe.CHEMICAL_WASHER.get();
            WasherRecipe recipe = recipes.get(input);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static DissolutionRecipe getDissolutionRecipe(ItemStackInput input) {
        if (input.isValid()) {
            Map<ItemStackInput, DissolutionRecipe> recipes = Recipe.CHEMICAL_DISSOLUTION_CHAMBER.get();
            DissolutionRecipe recipe = RecipeHandler.getRecipeTryWildcard(input, recipes);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static OxidationRecipe getOxidizerRecipe(ItemStackInput input) {
        if (input.isValid()) {
            Map<ItemStackInput, OxidationRecipe> recipes = Recipe.CHEMICAL_OXIDIZER.get();
            OxidationRecipe recipe = RecipeHandler.getRecipeTryWildcard(input, recipes);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static <RECIPE extends ChanceMachineRecipe<RECIPE>> RECIPE getChanceRecipe(ItemStackInput input, Map<ItemStackInput, RECIPE> recipes) {
        if (input.isValid()) {
            ChanceMachineRecipe recipe = (ChanceMachineRecipe)RecipeHandler.getRecipeTryWildcard(input, recipes);
            return (RECIPE)(recipe == null ? null : (ChanceMachineRecipe)recipe.copy());
        }
        return null;
    }

    public static <RECIPE extends BasicMachineRecipe<RECIPE>> RECIPE getRecipe(ItemStackInput input, Map<ItemStackInput, RECIPE> recipes) {
        if (input.isValid()) {
            BasicMachineRecipe recipe = (BasicMachineRecipe)RecipeHandler.getRecipeTryWildcard(input, recipes);
            return (RECIPE)(recipe == null ? null : (BasicMachineRecipe)recipe.copy());
        }
        return null;
    }

    public static <RECIPE extends AdvancedMachineRecipe<RECIPE>> RECIPE getRecipe(AdvancedMachineInput input, Map<AdvancedMachineInput, RECIPE> recipes) {
        if (input.isValid()) {
            AdvancedMachineRecipe recipe = (AdvancedMachineRecipe)recipes.get(input);
            if (recipe == null) {
                recipe = (AdvancedMachineRecipe)recipes.get(input.wildCopy());
            }
            return (RECIPE)(recipe == null ? null : (AdvancedMachineRecipe)recipe.copy());
        }
        return null;
    }

    public static <RECIPE extends DoubleMachineRecipe<RECIPE>> RECIPE getRecipe(DoubleMachineInput input, Map<DoubleMachineInput, RECIPE> recipes) {
        if (input.isValid()) {
            DoubleMachineRecipe recipe = (DoubleMachineRecipe)recipes.get(input);
            if (recipe == null) {
                recipe = (DoubleMachineRecipe)recipes.get(input.wildCopy());
            }
            return (RECIPE)(recipe == null ? null : (DoubleMachineRecipe)recipe.copy());
        }
        return null;
    }

    public static SeparatorRecipe getElectrolyticSeparatorRecipe(FluidInput input) {
        if (input.isValid()) {
            Map<FluidInput, SeparatorRecipe> recipes = Recipe.ELECTROLYTIC_SEPARATOR.get();
            SeparatorRecipe recipe = recipes.get(input);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static ThermalEvaporationRecipe getThermalEvaporationRecipe(FluidInput input) {
        if (input.isValid()) {
            Map<FluidInput, ThermalEvaporationRecipe> recipes = Recipe.THERMAL_EVAPORATION_PLANT.get();
            ThermalEvaporationRecipe recipe = recipes.get(input);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static SolarNeutronRecipe getSolarNeutronRecipe(GasInput input) {
        if (input.isValid()) {
            Map<GasInput, SolarNeutronRecipe> recipes = Recipe.SOLAR_NEUTRON_ACTIVATOR.get();
            SolarNeutronRecipe recipe = recipes.get(input);
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static PressurizedRecipe getPRCRecipe(PressurizedInput input) {
        if (input.isValid()) {
            Map<PressurizedInput, PressurizedRecipe> recipes = Recipe.PRESSURIZED_REACTION_CHAMBER.get();
            PressurizedRecipe recipe = recipes.get(input);
            if (recipe == null) {
                recipe = recipes.get(input.wildCopy());
            }
            return recipe == null ? null : recipe.copy();
        }
        return null;
    }

    public static AmbientGasRecipe getDimensionGas(IntegerInput input) {
        Map<IntegerInput, AmbientGasRecipe> recipes = Recipe.AMBIENT_ACCUMULATOR.get();
        AmbientGasRecipe recipe = recipes.get(input);
        return recipe == null ? null : recipe.copy();
    }

    public static <RECIPE extends MachineRecipe<ItemStackInput, ?, RECIPE>> boolean isInRecipe(ItemStack itemstack, Map<ItemStackInput, RECIPE> recipes) {
        if (!itemstack.func_190926_b()) {
            for (MachineRecipe recipe : recipes.values()) {
                ItemStackInput required = (ItemStackInput)recipe.getInput();
                NonNullList list = NonNullList.func_191196_a();
                list.add((Object)itemstack);
                if (!required.useItemStackFromInventory((NonNullList<ItemStack>)list, 0, false)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInPressurizedRecipe(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (PressurizedInput key : Recipe.PRESSURIZED_REACTION_CHAMBER.get().keySet()) {
                if (!key.containsType(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static <RECIPE extends MachineRecipe<ItemStackInput, ?, RECIPE>> RECIPE getRecipeTryWildcard(ItemStack stack, Map<ItemStackInput, RECIPE> recipes) {
        return RecipeHandler.getRecipeTryWildcard(new ItemStackInput(stack), recipes);
    }

    public static <RECIPE extends MachineRecipe<ItemStackInput, ?, RECIPE>> RECIPE getRecipeTryWildcard(ItemStackInput input, Map<ItemStackInput, RECIPE> recipes) {
        MachineRecipe recipe = (MachineRecipe)recipes.get(input);
        if (recipe == null) {
            recipe = (MachineRecipe)recipes.get(input.wildCopy());
        }
        return (RECIPE)recipe;
    }

    public static class Recipe<INPUT extends MachineInput<INPUT>, OUTPUT extends MachineOutput<OUTPUT>, RECIPE extends MachineRecipe<INPUT, OUTPUT, RECIPE>> {
        private static List<Recipe> values = new ArrayList<Recipe>();
        public static final Recipe<ItemStackInput, ItemStackOutput, SmeltingRecipe> ENERGIZED_SMELTER = new Recipe<ItemStackInput, ItemStackOutput, SmeltingRecipe>(BlockStateMachine.MachineType.ENERGIZED_SMELTER.blockName, ItemStackInput.class, ItemStackOutput.class, SmeltingRecipe.class);
        public static final Recipe<ItemStackInput, ItemStackOutput, EnrichmentRecipe> ENRICHMENT_CHAMBER = new Recipe<ItemStackInput, ItemStackOutput, EnrichmentRecipe>(BlockStateMachine.MachineType.ENRICHMENT_CHAMBER.blockName, ItemStackInput.class, ItemStackOutput.class, EnrichmentRecipe.class);
        public static final Recipe<AdvancedMachineInput, ItemStackOutput, OsmiumCompressorRecipe> OSMIUM_COMPRESSOR = new Recipe<AdvancedMachineInput, ItemStackOutput, OsmiumCompressorRecipe>(BlockStateMachine.MachineType.OSMIUM_COMPRESSOR.blockName, AdvancedMachineInput.class, ItemStackOutput.class, OsmiumCompressorRecipe.class);
        public static final Recipe<DoubleMachineInput, ItemStackOutput, CombinerRecipe> COMBINER = new Recipe<DoubleMachineInput, ItemStackOutput, CombinerRecipe>(BlockStateMachine.MachineType.COMBINER.blockName, DoubleMachineInput.class, ItemStackOutput.class, CombinerRecipe.class);
        public static final Recipe<ItemStackInput, ItemStackOutput, CrusherRecipe> CRUSHER = new Recipe<ItemStackInput, ItemStackOutput, CrusherRecipe>(BlockStateMachine.MachineType.CRUSHER.blockName, ItemStackInput.class, ItemStackOutput.class, CrusherRecipe.class);
        public static final Recipe<AdvancedMachineInput, ItemStackOutput, PurificationRecipe> PURIFICATION_CHAMBER = new Recipe<AdvancedMachineInput, ItemStackOutput, PurificationRecipe>(BlockStateMachine.MachineType.PURIFICATION_CHAMBER.blockName, AdvancedMachineInput.class, ItemStackOutput.class, PurificationRecipe.class);
        public static final Recipe<InfusionInput, ItemStackOutput, MetallurgicInfuserRecipe> METALLURGIC_INFUSER = new Recipe<InfusionInput, ItemStackOutput, MetallurgicInfuserRecipe>(BlockStateMachine.MachineType.METALLURGIC_INFUSER.blockName, InfusionInput.class, ItemStackOutput.class, MetallurgicInfuserRecipe.class);
        public static final Recipe<ChemicalPairInput, GasOutput, ChemicalInfuserRecipe> CHEMICAL_INFUSER = new Recipe<ChemicalPairInput, GasOutput, ChemicalInfuserRecipe>(BlockStateMachine.MachineType.CHEMICAL_INFUSER.blockName, ChemicalPairInput.class, GasOutput.class, ChemicalInfuserRecipe.class);
        public static final Recipe<ItemStackInput, GasOutput, OxidationRecipe> CHEMICAL_OXIDIZER = new Recipe<ItemStackInput, GasOutput, OxidationRecipe>(BlockStateMachine.MachineType.CHEMICAL_OXIDIZER.blockName, ItemStackInput.class, GasOutput.class, OxidationRecipe.class);
        public static final Recipe<AdvancedMachineInput, ItemStackOutput, InjectionRecipe> CHEMICAL_INJECTION_CHAMBER = new Recipe<AdvancedMachineInput, ItemStackOutput, InjectionRecipe>(BlockStateMachine.MachineType.CHEMICAL_INJECTION_CHAMBER.blockName, AdvancedMachineInput.class, ItemStackOutput.class, InjectionRecipe.class);
        public static final Recipe<FluidInput, ChemicalPairOutput, SeparatorRecipe> ELECTROLYTIC_SEPARATOR = new Recipe<FluidInput, ChemicalPairOutput, SeparatorRecipe>(BlockStateMachine.MachineType.ELECTROLYTIC_SEPARATOR.blockName, FluidInput.class, ChemicalPairOutput.class, SeparatorRecipe.class);
        public static final Recipe<ItemStackInput, ChanceOutput, SawmillRecipe> PRECISION_SAWMILL = new Recipe<ItemStackInput, ChanceOutput, SawmillRecipe>(BlockStateMachine.MachineType.PRECISION_SAWMILL.blockName, ItemStackInput.class, ChanceOutput.class, SawmillRecipe.class);
        public static final Recipe<ItemStackInput, GasOutput, DissolutionRecipe> CHEMICAL_DISSOLUTION_CHAMBER = new Recipe<ItemStackInput, GasOutput, DissolutionRecipe>(BlockStateMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER.blockName, ItemStackInput.class, GasOutput.class, DissolutionRecipe.class);
        public static final Recipe<GasInput, GasOutput, WasherRecipe> CHEMICAL_WASHER = new Recipe<GasInput, GasOutput, WasherRecipe>(BlockStateMachine.MachineType.CHEMICAL_WASHER.blockName, GasInput.class, GasOutput.class, WasherRecipe.class);
        public static final Recipe<GasInput, ItemStackOutput, CrystallizerRecipe> CHEMICAL_CRYSTALLIZER = new Recipe<GasInput, ItemStackOutput, CrystallizerRecipe>(BlockStateMachine.MachineType.CHEMICAL_CRYSTALLIZER.blockName, GasInput.class, ItemStackOutput.class, CrystallizerRecipe.class);
        public static final Recipe<PressurizedInput, PressurizedOutput, PressurizedRecipe> PRESSURIZED_REACTION_CHAMBER = new Recipe<PressurizedInput, PressurizedOutput, PressurizedRecipe>(BlockStateMachine.MachineType.PRESSURIZED_REACTION_CHAMBER.blockName, PressurizedInput.class, PressurizedOutput.class, PressurizedRecipe.class);
        public static final Recipe<IntegerInput, GasOutput, AmbientGasRecipe> AMBIENT_ACCUMULATOR = new Recipe<IntegerInput, GasOutput, AmbientGasRecipe>(BlockStateMachine.MachineType.AMBIENT_ACCUMULATOR.blockName, IntegerInput.class, GasOutput.class, AmbientGasRecipe.class);
        public static final Recipe<FluidInput, FluidOutput, ThermalEvaporationRecipe> THERMAL_EVAPORATION_PLANT = new Recipe<FluidInput, FluidOutput, ThermalEvaporationRecipe>("ThermalEvaporationPlant", FluidInput.class, FluidOutput.class, ThermalEvaporationRecipe.class);
        public static final Recipe<GasInput, GasOutput, SolarNeutronRecipe> SOLAR_NEUTRON_ACTIVATOR = new Recipe<GasInput, GasOutput, SolarNeutronRecipe>(BlockStateMachine.MachineType.SOLAR_NEUTRON_ACTIVATOR.blockName, GasInput.class, GasOutput.class, SolarNeutronRecipe.class);
        private HashMap<INPUT, RECIPE> recipes;
        private String recipeName;
        private Class<INPUT> inputClass;
        private Class<OUTPUT> outputClass;
        private Class<RECIPE> recipeClass;
        public final String jeiRecipeUid;

        public static List<Recipe> values() {
            return values;
        }

        Recipe(String name, Class<INPUT> input, Class<OUTPUT> output, Class<RECIPE> recipe) {
            this.recipeName = name;
            this.inputClass = input;
            this.outputClass = output;
            this.recipeClass = recipe;
            this.recipes = new HashMap();
            this.jeiRecipeUid = "mekanism." + this.recipeName.toLowerCase(Locale.ROOT);
            values.add(this);
        }

        public void put(RECIPE recipe) {
            this.recipes.put(((MachineRecipe)recipe).getInput(), recipe);
        }

        public void remove(RECIPE recipe) {
            this.recipes.remove(((MachineRecipe)recipe).getInput());
        }

        public String getRecipeName() {
            return this.recipeName;
        }

        public INPUT createInput(NBTTagCompound nbtTags) {
            try {
                MachineInput input = (MachineInput)this.inputClass.newInstance();
                input.load(nbtTags);
                return (INPUT)input;
            }
            catch (Exception e) {
                return null;
            }
        }

        public RECIPE createRecipe(INPUT input, NBTTagCompound nbtTags) {
            try {
                MachineOutput output = (MachineOutput)this.outputClass.newInstance();
                output.load(nbtTags);
                try {
                    Constructor<RECIPE> construct = this.recipeClass.getDeclaredConstructor(this.inputClass, this.outputClass);
                    return (RECIPE)((MachineRecipe)construct.newInstance(input, output));
                }
                catch (Exception e) {
                    Constructor<RECIPE> construct = this.recipeClass.getDeclaredConstructor(this.inputClass, this.outputClass, NBTTagCompound.class);
                    return (RECIPE)((MachineRecipe)construct.newInstance(input, output, nbtTags));
                }
            }
            catch (Exception e) {
                return null;
            }
        }

        public boolean containsRecipe(ItemStack input) {
            for (Map.Entry<INPUT, RECIPE> obj : this.get().entrySet()) {
                ItemStack stack;
                Map.Entry<INPUT, RECIPE> entry;
                if (!(obj instanceof Map.Entry) || !((entry = obj).getKey() instanceof ItemStackInput ? StackUtils.equalsWildcard(stack = ((ItemStackInput)entry.getKey()).ingredient, input) : (entry.getKey() instanceof FluidInput ? ((FluidInput)entry.getKey()).ingredient.isFluidEqual(input) : entry.getKey() instanceof AdvancedMachineInput && StackUtils.equalsWildcard(stack = ((AdvancedMachineInput)entry.getKey()).itemStack, input)))) continue;
                return true;
            }
            return false;
        }

        public boolean containsRecipe(Fluid input) {
            for (Map.Entry<INPUT, RECIPE> obj : this.get().entrySet()) {
                Map.Entry<INPUT, RECIPE> entry;
                if (!(obj instanceof Map.Entry) || !((entry = obj).getKey() instanceof FluidInput) || ((FluidInput)entry.getKey()).ingredient.getFluid() != input) continue;
                return true;
            }
            return false;
        }

        public boolean containsRecipe(Gas input) {
            for (Map.Entry<INPUT, RECIPE> obj : this.get().entrySet()) {
                Map.Entry<INPUT, RECIPE> entry;
                if (!(obj instanceof Map.Entry) || !((entry = obj).getKey() instanceof GasInput) || ((GasInput)entry.getKey()).ingredient.getGas() != input) continue;
                return true;
            }
            return false;
        }

        public Map<INPUT, RECIPE> get() {
            return this.recipes;
        }

        static {
            values = ImmutableList.copyOf(values);
        }
    }
}

