/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.Set;
import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.item.ItemScubaTank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketScubaTankData
implements IMessageHandler<ScubaTankDataMessage, IMessage> {
    public IMessage onMessage(ScubaTankDataMessage message, MessageContext context) {
        ItemStack stack;
        EntityPlayer player = PacketHandler.getPlayer(context);
        if (message.packetType == ScubaTankPacket.UPDATE) {
            if (message.value) {
                Mekanism.gasmaskOn.add(message.userId);
            } else {
                Mekanism.gasmaskOn.remove(message.userId);
            }
            if (!player.field_70170_p.field_72995_K) {
                Mekanism.packetHandler.sendToDimension(new ScubaTankDataMessage(ScubaTankPacket.UPDATE, message.userId, message.value), player.field_70170_p.field_73011_w.getDimension());
            }
        } else if (message.packetType == ScubaTankPacket.MODE && !(stack = player.func_184582_a(EntityEquipmentSlot.CHEST)).func_190926_b() && stack.func_77973_b() instanceof ItemScubaTank) {
            ((ItemScubaTank)stack.func_77973_b()).toggleFlowing(stack);
        }
        return null;
    }

    public static enum ScubaTankPacket {
        UPDATE,
        FULL,
        MODE;

    }

    public static class ScubaTankDataMessage
    implements IMessage {
        public ScubaTankPacket packetType;
        public UUID userId;
        public boolean value;

        public ScubaTankDataMessage() {
        }

        public ScubaTankDataMessage(ScubaTankPacket type, UUID name, boolean state) {
            this.packetType = type;
            if (this.packetType == ScubaTankPacket.UPDATE) {
                this.userId = name;
                this.value = state;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            if (this.packetType == ScubaTankPacket.UPDATE) {
                PacketHandler.writeUUID(dataStream, this.userId);
                dataStream.writeBoolean(this.value);
            } else if (this.packetType == ScubaTankPacket.FULL) {
                dataStream.writeInt(Mekanism.gasmaskOn.size());
                Set<UUID> set = Mekanism.gasmaskOn;
                synchronized (set) {
                    for (UUID name : Mekanism.gasmaskOn) {
                        PacketHandler.writeUUID(dataStream, name);
                    }
                }
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = ScubaTankPacket.values()[dataStream.readInt()];
            if (this.packetType == ScubaTankPacket.FULL) {
                Mekanism.gasmaskOn.clear();
                int amount = dataStream.readInt();
                for (int i = 0; i < amount; ++i) {
                    Mekanism.gasmaskOn.add(PacketHandler.readUUID(dataStream));
                }
            } else if (this.packetType == ScubaTankPacket.UPDATE) {
                this.userId = PacketHandler.readUUID(dataStream);
                this.value = dataStream.readBoolean();
            }
        }
    }
}

