/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.entity;

import cofh.redstoneflux.api.IEnergyContainerItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.energy.EnergizedItemManager;
import mekanism.api.energy.IEnergizedItem;
import mekanism.common.Mekanism;
import mekanism.common.MekanismItems;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.entity.ai.RobitAIFollow;
import mekanism.common.entity.ai.RobitAIPickup;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemRobit;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="micdoodle8.mods.galacticraft.api.entity.IEntityBreathable", modid="Galacticraft API")
public class EntityRobit
extends EntityCreature
implements IInventory,
ISustainedInventory,
IEntityBreathable {
    public double MAX_ELECTRICITY = 100000.0;
    public Coord4D homeLocation;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)31, (Object)ItemStack.field_190927_a);
    public int furnaceBurnTime = 0;
    public int currentItemBurnTime = 0;
    public int furnaceCookTime = 0;
    public boolean texTick;
    private static final DataParameter<Float> ELECTRICITY = EntityDataManager.func_187226_a(EntityRobit.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<String> OWNER_UUID = EntityDataManager.func_187226_a(EntityRobit.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<String> OWNER_NAME = EntityDataManager.func_187226_a(EntityRobit.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> FOLLOW = EntityDataManager.func_187226_a(EntityRobit.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> DROP_PICKUP = EntityDataManager.func_187226_a(EntityRobit.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityRobit(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
        this.getNavigator().func_179693_d(false);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new RobitAIPickup(this, 1.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new RobitAIFollow(this, 1.0f, 4.0f, 2.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.func_174805_g(true);
    }

    public EntityRobit(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public PathNavigateGround getNavigator() {
        return (PathNavigateGround)this.field_70699_by;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ELECTRICITY, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(OWNER_UUID, (Object)"");
        this.field_70180_af.func_187214_a(OWNER_NAME, (Object)"");
        this.field_70180_af.func_187214_a(FOLLOW, (Object)false);
        this.field_70180_af.func_187214_a(DROP_PICKUP, (Object)false);
    }

    public double getRoundedTravelEnergy() {
        return new BigDecimal(this.func_70011_f(this.field_70169_q, this.field_70167_r, this.field_70166_s) * 1.5).setScale(2, RoundingMode.HALF_EVEN).doubleValue();
    }

    public void func_70030_z() {
        if (!this.field_70170_p.field_72995_K && this.getFollowing() && this.getOwner() != null && this.func_70068_e((Entity)this.getOwner()) > 4.0 && !this.getNavigator().func_75500_f() && this.getEnergy() > 0.0) {
            this.setEnergy(this.getEnergy() - this.getRoundedTravelEnergy());
        }
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            ItemStack stack;
            WorldServer serverWorld;
            if (this.getDropPickup()) {
                this.collectItems();
            }
            if (this.homeLocation == null) {
                this.func_70106_y();
                return;
            }
            if (this.field_70173_aa % 20 == 0 && this.homeLocation.exists((World)(serverWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.homeLocation.dimensionId))) && !(this.homeLocation.getTileEntity((IBlockAccess)serverWorld) instanceof TileEntityChargepad)) {
                this.drop();
                this.func_70106_y();
            }
            if (this.getEnergy() == 0.0 && !this.isOnChargepad()) {
                this.goHome();
            }
            if (!(stack = (ItemStack)this.inventory.get(27)).func_190926_b() && this.getEnergy() < this.MAX_ELECTRICITY) {
                if (stack.func_77973_b() instanceof IEnergizedItem) {
                    this.setEnergy(this.getEnergy() + EnergizedItemManager.discharge(stack, this.MAX_ELECTRICITY - this.getEnergy()));
                } else if (MekanismUtils.useTesla() && stack.hasCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null)) {
                    ITeslaProducer producer = (ITeslaProducer)stack.getCapability(Capabilities.TESLA_PRODUCER_CAPABILITY, null);
                    long needed = Math.round((this.MAX_ELECTRICITY - this.getEnergy()) * MekanismConfig.current().general.TO_TESLA.val());
                    this.setEnergy(this.getEnergy() + (double)producer.takePower(needed, false) * MekanismConfig.current().general.FROM_TESLA.val());
                } else if (MekanismUtils.useForge() && stack.hasCapability(CapabilityEnergy.ENERGY, null)) {
                    IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
                    if (storage.canExtract()) {
                        int needed = (int)Math.round(Math.min(2.147483647E9, (this.MAX_ELECTRICITY - this.getEnergy()) * MekanismConfig.current().general.TO_FORGE.val()));
                        this.setEnergy(this.getEnergy() + (double)storage.extractEnergy(needed, false) * MekanismConfig.current().general.FROM_FORGE.val());
                    }
                } else if (MekanismUtils.useRF() && stack.func_77973_b() instanceof IEnergyContainerItem) {
                    IEnergyContainerItem item = (IEnergyContainerItem)stack.func_77973_b();
                    int needed = (int)Math.round(Math.min(2.147483647E9, (this.MAX_ELECTRICITY - this.getEnergy()) * MekanismConfig.current().general.TO_RF.val()));
                    this.setEnergy(this.getEnergy() + (double)item.extractEnergy(stack, needed, false) * MekanismConfig.current().general.FROM_RF.val());
                } else if (MekanismUtils.useIC2() && stack.func_77973_b() instanceof IElectricItem) {
                    IElectricItem item = (IElectricItem)stack.func_77973_b();
                    if (item.canProvideEnergy(stack)) {
                        double gain = ElectricItem.manager.discharge(stack, (this.MAX_ELECTRICITY - this.getEnergy()) * MekanismConfig.current().general.TO_IC2.val(), 4, true, true, false) * MekanismConfig.current().general.FROM_IC2.val();
                        this.setEnergy(this.getEnergy() + gain);
                    }
                } else if (stack.func_77973_b() == Items.field_151137_ax && this.getEnergy() + MekanismConfig.current().general.ENERGY_PER_REDSTONE.val() <= this.MAX_ELECTRICITY) {
                    this.setEnergy(this.getEnergy() + MekanismConfig.current().general.ENERGY_PER_REDSTONE.val());
                    stack.func_190918_g(1);
                }
            }
            if (this.furnaceBurnTime > 0) {
                --this.furnaceBurnTime;
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)((ItemStack)this.inventory.get(29)));
                    if (this.furnaceBurnTime > 0 && !((ItemStack)this.inventory.get(29)).func_190926_b()) {
                        ((ItemStack)this.inventory.get(29)).func_190918_g(1);
                        if (((ItemStack)this.inventory.get(29)).func_190916_E() == 0) {
                            this.inventory.set(29, (Object)((ItemStack)this.inventory.get(29)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(29)));
                        }
                    }
                }
                if (this.furnaceBurnTime > 0 && this.canSmelt()) {
                    ++this.furnaceCookTime;
                    if (this.furnaceCookTime == 200) {
                        this.furnaceCookTime = 0;
                        this.smeltItem();
                    }
                } else {
                    this.furnaceCookTime = 0;
                }
            }
        }
    }

    private void collectItems() {
        List items = this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72314_b(1.5, 1.5, 1.5));
        if (items != null && !items.isEmpty()) {
            block0: for (EntityItem item : items) {
                if (item.func_174874_s() || item.func_92059_d().func_77973_b() instanceof ItemRobit || item.field_70128_L) continue;
                for (int i = 0; i < 27; ++i) {
                    ItemStack itemStack = (ItemStack)this.inventory.get(i);
                    if (itemStack.func_190926_b()) {
                        this.inventory.set(i, (Object)item.func_92059_d());
                        this.func_71001_a((Entity)item, item.func_92059_d().func_190916_E());
                        item.func_70106_y();
                        this.func_184185_a(SoundEvents.field_187638_cR, 1.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                        continue block0;
                    }
                    if (!itemStack.func_77969_a(item.func_92059_d()) || itemStack.func_190916_E() >= itemStack.func_77976_d()) continue;
                    int needed = itemStack.func_77976_d() - itemStack.func_190916_E();
                    int toAdd = Math.min(needed, item.func_92059_d().func_190916_E());
                    itemStack.func_190917_f(toAdd);
                    item.func_92059_d().func_190918_g(toAdd);
                    this.func_71001_a((Entity)item, toAdd);
                    if (item.func_92059_d().func_190916_E() == 0) {
                        item.func_70106_y();
                    }
                    this.func_184185_a(SoundEvents.field_187638_cR, 1.0f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    continue block0;
                }
            }
        }
    }

    public void goHome() {
        this.setFollowing(false);
        if (this.field_70170_p.field_73011_w.getDimension() != this.homeLocation.dimensionId) {
            this.func_184204_a(this.homeLocation.dimensionId);
        }
        this.func_70634_a((double)this.homeLocation.x + 0.5, (double)this.homeLocation.y + 0.3, (double)this.homeLocation.z + 0.5);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    private boolean canSmelt() {
        if (((ItemStack)this.inventory.get(28)).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.inventory.get(28));
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.inventory.get(30)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.inventory.get(30)).func_77969_a(itemstack)) {
            return false;
        }
        int result = ((ItemStack)this.inventory.get(30)).func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a((ItemStack)this.inventory.get(28));
            if (((ItemStack)this.inventory.get(30)).func_190926_b()) {
                this.inventory.set(30, (Object)itemstack.func_77946_l());
            } else if (((ItemStack)this.inventory.get(30)).func_77969_a(itemstack)) {
                ((ItemStack)this.inventory.get(30)).func_190917_f(itemstack.func_190916_E());
            }
            ((ItemStack)this.inventory.get(28)).func_190918_g(1);
        }
    }

    public boolean isOnChargepad() {
        BlockPos pos = new BlockPos((Entity)this);
        return this.field_70170_p.func_175625_s(pos) instanceof TileEntityChargepad;
    }

    public EnumActionResult func_184199_a(EntityPlayer entityplayer, Vec3d vec, EnumHand hand) {
        ItemStack stack = entityplayer.func_184586_b(hand);
        if (entityplayer.func_70093_af()) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator) {
                if (!this.field_70170_p.field_72995_K) {
                    this.drop();
                }
                this.func_70106_y();
                entityplayer.func_184609_a(hand);
                return EnumActionResult.SUCCESS;
            }
        } else {
            entityplayer.openGui((Object)Mekanism.instance, 21, this.field_70170_p, this.func_145782_y(), 0, 0);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void drop() {
        EntityItem entityItem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.3, this.field_70161_v, new ItemStack((Item)MekanismItems.Robit));
        ItemRobit item = (ItemRobit)entityItem.func_92059_d().func_77973_b();
        item.setEnergy(entityItem.func_92059_d(), this.getEnergy());
        item.setInventory(this.getInventory(new Object[0]), entityItem.func_92059_d());
        item.setName(entityItem.func_92059_d(), this.func_70005_c_());
        float k = 0.05f;
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = this.field_70146_Z.nextGaussian() * (double)k + (double)0.2f;
        entityItem.field_70179_y = 0.0;
        this.field_70170_p.func_72838_d((Entity)entityItem);
    }

    public void func_70014_b(NBTTagCompound nbtTags) {
        super.func_70014_b(nbtTags);
        nbtTags.func_74780_a("electricityStored", this.getEnergy());
        nbtTags.func_74778_a("name", this.func_70005_c_());
        if (this.getOwnerUUID() != null) {
            nbtTags.func_74778_a("ownerUUID", this.getOwnerUUID().toString());
        }
        nbtTags.func_74757_a("follow", this.getFollowing());
        nbtTags.func_74757_a("dropPickup", this.getDropPickup());
        if (this.homeLocation != null) {
            this.homeLocation.write(nbtTags);
        }
        NBTTagList tagList = new NBTTagList();
        for (int slotCount = 0; slotCount < this.inventory.size(); ++slotCount) {
            if (((ItemStack)this.inventory.get(slotCount)).func_190926_b()) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)slotCount);
            ((ItemStack)this.inventory.get(slotCount)).func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTags.func_74782_a("Items", (NBTBase)tagList);
    }

    public void func_70037_a(NBTTagCompound nbtTags) {
        super.func_70037_a(nbtTags);
        this.setEnergy(nbtTags.func_74769_h("electricityStored"));
        this.func_96094_a(nbtTags.func_74779_i("name"));
        if (nbtTags.func_74764_b("ownerUUID")) {
            this.setOwnerUUID(UUID.fromString(nbtTags.func_74779_i("ownerUUID")));
        }
        this.setFollowing(nbtTags.func_74767_n("follow"));
        this.setDropPickup(nbtTags.func_74767_n("dropPickup"));
        this.homeLocation = Coord4D.read(nbtTags);
        NBTTagList tagList = nbtTags.func_150295_c("Items", 10);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int tagCount = 0; tagCount < tagList.func_74745_c(); ++tagCount) {
            NBTTagCompound tagCompound = tagList.func_150305_b(tagCount);
            byte slotID = tagCompound.func_74771_c("Slot");
            if (slotID < 0 || slotID >= this.inventory.size()) continue;
            this.inventory.set((int)slotID, (Object)InventoryUtils.loadFromNBT(tagCompound));
        }
    }

    protected void func_70665_d(DamageSource damageSource, float amount) {
        if ((amount = ForgeHooks.onLivingHurt((EntityLivingBase)this, (DamageSource)damageSource, (float)amount)) <= 0.0f) {
            return;
        }
        amount = this.func_70655_b(damageSource, amount);
        amount = this.func_70672_c(damageSource, amount);
        float j = this.func_110143_aJ();
        this.setEnergy(Math.max(0.0, this.getEnergy() - (double)(amount * 1000.0f)));
        this.func_110142_aN().func_94547_a(damageSource, j, amount);
    }

    protected void func_70609_aI() {
    }

    public void setHome(Coord4D home) {
        this.homeLocation = home;
    }

    public boolean func_70104_M() {
        return this.getEnergy() > 0.0;
    }

    public double getEnergy() {
        return ((Float)this.field_70180_af.func_187225_a(ELECTRICITY)).floatValue();
    }

    public void setEnergy(double energy) {
        this.field_70180_af.func_187227_b(ELECTRICITY, (Object)Float.valueOf((float)Math.max(Math.min(energy, this.MAX_ELECTRICITY), 0.0)));
    }

    public EntityPlayer getOwner() {
        return this.field_70170_p.func_152378_a(this.getOwnerUUID());
    }

    public String getOwnerName() {
        return (String)this.field_70180_af.func_187225_a(OWNER_NAME);
    }

    public UUID getOwnerUUID() {
        return UUID.fromString((String)this.field_70180_af.func_187225_a(OWNER_UUID));
    }

    public void setOwnerUUID(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER_UUID, (Object)uuid.toString());
        this.field_70180_af.func_187227_b(OWNER_NAME, (Object)MekanismUtils.getLastKnownUsername(uuid));
    }

    public boolean getFollowing() {
        return (Boolean)this.field_70180_af.func_187225_a(FOLLOW);
    }

    public void setFollowing(boolean follow) {
        this.field_70180_af.func_187227_b(FOLLOW, (Object)follow);
    }

    public boolean getDropPickup() {
        return (Boolean)this.field_70180_af.func_187225_a(DROP_PICKUP);
    }

    public void setDropPickup(boolean pickup) {
        this.field_70180_af.func_187227_b(DROP_PICKUP, (Object)pickup);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int slotID) {
        return (ItemStack)this.inventory.get(slotID);
    }

    public ItemStack func_70298_a(int slotID, int amount) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)slotID, (int)amount);
    }

    public ItemStack func_70304_b(int slotID) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)slotID);
    }

    public void func_70299_a(int slotID, ItemStack itemstack) {
        this.inventory.set(slotID, (Object)itemstack);
        if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
            itemstack.func_190920_e(this.func_70297_j_());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (nbtTags == null || nbtTags.func_74745_c() == 0) {
            return;
        }
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int slots = 0; slots < nbtTags.func_74745_c(); ++slots) {
            NBTTagCompound tagCompound = nbtTags.func_150305_b(slots);
            byte slotID = tagCompound.func_74771_c("Slot");
            if (slotID < 0 || slotID >= this.inventory.size()) continue;
            this.inventory.set((int)slotID, (Object)InventoryUtils.loadFromNBT(tagCompound));
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        NBTTagList tagList = new NBTTagList();
        for (int slots = 0; slots < this.inventory.size(); ++slots) {
            if (((ItemStack)this.inventory.get(slots)).func_190926_b()) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)slots);
            ((ItemStack)this.inventory.get(slots)).func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        return tagList;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean canBreath() {
        return true;
    }
}

