/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import java.util.Random;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.IMekWrench;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.base.IFactory;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ISustainedTank;
import mekanism.common.base.ITierItem;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.states.BlockStateFacing;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.integration.wrenches.Wrenches;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.TileEntityLaser;
import mekanism.common.tile.TileEntityLaserAmplifier;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntityMetallurgicInfuser;
import mekanism.common.tile.TileEntityPersonalChest;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.MultipartUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockMachine
extends BlockContainer {
    private static final AxisAlignedBB CHARGEPAD_BOUNDS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.06f, 1.0);
    private static final AxisAlignedBB TANK_BOUNDS = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    private static final AxisAlignedBB LASER_BOUNDS = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    private static final AxisAlignedBB LOGISTICAL_SORTER_BOUNDS = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public BlockMachine() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(16.0f);
        this.func_149647_a(Mekanism.tabMekanism);
    }

    public static BlockMachine getBlockMachine(final BlockStateMachine.MachineBlock block) {
        return new BlockMachine(){

            @Override
            public BlockStateMachine.MachineBlock getMachineBlock() {
                return block;
            }
        };
    }

    public abstract BlockStateMachine.MachineBlock getMachineBlock();

    public BlockStateContainer func_180661_e() {
        return new BlockStateMachine(this, this.getTypeProperty());
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        BlockStateMachine.MachineType type = BlockStateMachine.MachineType.get(this.getMachineBlock(), meta & 0xF);
        return this.func_176223_P().func_177226_a(this.getTypeProperty(), (Comparable)((Object)type));
    }

    public int func_176201_c(IBlockState state) {
        BlockStateMachine.MachineType type = (BlockStateMachine.MachineType)((Object)state.func_177229_b(this.getTypeProperty()));
        return type.meta;
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = MekanismUtils.getTileEntitySafe(worldIn, pos);
        if (tile instanceof TileEntityBasicBlock && ((TileEntityBasicBlock)tile).facing != null) {
            state = state.func_177226_a((IProperty)BlockStateFacing.facingProperty, (Comparable)((TileEntityBasicBlock)tile).facing);
        }
        if (tile instanceof IActiveState) {
            state = state.func_177226_a((IProperty)BlockStateMachine.activeProperty, (Comparable)Boolean.valueOf(((IActiveState)tile).getActive()));
        }
        if (tile instanceof TileEntityFluidTank) {
            state = state.func_177226_a(BlockStateMachine.tierProperty, (Comparable)((Object)((TileEntityFluidTank)tile).tier.getBaseTier()));
        }
        if (tile instanceof TileEntityFactory) {
            state = state.func_177226_a(BlockStateMachine.recipeProperty, (Comparable)((Object)((TileEntityFactory)tile).recipeType));
        }
        return state;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityLogisticalSorter transporter;
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        int side = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int height = Math.round(placer.field_70125_A);
        int change = 3;
        if (tileEntity == null) {
            return;
        }
        if (tileEntity.canSetFacing(0) && tileEntity.canSetFacing(1)) {
            if (height >= 65) {
                change = 1;
            } else if (height <= -65) {
                change = 0;
            }
        }
        if (change != 0 && change != 1) {
            switch (side) {
                case 0: {
                    change = 2;
                    break;
                }
                case 1: {
                    change = 5;
                    break;
                }
                case 2: {
                    change = 3;
                    break;
                }
                case 3: {
                    change = 4;
                }
            }
        }
        tileEntity.setFacing((short)change);
        boolean bl = tileEntity.redstone = world.func_175687_A(pos) > 0;
        if (tileEntity instanceof TileEntityLogisticalSorter && !(transporter = (TileEntityLogisticalSorter)tileEntity).hasInventory()) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                TileEntity tile = Coord4D.get(transporter).offset(dir).getTileEntity((IBlockAccess)world);
                if (!(tile instanceof IInventory)) continue;
                tileEntity.setFacing((short)dir.func_176734_d().ordinal());
                break;
            }
        }
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)((Object)tileEntity)).onPlace();
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)((Object)tileEntity)).onBreak();
        }
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityFluidTank) {
            return;
        }
        if (MekanismUtils.isActive((IBlockAccess)world, pos) && ((IActiveState)((Object)tileEntity)).renderUpdate() && MekanismConfig.current().client.machineEffects.val()) {
            float xRandom = (float)pos.func_177958_n() + 0.5f;
            float yRandom = (float)pos.func_177956_o() + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float zRandom = (float)pos.func_177952_p() + 0.5f;
            float iRandom = 0.52f;
            float jRandom = random.nextFloat() * 0.6f - 0.3f;
            EnumFacing side = tileEntity.facing;
            if (tileEntity instanceof TileEntityMetallurgicInfuser) {
                side = side.func_176734_d();
            }
            switch (side) {
                case WEST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(xRandom - iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.REDSTONE, (double)(xRandom - iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(xRandom + iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.REDSTONE, (double)(xRandom + iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom - iRandom), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.REDSTONE, (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom - iRandom), 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom + iRandom), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.REDSTONE, (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom + iRandom), 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
            }
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity;
        if (MekanismConfig.current().client.enableAmbientLighting.val() && (tileEntity = MekanismUtils.getTileEntitySafe(world, pos)) instanceof IActiveState && ((IActiveState)tileEntity).getActive() && ((IActiveState)tileEntity).lightUpdate()) {
            return MekanismConfig.current().client.ambientLightingLevel.val();
        }
        return 0;
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177230_c().func_176201_c(state);
    }

    public void func_149666_a(CreativeTabs creativetabs, NonNullList<ItemStack> list) {
        block4: for (BlockStateMachine.MachineType type : BlockStateMachine.MachineType.getValidMachines()) {
            if (type.typeBlock != this.getMachineBlock() || !type.isEnabled()) continue;
            switch (type) {
                case BASIC_FACTORY: 
                case ADVANCED_FACTORY: 
                case ELITE_FACTORY: {
                    for (IFactory.RecipeType recipe : IFactory.RecipeType.values()) {
                        ItemStack stack = new ItemStack((Block)this, 1, type.meta);
                        ((IFactory)stack.func_77973_b()).setRecipeType(recipe.ordinal(), stack);
                        list.add((Object)stack);
                    }
                    continue block4;
                }
                case FLUID_TANK: {
                    ItemBlockMachine itemMachine = (ItemBlockMachine)Item.func_150898_a((Block)this);
                    for (Tier.FluidTankTier tier : Tier.FluidTankTier.values()) {
                        ItemStack stack = new ItemStack((Block)this, 1, type.meta);
                        itemMachine.setBaseTier(stack, tier.getBaseTier());
                        list.add((Object)stack);
                    }
                    continue block4;
                }
                default: {
                    list.add((Object)new ItemStack((Block)this, 1, type.meta));
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        RayTraceResult raytrace;
        IMekWrench wrenchHandler;
        if (world.field_72995_K) {
            return true;
        }
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        int metadata = state.func_177230_c().func_176201_c(state);
        ItemStack stack = entityplayer.func_184586_b(hand);
        if (!stack.func_190926_b() && (wrenchHandler = Wrenches.getHandler(stack)) != null && wrenchHandler.canUseWrench(entityplayer, hand, stack, raytrace = new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos))) {
            if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                wrenchHandler.wrenchUsed(entityplayer, hand, stack, raytrace);
                if (entityplayer.func_70093_af()) {
                    this.dismantleBlock(state, world, pos, false);
                    return true;
                }
                if (tileEntity != null) {
                    int change = tileEntity.facing.func_176746_e().ordinal();
                    if (tileEntity instanceof TileEntityLogisticalSorter && !((TileEntityLogisticalSorter)tileEntity).hasInventory()) {
                        for (EnumFacing dir : EnumFacing.field_82609_l) {
                            TileEntity tile = Coord4D.get(tileEntity).offset(dir).getTileEntity((IBlockAccess)world);
                            if (!(tile instanceof IInventory)) continue;
                            change = dir.func_176734_d().ordinal();
                            break;
                        }
                    }
                    tileEntity.setFacing((short)change);
                    world.func_175685_c(pos, (Block)this, true);
                }
            } else {
                SecurityUtils.displayNoAccess(entityplayer);
            }
            return true;
        }
        if (tileEntity != null) {
            BlockStateMachine.MachineType type = BlockStateMachine.MachineType.get(this.getMachineBlock(), metadata);
            switch (type) {
                case PERSONAL_CHEST: {
                    if (entityplayer.func_70093_af() || world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN)) break;
                    TileEntityPersonalChest chest = (TileEntityPersonalChest)tileEntity;
                    if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                        MekanismUtils.openPersonalChestGui((EntityPlayerMP)entityplayer, chest, null, true);
                    } else {
                        SecurityUtils.displayNoAccess(entityplayer);
                    }
                    return true;
                }
                case FLUID_TANK: {
                    if (entityplayer.func_70093_af()) break;
                    if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                        if (!stack.func_190926_b() && FluidContainerUtils.isFluidContainer(stack)) {
                            if (this.manageInventory(entityplayer, (TileEntityFluidTank)tileEntity, hand, stack)) {
                                entityplayer.field_71071_by.func_70296_d();
                                return true;
                            }
                        } else {
                            entityplayer.openGui((Object)Mekanism.instance, type.guiId, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        }
                    } else {
                        SecurityUtils.displayNoAccess(entityplayer);
                    }
                    return true;
                }
                case LOGISTICAL_SORTER: {
                    if (entityplayer.func_70093_af()) break;
                    if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                        PacketLogisticalSorterGui.LogisticalSorterGuiMessage.openServerGui(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, 0, world, (EntityPlayerMP)entityplayer, Coord4D.get(tileEntity), -1);
                    } else {
                        SecurityUtils.displayNoAccess(entityplayer);
                    }
                    return true;
                }
                case TELEPORTER: 
                case QUANTUM_ENTANGLOPORTER: {
                    if (entityplayer.func_70093_af()) break;
                    UUID owner = ((ISecurityTile)((Object)tileEntity)).getSecurity().getOwnerUUID();
                    if (MekanismUtils.isOp((EntityPlayer)((EntityPlayerMP)entityplayer)) || owner == null || entityplayer.func_110124_au().equals(owner)) {
                        entityplayer.openGui((Object)Mekanism.instance, type.guiId, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    } else {
                        SecurityUtils.displayNoAccess(entityplayer);
                    }
                    return true;
                }
                default: {
                    if (entityplayer.func_70093_af() || type.guiId == -1) break;
                    if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                        entityplayer.openGui((Object)Mekanism.instance, type.guiId, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    } else {
                        SecurityUtils.displayNoAccess(entityplayer);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        int metadata = state.func_177230_c().func_176201_c(state);
        if (BlockStateMachine.MachineType.get(this.getMachineBlock(), metadata) == null) {
            return null;
        }
        return BlockStateMachine.MachineType.get(this.getMachineBlock(), metadata).create();
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return null;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Deprecated
    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return SecurityUtils.canAccess(player, tile) ? super.func_180647_a(state, player, world, pos) : 0.0f;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        IBlockState state = world.func_180495_p(pos);
        if (BlockStateMachine.MachineType.get(this.getMachineBlock(), state.func_177230_c().func_176201_c(state)) != BlockStateMachine.MachineType.PERSONAL_CHEST) {
            return this.field_149781_w;
        }
        return -1.0f;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && willHarvest) {
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, this.getPickBlock(state, null, world, pos, player));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_175698_g(pos);
    }

    @Deprecated
    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    @Deprecated
    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityFluidTank) {
            return ((TileEntityFluidTank)tileEntity).getRedstoneLevel();
        }
        if (tileEntity instanceof TileEntityLaserAmplifier) {
            TileEntityLaserAmplifier amplifier = (TileEntityLaserAmplifier)tileEntity;
            if (amplifier.outputMode == TileEntityLaserAmplifier.RedstoneOutput.ENERGY_CONTENTS) {
                return amplifier.getRedstoneLevel();
            }
            return this.func_180656_a(state, (IBlockAccess)world, pos, null);
        }
        return 0;
    }

    private boolean manageInventory(EntityPlayer player, TileEntityFluidTank tileEntity, EnumHand hand, ItemStack itemStack) {
        ItemStack copyStack = StackUtils.size(itemStack.func_77946_l(), 1);
        if (FluidContainerUtils.isFluidContainer(itemStack)) {
            IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)copyStack);
            if (FluidUtil.getFluidContained((ItemStack)copyStack) == null) {
                if (tileEntity.fluidTank.getFluid() != null) {
                    int filled = handler.fill(tileEntity.fluidTank.getFluid(), !player.field_71075_bZ.field_75098_d);
                    copyStack = handler.getContainer();
                    if (filled > 0) {
                        if (itemStack.func_190916_E() == 1) {
                            player.func_184611_a(hand, copyStack);
                        } else if (itemStack.func_190916_E() > 1 && player.field_71071_by.func_70441_a(copyStack)) {
                            itemStack.func_190918_g(1);
                        } else {
                            player.func_146097_a(copyStack, false, true);
                            itemStack.func_190918_g(1);
                        }
                        if (tileEntity.tier != Tier.FluidTankTier.CREATIVE) {
                            tileEntity.fluidTank.drain(filled, true);
                        }
                        return true;
                    }
                }
            } else {
                FluidStack itemFluid = FluidUtil.getFluidContained((ItemStack)copyStack);
                int needed = tileEntity.getCurrentNeeded();
                if (tileEntity.fluidTank.getFluid() != null && !tileEntity.fluidTank.getFluid().isFluidEqual(itemFluid)) {
                    return false;
                }
                boolean filled = false;
                FluidStack drained = handler.drain(needed, !player.field_71075_bZ.field_75098_d);
                copyStack = handler.getContainer();
                if (copyStack.func_190916_E() == 0) {
                    copyStack = ItemStack.field_190927_a;
                }
                if (drained != null) {
                    if (player.field_71075_bZ.field_75098_d) {
                        filled = true;
                    } else if (!copyStack.func_190926_b()) {
                        if (itemStack.func_190916_E() == 1) {
                            player.func_184611_a(hand, copyStack);
                            filled = true;
                        } else if (player.field_71071_by.func_70441_a(copyStack)) {
                            itemStack.func_190918_g(1);
                            filled = true;
                        }
                    } else {
                        itemStack.func_190918_g(1);
                        if (itemStack.func_190916_E() == 0) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                        filled = true;
                    }
                    if (filled) {
                        int toFill = tileEntity.fluidTank.getCapacity() - tileEntity.fluidTank.getFluidAmount();
                        if (tileEntity.tier != Tier.FluidTankTier.CREATIVE) {
                            toFill = Math.min(toFill, drained.amount);
                        }
                        tileEntity.fluidTank.fill(PipeUtils.copy(drained, toFill), true);
                        if (drained.amount - toFill > 0) {
                            tileEntity.pushUp(PipeUtils.copy(itemFluid, drained.amount - toFill), true);
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        if (!world.field_72995_K) {
            TileEntityLogisticalSorter sorter;
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileEntityBasicBlock) {
                ((TileEntityBasicBlock)tileEntity).onNeighborChange(neighborBlock);
            }
            if (tileEntity instanceof TileEntityLogisticalSorter && !(sorter = (TileEntityLogisticalSorter)tileEntity).hasInventory()) {
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    TileEntity tile = Coord4D.get(tileEntity).offset(dir).getTileEntity((IBlockAccess)world);
                    if (!(tile instanceof IInventory)) continue;
                    sorter.setFacing((short)dir.func_176734_d().ordinal());
                    return;
                }
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        InventoryFrequency frequency;
        ISecurityItem securityItem;
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
        ItemStack itemStack = new ItemStack((Block)this, 1, state.func_177230_c().func_176201_c(state));
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (tileEntity instanceof TileEntityFluidTank) {
            ITierItem tierItem = (ITierItem)itemStack.func_77973_b();
            tierItem.setBaseTier(itemStack, ((TileEntityFluidTank)tileEntity).tier.getBaseTier());
        }
        if (tileEntity instanceof ISecurityTile && (securityItem = (ISecurityItem)itemStack.func_77973_b()).hasSecurity(itemStack)) {
            securityItem.setOwnerUUID(itemStack, ((ISecurityTile)((Object)tileEntity)).getSecurity().getOwnerUUID());
            securityItem.setSecurity(itemStack, ((ISecurityTile)((Object)tileEntity)).getSecurity().getMode());
        }
        if (tileEntity instanceof IUpgradeTile) {
            ((IUpgradeTile)((Object)tileEntity)).getComponent().write(ItemDataUtils.getDataMap(itemStack));
        }
        if (tileEntity instanceof ISideConfiguration) {
            ISideConfiguration config = (ISideConfiguration)((Object)tileEntity);
            config.getConfig().write(ItemDataUtils.getDataMap(itemStack));
            config.getEjector().write(ItemDataUtils.getDataMap(itemStack));
        }
        if (tileEntity instanceof ISustainedData) {
            ((ISustainedData)((Object)tileEntity)).writeSustainedData(itemStack);
        }
        if (tileEntity instanceof IRedstoneControl) {
            IRedstoneControl control = (IRedstoneControl)((Object)tileEntity);
            ItemDataUtils.setInt(itemStack, "controlType", control.getControlType().ordinal());
        }
        if (tileEntity instanceof TileEntityContainerBlock && ((TileEntityContainerBlock)tileEntity).inventory.size() > 0) {
            ISustainedInventory inventory = (ISustainedInventory)itemStack.func_77973_b();
            inventory.setInventory(((ISustainedInventory)((Object)tileEntity)).getInventory(new Object[0]), itemStack);
        }
        if (((ISustainedTank)itemStack.func_77973_b()).hasTank(itemStack) && tileEntity instanceof ISustainedTank && ((ISustainedTank)((Object)tileEntity)).getFluidStack(new Object[0]) != null) {
            ((ISustainedTank)itemStack.func_77973_b()).setFluidStack(((ISustainedTank)((Object)tileEntity)).getFluidStack(new Object[0]), itemStack);
        }
        if (tileEntity instanceof TileEntityFactory) {
            IFactory factoryItem = (IFactory)itemStack.func_77973_b();
            factoryItem.setRecipeType(((TileEntityFactory)tileEntity).recipeType.ordinal(), itemStack);
        }
        if (tileEntity instanceof IStrictEnergyStorage) {
            IEnergizedItem energizedItem = (IEnergizedItem)itemStack.func_77973_b();
            energizedItem.setEnergy(itemStack, ((IStrictEnergyStorage)((Object)tileEntity)).getEnergy());
        }
        if (tileEntity instanceof TileEntityQuantumEntangloporter && (frequency = ((TileEntityQuantumEntangloporter)tileEntity).frequency) != null) {
            ItemDataUtils.setCompound(itemStack, "entangleporter_frequency", frequency.getIdentity().serialize());
        }
        return itemStack;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        BlockStateMachine.MachineType type = BlockStateMachine.MachineType.get(this.getMachineBlock(), state.func_177230_c().func_176201_c(state));
        switch (type) {
            case LASER_AMPLIFIER: {
                return true;
            }
        }
        return false;
    }

    public ItemStack dismantleBlock(IBlockState state, World world, BlockPos pos, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(state, null, world, pos, null);
        world.func_175698_g(pos);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + motionX, (double)pos.func_177956_o() + motionY, (double)pos.func_177952_p() + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        BlockStateMachine.MachineType type = BlockStateMachine.MachineType.get(this.getMachineBlock(), state.func_177230_c().func_176201_c(state));
        TileEntity tile = MekanismUtils.getTileEntitySafe(world, pos);
        if (type == null) {
            return super.func_185496_a(state, world, pos);
        }
        switch (type) {
            case CHARGEPAD: {
                return CHARGEPAD_BOUNDS;
            }
            case FLUID_TANK: {
                return TANK_BOUNDS;
            }
            case LASER: {
                if (tile instanceof TileEntityLaser) {
                    return MultipartUtils.rotate(LASER_BOUNDS.func_72317_d(-0.5, -0.5, -0.5), ((TileEntityLaser)tile).facing).func_72317_d(0.5, 0.5, 0.5);
                }
            }
            case LOGISTICAL_SORTER: {
                if (!(tile instanceof TileEntityLogisticalSorter)) break;
                return MultipartUtils.rotate(LOGISTICAL_SORTER_BOUNDS.func_72317_d(-0.5, -0.5, -0.5), ((TileEntityLogisticalSorter)tile).facing).func_72317_d(0.5, 0.5, 0.5);
            }
        }
        return super.func_185496_a(state, world, pos);
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        BlockStateMachine.MachineType type = BlockStateMachine.MachineType.get(this.getMachineBlock(), state.func_177230_c().func_176201_c(state));
        switch (type) {
            case PERSONAL_CHEST: 
            case CHARGEPAD: {
                return false;
            }
            case FLUID_TANK: {
                return side == EnumFacing.UP || side == EnumFacing.DOWN;
            }
        }
        return true;
    }

    public PropertyEnum<BlockStateMachine.MachineType> getTypeProperty() {
        return this.getMachineBlock().getProperty();
    }

    public EnumFacing[] getValidRotations(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        EnumFacing[] valid = new EnumFacing[6];
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock basicTile = (TileEntityBasicBlock)tile;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (!basicTile.canSetFacing(dir.ordinal())) continue;
                valid[dir.ordinal()] = dir;
            }
        }
        return valid;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntityBasicBlock basicTile;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBasicBlock && (basicTile = (TileEntityBasicBlock)tile).canSetFacing(axis.ordinal())) {
            basicTile.setFacing((short)axis.ordinal());
            return true;
        }
        return false;
    }

    @Deprecated
    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = MekanismUtils.getTileEntitySafe(world, pos);
        if (tile instanceof TileEntityLaserAmplifier) {
            return ((TileEntityLaserAmplifier)tile).emittingRedstone ? 15 : 0;
        }
        return 0;
    }
}

