/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import mekanism.common.Mekanism;
import mekanism.common.block.states.BlockStateBounding;
import mekanism.common.tile.TileEntityAdvancedBoundingBlock;
import mekanism.common.tile.TileEntityBoundingBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class BlockBounding
extends Block {
    @Nullable
    private static BlockPos getMainBlockPos(World world, BlockPos thisPos) {
        TileEntity te = world.func_175625_s(thisPos);
        if (te instanceof TileEntityBoundingBlock && !thisPos.equals((Object)((TileEntityBoundingBlock)te).mainPos)) {
            return ((TileEntityBoundingBlock)te).mainPos;
        }
        return null;
    }

    public BlockBounding() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(8.0f);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateBounding(this);
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockStateBounding.advancedProperty, (Comparable)Boolean.valueOf(meta > 0));
    }

    public int func_176201_c(IBlockState state) {
        boolean isAdvanced = (Boolean)state.func_177229_b((IProperty)BlockStateBounding.advancedProperty);
        return isAdvanced ? 1 : 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        try {
            BlockPos mainPos = BlockBounding.getMainBlockPos(world, pos);
            if (mainPos != null) {
                IBlockState state1 = world.func_180495_p(mainPos);
                return state1.func_177230_c().func_180639_a(world, mainPos, state1, player, hand, side, hitX, hitY, hitZ);
            }
        }
        catch (Exception e) {
            Mekanism.logger.error("Something went wrong", (Throwable)e);
        }
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        try {
            BlockPos mainPos = BlockBounding.getMainBlockPos(world, pos);
            if (mainPos != null) {
                IBlockState state1 = world.func_180495_p(mainPos);
                return state1.func_177230_c().getPickBlock(state1, target, world, mainPos, player);
            }
        }
        catch (Exception e) {
            Mekanism.logger.error("Something went wrong", (Throwable)e);
        }
        return ItemStack.field_190927_a;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        try {
            BlockPos mainPos = BlockBounding.getMainBlockPos(world, pos);
            if (mainPos != null) {
                IBlockState state1 = world.func_180495_p(mainPos);
                return state1.func_177230_c().removedByPlayer(state1, world, mainPos, player, willHarvest);
            }
        }
        catch (Exception e) {
            Mekanism.logger.error("Something went wrong", (Throwable)e);
        }
        return false;
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        try {
            BlockPos mainPos;
            TileEntityBoundingBlock tileEntity = (TileEntityBoundingBlock)world.func_175625_s(pos);
            if (tileEntity != null) {
                tileEntity.onNeighborChange(state.func_177230_c());
            }
            if ((mainPos = BlockBounding.getMainBlockPos(world, pos)) != null) {
                IBlockState state1 = world.func_180495_p(mainPos);
                state1.func_177230_c().func_189540_a(state1, world, mainPos, neighborBlock, neighborPos);
            }
        }
        catch (Exception e) {
            Mekanism.logger.error("Something went wrong", (Throwable)e);
        }
    }

    @Deprecated
    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        try {
            BlockPos mainPos = BlockBounding.getMainBlockPos(world, pos);
            if (mainPos != null) {
                IBlockState state1 = world.func_180495_p(mainPos);
                return state1.func_177230_c().func_180647_a(state1, player, world, mainPos);
            }
        }
        catch (Exception e) {
            Mekanism.logger.error("Something went wrong", (Throwable)e);
        }
        return super.func_180647_a(state, player, world, pos);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return null;
    }

    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)BlockStateBounding.advancedProperty)).booleanValue()) {
            return new TileEntityAdvancedBoundingBlock();
        }
        return new TileEntityBoundingBlock();
    }
}

