/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import java.util.Arrays;
import mekanism.common.base.IFluidHandlerWrapper;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidHandlerWrapper
implements IFluidHandler {
    public IFluidHandlerWrapper wrapper;
    public EnumFacing side;

    public FluidHandlerWrapper(IFluidHandlerWrapper w, EnumFacing s) {
        this.wrapper = w;
        this.side = s;
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.side == null) {
            return FluidHandlerWrapper.convertReadOnly(this.wrapper.getAllTanks());
        }
        return this.wrapper.getTankInfo(this.side) != null ? FluidTankProperties.convert((FluidTankInfo[])this.wrapper.getTankInfo(this.side)) : new IFluidTankProperties[]{};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.side == null || resource == null) {
            return 0;
        }
        if (this.wrapper.canFill(this.side, resource)) {
            return this.wrapper.fill(this.side, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.side == null || resource == null) {
            return null;
        }
        if (this.wrapper.canDrain(this.side, resource)) {
            return this.wrapper.drain(this.side, resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.side == null) {
            return null;
        }
        if (this.wrapper.canDrain(this.side, null)) {
            return this.wrapper.drain(this.side, maxDrain, doDrain);
        }
        return null;
    }

    private static IFluidTankProperties[] convertReadOnly(FluidTankInfo[] fluidTankInfos) {
        return (IFluidTankProperties[])Arrays.stream(fluidTankInfos).map(t -> new FluidTankProperties(t.fluid, t.capacity, false, false)).toArray(IFluidTankProperties[]::new);
    }
}

