/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import mekanism.api.EnumColor;
import mekanism.common.ColourRGBA;
import mekanism.common.Mekanism;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.LangUtils;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;

public final class Tier {
    private static List<ITier> tierTypes = new ArrayList<ITier>();
    private static boolean initiated = false;

    public static void init() {
        if (initiated) {
            return;
        }
        for (Class<?> c : Tier.class.getDeclaredClasses()) {
            if (!c.isEnum()) continue;
            try {
                for (Object obj : c.getEnumConstants()) {
                    if (!(obj instanceof ITier)) continue;
                    tierTypes.add((ITier)obj);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        initiated = true;
    }

    public static interface ITier {
        public BaseTier getBaseTier();
    }

    public static enum BinTier implements ITier
    {
        BASIC(4096),
        ADVANCED(8192),
        ELITE(32768),
        ULTIMATE(262144),
        CREATIVE(Integer.MAX_VALUE);

        private int storage;
        public final int baseStorage;
        public final BaseTier baseTier;

        private BinTier(int s) {
            this.baseStorage = this.storage = s;
            this.baseTier = BaseTier.values()[this.ordinal()];
        }

        @Override
        public BaseTier getBaseTier() {
            return this.baseTier;
        }

        public int getStorage() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).BinStorage.val();
        }
    }

    public static enum GasTankTier implements ITier,
    IStringSerializable
    {
        BASIC(64000, 256),
        ADVANCED(128000, 512),
        ELITE(256000, 1028),
        ULTIMATE(512000, 2056),
        CREATIVE(Integer.MAX_VALUE, 0x3FFFFFFF);

        public final int baseStorage;
        public final int baseOutput;
        public final BaseTier baseTier;

        private GasTankTier(int s, int o) {
            this.baseStorage = s;
            this.baseOutput = o;
            this.baseTier = BaseTier.values()[this.ordinal()];
        }

        @Override
        public BaseTier getBaseTier() {
            return this.baseTier;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public int getStorage() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).GasTankStorage.val();
        }

        public int getOutput() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).GasTankOutput.val();
        }
    }

    public static enum FluidTankTier implements ITier
    {
        BASIC(14000, 400),
        ADVANCED(28000, 800),
        ELITE(56000, 1600),
        ULTIMATE(112000, 3200),
        CREATIVE(Integer.MAX_VALUE, 0x3FFFFFFF);

        public final int baseStorage;
        public final int baseOutput;
        public final BaseTier baseTier;

        private FluidTankTier(int s, int o) {
            this.baseStorage = s;
            this.baseOutput = o;
            this.baseTier = BaseTier.values()[this.ordinal()];
        }

        @Override
        public BaseTier getBaseTier() {
            return this.baseTier;
        }

        public int getStorage() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).FluidTankStorage.val();
        }

        public int getOutput() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).FluidTankOutput.val();
        }
    }

    public static enum ConductorTier implements ITier
    {
        BASIC(5.0, 1.0, 10.0, new ColourRGBA(0.2, 0.2, 0.2, 1.0)),
        ADVANCED(5.0, 1.0, 400.0, new ColourRGBA(0.2, 0.2, 0.2, 1.0)),
        ELITE(5.0, 1.0, 8000.0, new ColourRGBA(0.2, 0.2, 0.2, 1.0)),
        ULTIMATE(5.0, 1.0, 100000.0, new ColourRGBA(0.2, 0.2, 0.2, 1.0));

        public final double baseConduction;
        public final double baseHeatCapacity;
        public final double baseConductionInsulation;
        public ColourRGBA baseColour;
        public final BaseTier baseTier;

        private ConductorTier(double inversek, double inverseC, double insulationInversek, ColourRGBA colour) {
            this.baseConduction = inversek;
            this.baseHeatCapacity = inverseC;
            this.baseConductionInsulation = insulationInversek;
            this.baseColour = colour;
            this.baseTier = BaseTier.values()[this.ordinal()];
        }

        @Override
        public BaseTier getBaseTier() {
            return this.baseTier;
        }

        public static ConductorTier get(BaseTier tier) {
            for (ConductorTier transmitter : ConductorTier.values()) {
                if (transmitter.getBaseTier() != tier) continue;
                return transmitter;
            }
            return BASIC;
        }

        public double getInverseConduction() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).ConductorInverseConduction.val();
        }

        public double getInverseHeatCapacity() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).ConductorHeatCapacity.val();
        }

        public double getInverseConductionInsulation() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).ConductorConductionInsulation.val();
        }
    }

    public static enum TransporterTier implements ITier
    {
        BASIC(1, 5),
        ADVANCED(16, 10),
        ELITE(32, 20),
        ULTIMATE(64, 50);

        public final int basePull;
        public final int baseSpeed;
        public final BaseTier baseTier;

        private TransporterTier(int pull, int s) {
            this.basePull = pull;
            this.baseSpeed = s;
            this.baseTier = BaseTier.values()[this.ordinal()];
        }

        @Override
        public BaseTier getBaseTier() {
            return this.baseTier;
        }

        public static TransporterTier get(BaseTier tier) {
            for (TransporterTier transmitter : TransporterTier.values()) {
                if (transmitter.getBaseTier() != tier) continue;
                return transmitter;
            }
            return BASIC;
        }

        public int getPullAmount() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).TransporterPullAmount.val();
        }

        public int getSpeed() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).TransporterSpeed.val();
        }
    }

    public static enum TubeTier implements ITier
    {
        BASIC(256, 64),
        ADVANCED(1024, 256),
        ELITE(4096, 1024),
        ULTIMATE(16384, 4096);

        public final int baseCapacity;
        public final int basePull;
        public final BaseTier baseTier;

        private TubeTier(int capacity, int pullAmount) {
            this.baseCapacity = capacity;
            this.basePull = pullAmount;
            this.baseTier = BaseTier.values()[this.ordinal()];
        }

        @Override
        public BaseTier getBaseTier() {
            return this.baseTier;
        }

        public static TubeTier get(BaseTier tier) {
            for (TubeTier transmitter : TubeTier.values()) {
                if (transmitter.getBaseTier() != tier) continue;
                return transmitter;
            }
            return BASIC;
        }

        public int getTubeCapacity() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).TubeCapacity.val();
        }

        public int getTubePullAmount() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).TubePullAmount.val();
        }
    }

    public static enum PipeTier implements ITier
    {
        BASIC(1000, 100),
        ADVANCED(4000, 400),
        ELITE(16000, 1600),
        ULTIMATE(64000, 6400);

        public final int baseCapacity;
        public final int basePull;
        public final BaseTier baseTier;

        private PipeTier(int capacity, int pullAmount) {
            this.baseCapacity = capacity;
            this.basePull = pullAmount;
            this.baseTier = BaseTier.values()[this.ordinal()];
        }

        @Override
        public BaseTier getBaseTier() {
            return this.baseTier;
        }

        public static PipeTier get(BaseTier tier) {
            for (PipeTier transmitter : PipeTier.values()) {
                if (transmitter.getBaseTier() != tier) continue;
                return transmitter;
            }
            return BASIC;
        }

        public int getPipeCapacity() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).PipeCapacity.val();
        }

        public int getPipePullAmount() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).PipePullAmount.val();
        }
    }

    public static enum CableTier implements ITier
    {
        BASIC(3200),
        ADVANCED(12800),
        ELITE(64000),
        ULTIMATE(320000);

        public final int baseCapacity;
        public final BaseTier baseTier;

        private CableTier(int capacity) {
            this.baseCapacity = capacity;
            this.baseTier = BaseTier.values()[this.ordinal()];
        }

        @Override
        public BaseTier getBaseTier() {
            return this.baseTier;
        }

        public static CableTier get(BaseTier tier) {
            for (CableTier transmitter : CableTier.values()) {
                if (transmitter.getBaseTier() != tier) continue;
                return transmitter;
            }
            return BASIC;
        }

        public int getCableCapacity() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).CableCapacity.val();
        }
    }

    public static enum FactoryTier {
        BASIC(3, new ResourceLocation("mekanism", "gui/factory/GuiBasicFactory.png"), BlockStateMachine.MachineType.BASIC_FACTORY),
        ADVANCED(5, new ResourceLocation("mekanism", "gui/factory/GuiAdvancedFactory.png"), BlockStateMachine.MachineType.ADVANCED_FACTORY),
        ELITE(7, new ResourceLocation("mekanism", "gui/factory/GuiEliteFactory.png"), BlockStateMachine.MachineType.ELITE_FACTORY);

        public int processes;
        public ResourceLocation guiLocation;
        public final BlockStateMachine.MachineType machineType;
        public final BaseTier baseTier;

        public static FactoryTier getFromName(String tierName) {
            for (FactoryTier tier : FactoryTier.values()) {
                if (!tierName.contains(tier.getBaseTier().getSimpleName())) continue;
                return tier;
            }
            Mekanism.logger.error("Invalid tier identifier when retrieving with name.");
            return BASIC;
        }

        public BaseTier getBaseTier() {
            return this.baseTier;
        }

        private FactoryTier(int process, ResourceLocation gui, BlockStateMachine.MachineType machineTypeIn) {
            this.processes = process;
            this.guiLocation = gui;
            this.machineType = machineTypeIn;
            this.baseTier = BaseTier.values()[this.ordinal()];
        }
    }

    public static enum InductionProviderTier implements ITier
    {
        BASIC(64000.0),
        ADVANCED(512000.0),
        ELITE(4096000.0),
        ULTIMATE(3.2768E7);

        public final double baseOutput;
        public final BaseTier baseTier;

        private InductionProviderTier(double out) {
            this.baseOutput = out;
            this.baseTier = BaseTier.values()[this.ordinal()];
        }

        @Override
        public BaseTier getBaseTier() {
            return this.baseTier;
        }

        public double getOutput() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).InductionProviderOutput.val();
        }
    }

    public static enum InductionCellTier implements ITier
    {
        BASIC(1.0E9),
        ADVANCED(8.0E9),
        ELITE(6.4E10),
        ULTIMATE(5.12E11);

        private double maxEnergy;
        public final double baseMaxEnergy;
        public final BaseTier baseTier;

        private InductionCellTier(double max) {
            this.baseMaxEnergy = this.maxEnergy = max;
            this.baseTier = BaseTier.values()[this.ordinal()];
        }

        @Override
        public BaseTier getBaseTier() {
            return this.baseTier;
        }

        public double getMaxEnergy() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).InductionCellMaxEnergy.val();
        }
    }

    public static enum EnergyCubeTier implements ITier,
    IStringSerializable
    {
        BASIC(2000000.0, 800.0),
        ADVANCED(8000000.0, 3200.0),
        ELITE(3.2E7, 12800.0),
        ULTIMATE(1.28E8, 51200.0),
        CREATIVE(Double.MAX_VALUE, Double.MAX_VALUE);

        private double maxEnergy;
        public final double baseMaxEnergy;
        private double output;
        public final double baseOutput;
        public final BaseTier baseTier;

        private EnergyCubeTier(double max, double out) {
            this.baseMaxEnergy = this.maxEnergy = max;
            this.baseOutput = this.output = out;
            this.baseTier = BaseTier.values()[this.ordinal()];
        }

        @Override
        public BaseTier getBaseTier() {
            return this.baseTier;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public double getMaxEnergy() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).EnergyCubeMaxEnergy.val();
        }

        public double getOutput() {
            return MekanismConfig.current().general.tiers.get((Object)((Object)this.baseTier)).EnergyCubeOutput.val();
        }
    }

    public static enum BaseTier implements IStringSerializable
    {
        BASIC("Basic", EnumColor.BRIGHT_GREEN),
        ADVANCED("Advanced", EnumColor.DARK_RED),
        ELITE("Elite", EnumColor.DARK_BLUE),
        ULTIMATE("Ultimate", EnumColor.PURPLE),
        CREATIVE("Creative", EnumColor.BLACK);

        private String name;
        private EnumColor color;

        public String getSimpleName() {
            return this.name;
        }

        public String getLocalizedName() {
            return LangUtils.localize("tier." + this.getSimpleName());
        }

        public EnumColor getColor() {
            return this.color;
        }

        public boolean isObtainable() {
            return this != CREATIVE;
        }

        private BaseTier(String s, EnumColor c) {
            this.name = s;
            this.color = c;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

