/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class RenderResizableCuboid {
    protected RenderManager manager = Minecraft.func_71410_x().func_175598_ae();
    public static final Vec3d VEC_ONE = RenderResizableCuboid.vec3(1.0);
    public static final Vec3d VEC_ZERO = RenderResizableCuboid.vec3(0.0);
    public static final Vec3d VEC_HALF = RenderResizableCuboid.vec3(0.5);
    public static final RenderResizableCuboid INSTANCE = new RenderResizableCuboid();
    private static final Map<EnumFacing, Vec3d> aoMap = Maps.newEnumMap(EnumFacing.class);
    private static final int U_MIN = 0;
    private static final int U_MAX = 1;
    private static final int V_MIN = 2;
    private static final int V_MAX = 3;

    public void renderCubeFromCentre(MekanismRenderer.Model3D cuboid) {
        GlStateManager.func_179094_E();
        GL11.glTranslated((double)(-cuboid.sizeX() / 2.0), (double)(-cuboid.sizeY() / 2.0), (double)(-cuboid.sizeZ() / 2.0));
        this.renderCube(cuboid, EnumShadeArgument.NONE, null, null, null);
        GlStateManager.func_179121_F();
    }

    public void renderCube(MekanismRenderer.Model3D cuboid) {
        this.renderCube(cuboid, EnumShadeArgument.NONE, null, null, null);
    }

    public void renderCube(MekanismRenderer.Model3D cube, EnumShadeArgument shadeTypes, IBlockLocation formula, IFacingLocation faceFormula, IBlockAccess world) {
        if (faceFormula == null) {
            faceFormula = DefaultFacingLocation.INSTANCE;
        }
        TextureAtlasSprite[] sprites = cube.textures;
        int[] flips = cube.textureFlips;
        if (flips == null) {
            flips = new int[6];
        }
        Vec3d textureStart = new Vec3d(cube.textureStartX / 16.0, cube.textureStartY / 16.0, cube.textureStartZ / 16.0);
        Vec3d textureSize = new Vec3d(cube.textureSizeX / 16.0, cube.textureSizeY / 16.0, cube.textureSizeZ / 16.0);
        Vec3d textureOffset = new Vec3d(cube.textureOffsetX / 16.0, cube.textureOffsetY / 16.0, cube.textureOffsetZ / 16.0);
        Vec3d size = new Vec3d(cube.sizeX(), cube.sizeY(), cube.sizeZ());
        this.manager.field_78724_e.func_110577_a(TextureMap.field_110575_b);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder wr = tess.func_178180_c();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179140_f();
        wr.func_181668_a(7, shadeTypes.vertexFormat);
        for (EnumFacing face : EnumFacing.values()) {
            if (!cube.shouldSideRender(face)) continue;
            this.renderCuboidFace(wr, face, sprites, flips, textureStart, textureSize, size, textureOffset, shadeTypes, formula, faceFormula, world);
        }
        tess.func_78381_a();
        GlStateManager.func_179118_c();
        GlStateManager.func_179145_e();
        GlStateManager.func_179127_m();
    }

    private void renderCuboidFace(BufferBuilder wr, EnumFacing face, TextureAtlasSprite[] sprites, int[] flips, Vec3d textureStart, Vec3d textureSize, Vec3d size, Vec3d textureOffset, EnumShadeArgument shadeTypes, IBlockLocation locationFormula, IFacingLocation faceFormula, IBlockAccess access) {
        int ordinal = face.ordinal();
        if (sprites[ordinal] == null) {
            return;
        }
        Vec3d textureEnd = textureStart.func_178787_e(textureSize);
        float[] uv = this.getUVArray(sprites[ordinal], flips[ordinal], face, textureStart, textureEnd);
        List<RenderInfo> renderInfoList = this.getRenderInfos(uv, face, size, textureSize, textureOffset);
        EnumFacing.Axis u = face.func_176740_k() == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X;
        EnumFacing.Axis v = face.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.Axis.Z : EnumFacing.Axis.Y;
        double other = face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? RenderResizableCuboid.getValue(size, face.func_176740_k()) : 0.0;
        face = face.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? face : face.func_176734_d();
        EnumFacing opposite = face.func_176734_d();
        for (RenderInfo ri : renderInfoList) {
            this.renderPoint(wr, face, u, v, other, ri, true, false, locationFormula, faceFormula, access, shadeTypes);
            this.renderPoint(wr, face, u, v, other, ri, true, true, locationFormula, faceFormula, access, shadeTypes);
            this.renderPoint(wr, face, u, v, other, ri, false, true, locationFormula, faceFormula, access, shadeTypes);
            this.renderPoint(wr, face, u, v, other, ri, false, false, locationFormula, faceFormula, access, shadeTypes);
            this.renderPoint(wr, opposite, u, v, other, ri, false, false, locationFormula, faceFormula, access, shadeTypes);
            this.renderPoint(wr, opposite, u, v, other, ri, false, true, locationFormula, faceFormula, access, shadeTypes);
            this.renderPoint(wr, opposite, u, v, other, ri, true, true, locationFormula, faceFormula, access, shadeTypes);
            this.renderPoint(wr, opposite, u, v, other, ri, true, false, locationFormula, faceFormula, access, shadeTypes);
        }
    }

    public static Vec3d withValue(Vec3d vector, EnumFacing.Axis axis, double value) {
        if (axis == EnumFacing.Axis.X) {
            return new Vec3d(value, vector.field_72448_b, vector.field_72449_c);
        }
        if (axis == EnumFacing.Axis.Y) {
            return new Vec3d(vector.field_72450_a, value, vector.field_72449_c);
        }
        if (axis == EnumFacing.Axis.Z) {
            return new Vec3d(vector.field_72450_a, vector.field_72448_b, value);
        }
        throw new RuntimeException("Was given a null axis! That was probably not intentional, consider this a bug! (Vector = " + vector + ")");
    }

    private void renderPoint(BufferBuilder wr, EnumFacing face, EnumFacing.Axis u, EnumFacing.Axis v, double other, RenderInfo ri, boolean minU, boolean minV, IBlockLocation locationFormula, IFacingLocation faceFormula, IBlockAccess access, EnumShadeArgument shadeTypes) {
        int U_ARRAY = minU ? 0 : 1;
        int V_ARRAY = minV ? 2 : 3;
        Vec3d vertex = RenderResizableCuboid.withValue(VEC_ZERO, u, ri.xyz[U_ARRAY]);
        vertex = RenderResizableCuboid.withValue(vertex, v, ri.xyz[V_ARRAY]);
        vertex = RenderResizableCuboid.withValue(vertex, face.func_176740_k(), other);
        wr.func_181662_b(vertex.field_72450_a, vertex.field_72448_b, vertex.field_72449_c);
        wr.func_187315_a((double)ri.uv[U_ARRAY], (double)ri.uv[V_ARRAY]);
        if (shadeTypes.isEnabled(EnumShadeType.FACE)) {
            RenderResizableCuboid.setWorldRendererRGB(wr, aoMap.get(faceFormula.transformToWorld(face)));
        }
        if (shadeTypes.isEnabled(EnumShadeType.AMBIENT_OCCLUSION)) {
            this.applyLocalAO(wr, faceFormula.transformToWorld(face), locationFormula, access, shadeTypes, vertex);
        } else if (shadeTypes.isEnabled(EnumShadeType.LIGHT)) {
            Vec3d transVertex = locationFormula.transformToWorld(vertex);
            BlockPos pos = RenderResizableCuboid.convertFloor(transVertex);
            IBlockState block = access.func_180495_p(pos);
            int combindedLight = block.func_185889_a(access, pos);
            wr.func_187314_a(combindedLight >> 16 & 0xFFFF, combindedLight & 0xFFFF);
        }
        wr.func_181675_d();
    }

    public static BlockPos convertFloor(Vec3d vec) {
        return new BlockPos(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static Vec3d convert(Vec3i vec3i) {
        return new Vec3d((double)vec3i.func_177958_n(), (double)vec3i.func_177956_o(), (double)vec3i.func_177952_p());
    }

    public static Vec3d convert(EnumFacing face) {
        if (face == null) {
            return VEC_ZERO;
        }
        return new Vec3d((double)face.func_82601_c(), (double)face.func_96559_d(), (double)face.func_82599_e());
    }

    public static EnumFacing[] getNeighbours(EnumFacing face) {
        EnumFacing[] faces = new EnumFacing[4];
        int ordinal = 0;
        for (EnumFacing next : EnumFacing.values()) {
            if (next.func_176740_k() == face.func_176740_k()) continue;
            faces[ordinal] = next;
            ++ordinal;
        }
        return faces;
    }

    private void applyLocalAO(BufferBuilder wr, EnumFacing face, IBlockLocation locationFormula, IBlockAccess access, EnumShadeArgument shadeTypes, Vec3d vertex) {
        EnumFacing[] testArray;
        boolean allAround = false;
        int numPositions = allAround ? 7 : 5;
        int[] skyLight = new int[numPositions];
        int[] blockLight = new int[numPositions];
        float[] colorMultiplier = new float[numPositions];
        double[] distances = new double[numPositions];
        double totalDist = 0.0;
        Vec3d transVertex = locationFormula.transformToWorld(vertex);
        BlockPos pos = RenderResizableCuboid.convertFloor(transVertex);
        IBlockState state = access.func_180495_p(pos);
        Block block = state.func_177230_c();
        int combindedLight = state.func_185889_a(access, pos);
        skyLight[0] = combindedLight / 65536;
        blockLight[0] = combindedLight % 65536;
        colorMultiplier[0] = state.func_185892_j();
        distances[0] = transVertex.func_72438_d(RenderResizableCuboid.convertMiddle((Vec3i)pos));
        int index = 0;
        for (EnumFacing otherFace : testArray = allAround ? EnumFacing.values() : RenderResizableCuboid.getNeighbours(face)) {
            Vec3d nearestOther = vertex.func_178787_e(RenderResizableCuboid.convert(otherFace));
            pos = RenderResizableCuboid.convertFloor(locationFormula.transformToWorld(nearestOther));
            state = access.func_180495_p(pos);
            combindedLight = state.func_185889_a(access, pos);
            skyLight[++index] = combindedLight / 65536;
            blockLight[index] = combindedLight % 65536;
            colorMultiplier[index] = state.func_185892_j();
            distances[index] = 1.0 / (transVertex.func_72438_d(RenderResizableCuboid.convertMiddle((Vec3i)pos)) + 0.1);
            totalDist += distances[index];
        }
        double avgBlockLight = 0.0;
        double avgSkyLight = 0.0;
        float avgColorMultiplier = 0.0f;
        for (int i = 0; i < numPositions; ++i) {
            double part = distances[i] / totalDist;
            avgBlockLight += (double)blockLight[i] * part;
            avgSkyLight += (double)skyLight[i] * part;
            avgColorMultiplier = (float)((double)avgColorMultiplier + (double)colorMultiplier[i] * part);
        }
        if (shadeTypes.isEnabled(EnumShadeType.LIGHT)) {
            int capBlockLight = (int)avgBlockLight;
            int capSkyLight = (int)avgSkyLight;
            wr.func_187314_a(capBlockLight, capSkyLight);
        }
        Vec3d color = shadeTypes.isEnabled(EnumShadeType.FACE) ? aoMap.get(face) : VEC_ONE;
        color = RenderResizableCuboid.multiply(color, avgColorMultiplier);
        RenderResizableCuboid.setWorldRendererRGB(wr, color);
    }

    public static void setWorldRendererRGB(BufferBuilder wr, Vec3d color) {
        wr.func_181666_a((float)color.field_72450_a, (float)color.field_72448_b, (float)color.field_72449_c, 1.0f);
    }

    public static Vec3d vec3(double value) {
        return new Vec3d(value, value, value);
    }

    public static Vec3d multiply(Vec3d vec, double multiple) {
        return new Vec3d(vec.field_72450_a * multiple, vec.field_72448_b * multiple, vec.field_72449_c * multiple);
    }

    public static Vec3d convertMiddle(Vec3i vec3i) {
        return RenderResizableCuboid.convert(vec3i).func_178787_e(VEC_HALF);
    }

    public void renderCubeStatic(List<BakedQuad> quads, MekanismRenderer.Model3D cuboid) {
        double[][] arr;
        float[] uv;
        TextureAtlasSprite[] sprites = cuboid.textures;
        int[] flips = cuboid.textureFlips;
        if (flips == null) {
            flips = new int[6];
        }
        double textureStartX = cuboid.textureStartX / 16.0;
        double textureStartY = cuboid.textureStartY / 16.0;
        double textureStartZ = cuboid.textureStartZ / 16.0;
        double textureSizeX = cuboid.textureSizeX / 16.0;
        double textureSizeY = cuboid.textureSizeY / 16.0;
        double textureSizeZ = cuboid.textureSizeZ / 16.0;
        double textureEndX = textureSizeX + textureStartX;
        double textureEndY = textureSizeY + textureStartY;
        double textureEndZ = textureSizeZ + textureStartZ;
        double textureOffsetX = cuboid.textureOffsetX / 16.0;
        double textureOffsetY = cuboid.textureOffsetY / 16.0;
        double textureOffsetZ = cuboid.textureOffsetZ / 16.0;
        double sizeX = cuboid.sizeX();
        double sizeY = cuboid.sizeY();
        double sizeZ = cuboid.sizeZ();
        if (sprites[0] != null) {
            uv = this.getUVArray(sprites[0], flips[0], textureStartX, textureEndX, textureStartZ, textureEndZ);
            for (RenderInfo ri : this.getRenderInfos(uv, sizeX, sizeZ, textureSizeX, textureSizeZ, textureOffsetX, textureOffsetZ)) {
                ri = ri.offset(cuboid, EnumFacing.Axis.Y);
                arr = new double[][]{{ri.xyz[1], cuboid.posY, ri.xyz[2], -1.0, ri.uv[1], ri.uv[2], 0.0}, {ri.xyz[1], cuboid.posY, ri.xyz[3], -1.0, ri.uv[1], ri.uv[3], 0.0}, {ri.xyz[0], cuboid.posY, ri.xyz[3], -1.0, ri.uv[0], ri.uv[3], 0.0}, {ri.xyz[0], cuboid.posY, ri.xyz[2], -1.0, ri.uv[0], ri.uv[2], 0.0}};
                this.convertToDoubleQuads(quads, arr, EnumFacing.DOWN, sprites[0]);
            }
        }
        if (sprites[1] != null) {
            uv = this.getUVArray(sprites[1], flips[1], textureStartX, textureEndX, textureStartZ, textureEndZ);
            for (RenderInfo ri : this.getRenderInfos(uv, sizeX, sizeZ, textureSizeX, textureSizeZ, textureOffsetX, textureOffsetZ)) {
                ri = ri.offset(cuboid, EnumFacing.Axis.Y);
                arr = new double[][]{{ri.xyz[1], sizeY + cuboid.posY, ri.xyz[2], -1.0, ri.uv[1], ri.uv[2], 0.0}, {ri.xyz[1], sizeY + cuboid.posY, ri.xyz[3], -1.0, ri.uv[1], ri.uv[3], 0.0}, {ri.xyz[0], sizeY + cuboid.posY, ri.xyz[3], -1.0, ri.uv[0], ri.uv[3], 0.0}, {ri.xyz[0], sizeY + cuboid.posY, ri.xyz[2], -1.0, ri.uv[0], ri.uv[2], 0.0}};
                this.convertToDoubleQuads(quads, arr, EnumFacing.UP, sprites[1]);
            }
        }
        if (sprites[2] != null) {
            uv = this.getUVArray(sprites[2], flips[2], textureStartX, textureEndX, textureStartY, textureEndY);
            for (RenderInfo ri : this.getRenderInfos(uv, sizeX, sizeY, textureSizeX, textureSizeY, textureOffsetX, textureOffsetY)) {
                ri = ri.offset(cuboid, EnumFacing.Axis.Z);
                arr = new double[][]{{ri.xyz[1], ri.xyz[2], cuboid.posZ, -1.0, ri.uv[1], ri.uv[2], 0.0}, {ri.xyz[1], ri.xyz[3], cuboid.posZ, -1.0, ri.uv[1], ri.uv[3], 0.0}, {ri.xyz[0], ri.xyz[3], cuboid.posZ, -1.0, ri.uv[0], ri.uv[3], 0.0}, {ri.xyz[0], ri.xyz[2], cuboid.posZ, -1.0, ri.uv[0], ri.uv[2], 0.0}};
                this.convertToDoubleQuads(quads, arr, EnumFacing.NORTH, sprites[2]);
            }
        }
        if (sprites[3] != null) {
            uv = this.getUVArray(sprites[3], flips[3], textureStartX, textureEndX, textureStartY, textureEndY);
            for (RenderInfo ri : this.getRenderInfos(uv, sizeX, sizeY, textureSizeX, textureSizeY, textureOffsetX, textureOffsetY)) {
                ri = ri.offset(cuboid, EnumFacing.Axis.Z);
                arr = new double[][]{{ri.xyz[1], ri.xyz[2], cuboid.posZ + sizeZ, -1.0, ri.uv[1], ri.uv[2], 0.0}, {ri.xyz[1], ri.xyz[3], cuboid.posZ + sizeZ, -1.0, ri.uv[1], ri.uv[3], 0.0}, {ri.xyz[0], ri.xyz[3], cuboid.posZ + sizeZ, -1.0, ri.uv[0], ri.uv[3], 0.0}, {ri.xyz[0], ri.xyz[2], cuboid.posZ + sizeZ, -1.0, ri.uv[0], ri.uv[2], 0.0}};
                this.convertToDoubleQuads(quads, arr, EnumFacing.SOUTH, sprites[3]);
            }
        }
        if (sprites[4] != null) {
            uv = this.getUVArray(sprites[4], flips[4], textureStartZ, textureEndZ, textureStartY, textureEndY);
            for (RenderInfo ri : this.getRenderInfos(uv, sizeZ, sizeY, textureSizeZ, textureSizeY, textureOffsetZ, textureOffsetY)) {
                ri = ri.offset(cuboid, EnumFacing.Axis.X);
                arr = new double[][]{{cuboid.posX, ri.xyz[2], ri.xyz[1], -1.0, ri.uv[1], ri.uv[2], 0.0}, {cuboid.posX, ri.xyz[3], ri.xyz[1], -1.0, ri.uv[1], ri.uv[3], 0.0}, {cuboid.posX, ri.xyz[3], ri.xyz[0], -1.0, ri.uv[0], ri.uv[3], 0.0}, {cuboid.posX, ri.xyz[2], ri.xyz[0], -1.0, ri.uv[0], ri.uv[2], 0.0}};
                this.convertToDoubleQuads(quads, arr, EnumFacing.WEST, sprites[4]);
            }
        }
        if (sprites[5] != null) {
            uv = this.getUVArray(sprites[5], flips[5], textureStartZ, textureEndZ, textureStartY, textureEndY);
            for (RenderInfo ri : this.getRenderInfos(uv, sizeZ, sizeY, textureSizeZ, textureSizeY, textureOffsetZ, textureOffsetY)) {
                ri = ri.offset(cuboid, EnumFacing.Axis.X);
                arr = new double[][]{{cuboid.posX + sizeX, ri.xyz[2], ri.xyz[1], -1.0, ri.uv[1], ri.uv[2], 0.0}, {cuboid.posX + sizeX, ri.xyz[3], ri.xyz[1], -1.0, ri.uv[1], ri.uv[3], 0.0}, {cuboid.posX + sizeX, ri.xyz[3], ri.xyz[0], -1.0, ri.uv[0], ri.uv[3], 0.0}, {cuboid.posX + sizeX, ri.xyz[2], ri.xyz[0], -1.0, ri.uv[0], ri.uv[2], 0.0}};
                this.convertToDoubleQuads(quads, arr, EnumFacing.EAST, sprites[5]);
            }
        }
    }

    private void convertToDoubleQuads(List<BakedQuad> quads, double[][] points, EnumFacing face, TextureAtlasSprite sprite) {
        BakedQuad quad = this.convertToQuad(points, face, sprite);
        quads.add(quad);
        double[][] otherPoints = new double[][]{points[3], points[2], points[1], points[0]};
        quad = this.convertToQuad(otherPoints, face, sprite);
        quads.add(quad);
    }

    private BakedQuad convertToQuad(double[][] points, EnumFacing face, TextureAtlasSprite sprite) {
        int[] list = new int[points.length * points[0].length];
        for (int i = 0; i < points.length; ++i) {
            double[] arr = points[i];
            for (int j = 0; j < arr.length; ++j) {
                double d = arr[j];
                int used = j == 3 || j == 6 ? (int)d : Float.floatToRawIntBits((float)d);
                list[i * arr.length + j] = used;
            }
        }
        return new BakedQuad(list, -1, face, sprite, true, DefaultVertexFormats.field_176599_b);
    }

    private float[] getUVArray(TextureAtlasSprite sprite, int flips, double startU, double endU, double startV, double endV) {
        float holder;
        float minU = sprite.func_94214_a(startU * 16.0);
        float maxU = sprite.func_94214_a(endU * 16.0);
        float minV = sprite.func_94207_b(startV * 16.0);
        float maxV = sprite.func_94207_b(endV * 16.0);
        float[] uvarray = new float[]{minU, maxU, minV, maxV};
        if (flips % 2 == 1) {
            holder = uvarray[0];
            uvarray[0] = uvarray[1];
            uvarray[1] = holder;
        }
        if (flips >> 1 == 1) {
            holder = uvarray[2];
            uvarray[2] = uvarray[3];
            uvarray[3] = holder;
        }
        return uvarray;
    }

    private float[] getUVArray(TextureAtlasSprite sprite, int flips, EnumFacing face, Vec3d start, Vec3d end) {
        float holder;
        EnumFacing.Axis u = face.func_176740_k() == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X;
        EnumFacing.Axis v = face.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.Axis.Z : EnumFacing.Axis.Y;
        float minU = sprite.func_94214_a(RenderResizableCuboid.getValue(start, u) * 16.0);
        float maxU = sprite.func_94214_a(RenderResizableCuboid.getValue(end, u) * 16.0);
        float minV = sprite.func_94207_b(RenderResizableCuboid.getValue(start, v) * 16.0);
        float maxV = sprite.func_94207_b(RenderResizableCuboid.getValue(end, v) * 16.0);
        float[] uvarray = new float[]{minU, maxU, minV, maxV};
        if (flips % 2 == 1) {
            holder = uvarray[0];
            uvarray[0] = uvarray[1];
            uvarray[1] = holder;
        }
        if (flips >> 1 == 1) {
            holder = uvarray[2];
            uvarray[2] = uvarray[3];
            uvarray[3] = holder;
        }
        return uvarray;
    }

    private List<RenderInfo> getRenderInfos(float[] uv, EnumFacing face, Vec3d size, Vec3d texSize, Vec3d texOffset) {
        EnumFacing.Axis u = face.func_176740_k() == EnumFacing.Axis.X ? EnumFacing.Axis.Z : EnumFacing.Axis.X;
        EnumFacing.Axis v = face.func_176740_k() == EnumFacing.Axis.Y ? EnumFacing.Axis.Z : EnumFacing.Axis.Y;
        double sizeU = RenderResizableCuboid.getValue(size, u);
        double sizeV = RenderResizableCuboid.getValue(size, v);
        double textureSizeU = RenderResizableCuboid.getValue(texSize, u);
        double textureSizeV = RenderResizableCuboid.getValue(texSize, v);
        double textureOffsetU = RenderResizableCuboid.getValue(texOffset, u);
        double textureOffsetV = RenderResizableCuboid.getValue(texOffset, v);
        return this.getRenderInfos(uv, sizeU, sizeV, textureSizeU, textureSizeV, textureOffsetU, textureOffsetV);
    }

    public static double getValue(Vec3d vector, EnumFacing.Axis axis) {
        if (axis == EnumFacing.Axis.X) {
            return vector.field_72450_a;
        }
        if (axis == EnumFacing.Axis.Y) {
            return vector.field_72448_b;
        }
        if (axis == EnumFacing.Axis.Z) {
            return vector.field_72449_c;
        }
        throw new RuntimeException("Was given a null axis! That was probably not intentional, consider this a bug! (Vector = " + vector + ")");
    }

    private List<RenderInfo> getRenderInfos(float[] uv, double sizeU, double sizeV, double textureSizeU, double textureSizeV, double textureOffsetU, double textureOffsetV) {
        ArrayList infos = Lists.newArrayList();
        boolean firstU = true;
        for (double u = 0.0; u < sizeU; u += textureSizeU) {
            float[] uvCu = Arrays.copyOf(uv, 4);
            double addU = textureSizeU;
            boolean lowerU = false;
            if (firstU && textureOffsetU != 0.0) {
                uvCu[0] = uvCu[0] + (uvCu[1] - uvCu[0]) * (float)textureOffsetU;
                addU -= textureOffsetU;
                lowerU = true;
            }
            if (u + addU > sizeU) {
                addU = sizeU - u;
                uvCu[1] = firstU && textureOffsetU != 0.0 ? uvCu[0] + (uvCu[1] - uvCu[0]) * (float)(addU / (textureSizeU - textureOffsetU)) : uvCu[0] + (uvCu[1] - uvCu[0]) * (float)(addU / textureSizeU);
            }
            firstU = false;
            boolean firstV = true;
            for (double v = 0.0; v < sizeV; v += textureSizeV) {
                float[] uvCv = Arrays.copyOf(uvCu, 4);
                double addV = textureSizeV;
                boolean lowerV = false;
                if (firstV && textureOffsetV != 0.0) {
                    uvCv[2] = uvCv[2] + (uvCv[3] - uvCv[2]) * (float)textureOffsetV;
                    addV -= textureOffsetV;
                    lowerV = true;
                }
                if (v + addV > sizeV) {
                    addV = sizeV - v;
                    uvCv[3] = firstV && textureOffsetV != 0.0 ? uvCv[2] + (uvCv[3] - uvCv[2]) * (float)(addV / (textureSizeV - textureOffsetV)) : uvCv[2] + (uvCv[3] - uvCv[2]) * (float)(addV / textureSizeV);
                }
                double[] xyz = new double[]{u, u + addU, v, v + addV};
                infos.add(new RenderInfo(uvCv, xyz));
                if (lowerV) {
                    v -= textureOffsetV;
                }
                firstV = false;
            }
            if (!lowerU) continue;
            u -= textureOffsetU;
        }
        return infos;
    }

    static {
        aoMap.put(EnumFacing.UP, RenderResizableCuboid.vec3(1.0));
        aoMap.put(EnumFacing.DOWN, RenderResizableCuboid.vec3(0.5));
        aoMap.put(EnumFacing.NORTH, RenderResizableCuboid.vec3(0.8));
        aoMap.put(EnumFacing.SOUTH, RenderResizableCuboid.vec3(0.8));
        aoMap.put(EnumFacing.EAST, RenderResizableCuboid.vec3(0.6));
        aoMap.put(EnumFacing.WEST, RenderResizableCuboid.vec3(0.6));
    }

    private static final class RenderInfo {
        private final float[] uv;
        private final double[] xyz;

        public RenderInfo(float[] uv, double[] xyz) {
            this.uv = uv;
            this.xyz = xyz;
        }

        public RenderInfo offset(MekanismRenderer.Model3D ent, EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return new RenderInfo(this.uv, new double[]{this.xyz[0] + ent.posZ, this.xyz[1] + ent.posZ, this.xyz[2] + ent.posY, this.xyz[3] + ent.posY});
                }
                case Y: {
                    return new RenderInfo(this.uv, new double[]{this.xyz[0] + ent.posX, this.xyz[1] + ent.posX, this.xyz[2] + ent.posZ, this.xyz[3] + ent.posZ});
                }
                case Z: {
                    return new RenderInfo(this.uv, new double[]{this.xyz[0] + ent.posX, this.xyz[1] + ent.posX, this.xyz[2] + ent.posY, this.xyz[3] + ent.posY});
                }
            }
            return new RenderInfo(this.uv, this.xyz);
        }
    }

    public static enum EnumShadeArgument {
        NONE(new EnumShadeType[0]),
        FACE(EnumShadeType.FACE),
        FACE_LIGHT(EnumShadeType.FACE, EnumShadeType.LIGHT),
        FACE_OCCLUDE(EnumShadeType.FACE, EnumShadeType.AMBIENT_OCCLUSION),
        FACE_LIGHT_OCCLUDE(EnumShadeType.FACE, EnumShadeType.LIGHT, EnumShadeType.AMBIENT_OCCLUSION),
        LIGHT(EnumShadeType.LIGHT),
        LIGHT_OCCLUDE(EnumShadeType.LIGHT, EnumShadeType.AMBIENT_OCCLUSION),
        OCCLUDE(EnumShadeType.AMBIENT_OCCLUSION);

        public final ImmutableSet<EnumShadeType> types;
        final VertexFormat vertexFormat = new VertexFormat();

        private EnumShadeArgument(EnumShadeType ... types) {
            this.vertexFormat.func_181721_a(DefaultVertexFormats.field_181713_m);
            this.vertexFormat.func_181721_a(DefaultVertexFormats.field_181715_o);
            for (EnumShadeType type : types) {
                if (this.vertexFormat.func_177343_g().contains(type.element)) continue;
                this.vertexFormat.func_181721_a(type.element);
            }
            this.types = ImmutableSet.copyOf((Object[])types);
        }

        public boolean isEnabled(EnumShadeType type) {
            return this.types.contains((Object)type);
        }
    }

    public static enum EnumShadeType {
        FACE(DefaultVertexFormats.field_181714_n),
        LIGHT(DefaultVertexFormats.field_181716_p),
        AMBIENT_OCCLUSION(DefaultVertexFormats.field_181714_n);

        private final VertexFormatElement element;

        private EnumShadeType(VertexFormatElement element) {
            this.element = element;
        }
    }

    public static enum DefaultFacingLocation implements IFacingLocation
    {
        INSTANCE;


        @Override
        public EnumFacing transformToWorld(EnumFacing face) {
            return face;
        }
    }

    public static interface IFacingLocation {
        public EnumFacing transformToWorld(EnumFacing var1);
    }

    public static interface IBlockLocation {
        public Vec3d transformToWorld(Vec3d var1);
    }
}

