/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.util.Arrays;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.sound.SoundHandler;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GuiVisualsTab
extends GuiElement {
    private TileEntityDigitalMiner tileEntity;

    public GuiVisualsTab(IGuiWrapper gui, TileEntityDigitalMiner tile, ResourceLocation def) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiVisualsTab.png"), gui, def);
        this.tileEntity = tile;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth - 26, guiHeight + 6, 26, 26);
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiVisualsTab.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth - 26, guiHeight + 6, 0, 0, 26, 26);
        if (xAxis >= -21 && xAxis <= -3 && yAxis >= 10 && yAxis <= 28) {
            this.guiObj.drawTexturedRect(guiWidth - 21, guiHeight + 10, 26, 0, 18, 18);
        } else {
            this.guiObj.drawTexturedRect(guiWidth - 21, guiHeight + 10, 26, 18, 18, 18);
        }
        GuiVisualsTab.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        GuiVisualsTab.mc.field_71446_o.func_110577_a(this.RESOURCE);
        if (xAxis >= -21 && xAxis <= -3 && yAxis >= 10 && yAxis <= 28) {
            if (this.tileEntity.radius <= 64) {
                this.displayTooltip(LangUtils.localize("gui.visuals") + ": " + LangUtils.transOnOff(this.tileEntity.clientRendering), xAxis, yAxis);
            } else {
                this.displayTooltips(Arrays.asList(LangUtils.localize("gui.visuals") + ": " + LangUtils.transOnOff(this.tileEntity.clientRendering), TextFormatting.RED.toString() + LangUtils.localize("mekanism.gui.visuals.toobig")), xAxis, yAxis);
            }
        }
        GuiVisualsTab.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
        if (button == 0 && xAxis >= -21 && xAxis <= -3 && yAxis >= 10 && yAxis <= 28) {
            this.tileEntity.clientRendering = !this.tileEntity.clientRendering;
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
    }
}

