/*
 * Decompiled with CFR 0.152.
 */
package com.tictim.ceu.mte.trait.infinite;

import com.tictim.ceu.gui.InfiniteEnergyData;
import com.tictim.ceu.mte.trait.infinite.TraitInfiniteEnergy;
import com.tictim.ceu.util.Numbers;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import java.math.BigInteger;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TraitInfiniteFeReceiver
extends TraitInfiniteEnergy
implements IEnergyStorage {
    public TraitInfiniteFeReceiver(MetaTileEntity metaTileEntity) {
        super(metaTileEntity);
    }

    public String getName() {
        return "infinite_fe_receiver";
    }

    public int getNetworkID() {
        return 0;
    }

    @Nullable
    public Capability<?> getImplementingCapability() {
        return CapabilityEnergy.ENERGY;
    }

    @Override
    public ModularUI createUI(IUIHolder holder, EntityPlayer player) {
        return new InfiniteEnergyData(this).guiBuilder().energyInput("FE").buttonAcceptDecline().createUI(holder, player);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (maxReceive <= 0) {
            return 0;
        }
        if (!simulate) {
            this.add(BigInteger.valueOf(maxReceive));
        }
        return maxReceive;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return Numbers.toInt(this.energy);
    }

    public int getMaxEnergyStored() {
        return this.getEnergyStored();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }
}

