/*
 * Decompiled with CFR 0.152.
 */
package knightminer.ceramics;

import javax.annotation.Nonnull;
import knightminer.ceramics.Ceramics;
import knightminer.ceramics.CommonProxy;
import knightminer.ceramics.blocks.BlockClayWall;
import knightminer.ceramics.blocks.BlockEnumBase;
import knightminer.ceramics.blocks.BlockEnumSlabBase;
import knightminer.ceramics.blocks.BlockStained;
import knightminer.ceramics.blocks.IBlockEnum;
import knightminer.ceramics.client.BarrelRenderer;
import knightminer.ceramics.client.ChannelRenderer;
import knightminer.ceramics.client.FaucetRenderer;
import knightminer.ceramics.items.ItemClayBucket;
import knightminer.ceramics.items.ItemClayUnfired;
import knightminer.ceramics.library.Config;
import knightminer.ceramics.library.client.IgnoreAllStateMapper;
import knightminer.ceramics.library.client.PropertyStateMapper;
import knightminer.ceramics.tileentity.TileBarrel;
import knightminer.ceramics.tileentity.TileChannel;
import knightminer.ceramics.tileentity.TileFaucet;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    public static Minecraft minecraft = Minecraft.func_71410_x();

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (Config.barrelEnabled) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileBarrel.class, (TileEntitySpecialRenderer)new BarrelRenderer());
        }
        if (Config.faucetEnabled) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileFaucet.class, (TileEntitySpecialRenderer)new FaucetRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileChannel.class, (TileEntitySpecialRenderer)new ChannelRenderer());
        }
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        this.ignoreProperty((IProperty<?>)BlockStained.COLOR, Ceramics.porcelain, Ceramics.porcelainBarrel, Ceramics.porcelainBarrelExtension);
        ModelLoader.setCustomStateMapper((Block)Ceramics.clayWall, (IStateMapper)new PropertyStateMapper("clay_wall", BlockClayWall.TYPE, true));
        ModelLoader.setCustomStateMapper((Block)Ceramics.channel, (IStateMapper)IgnoreAllStateMapper.INSTANCE);
        this.registerItemModels(Ceramics.claySoft);
        this.registerItemModels(Ceramics.clayHard);
        this.registerItemModels(Ceramics.rainbowClay);
        this.registerItemModels(Ceramics.claySlab);
        this.registerItemModels(Ceramics.clayWall);
        this.registerItemModel(Ceramics.stairsPorcelainBricks);
        this.registerItemModel(Ceramics.stairsDarkBricks);
        this.registerItemModel(Ceramics.stairsGoldenBricks);
        this.registerItemModel(Ceramics.stairsMarineBricks);
        this.registerItemModel(Ceramics.stairsDragonBricks);
        this.registerItemModel(Ceramics.stairsLavaBricks);
        this.registerItemModel(Ceramics.stairsRainbowBricks);
        this.registerItemModel(Ceramics.stairsMonochromeBricks);
        this.registerItemModel(Ceramics.porcelain);
        this.registerItemModel(Ceramics.porcelainBarrel);
        this.registerItemModel(Ceramics.porcelainBarrelExtension);
        this.registerItemModel(Ceramics.clayBucket);
        this.registerItemModel(Ceramics.clayBucketBlock);
        this.registerItemModel(Ceramics.clayShears);
        for (ItemClayBucket.SpecialFluid specialFluid : ItemClayBucket.SpecialFluid.values()) {
            if (specialFluid == ItemClayBucket.SpecialFluid.EMPTY) continue;
            this.registerItemModel(Ceramics.clayBucket, specialFluid.getMeta(), specialFluid.getName());
        }
        this.registerItemModel(Ceramics.clayHelmet);
        this.registerItemModel(Ceramics.clayChestplate);
        this.registerItemModel(Ceramics.clayLeggings);
        this.registerItemModel(Ceramics.clayBoots);
        this.registerItemModel(Ceramics.clayHelmetRaw);
        this.registerItemModel(Ceramics.clayChestplateRaw);
        this.registerItemModel(Ceramics.clayLeggingsRaw);
        this.registerItemModel(Ceramics.clayBootsRaw);
        for (Enum enum_ : ItemClayUnfired.UnfiredType.values()) {
            this.registerItemModel(Ceramics.clayUnfired, ((ItemClayUnfired.UnfiredType)enum_).getMeta(), ((ItemClayUnfired.UnfiredType)enum_).getName());
        }
        this.registerItemModel(Ceramics.clayBarrel, 0, "extension=false");
        this.registerItemModel(Ceramics.clayBarrel, 1, "extension=true");
        this.registerItemModel(Ceramics.clayBarrelUnfired, 0, "extension=false,type=clay");
        this.registerItemModel(Ceramics.clayBarrelUnfired, 1, "extension=true,type=clay");
        this.registerItemModel(Ceramics.clayBarrelUnfired, 2, "extension=false,type=porcelain");
        this.registerItemModel(Ceramics.clayBarrelUnfired, 3, "extension=true,type=porcelain");
        for (Enum enum_ : EnumDyeColor.values()) {
            this.registerItemModel(Ceramics.clayBarrelStained, enum_.func_176765_a(), "color=" + enum_.func_176610_l());
            this.registerItemModel(Ceramics.clayBarrelStainedExtension, enum_.func_176765_a(), "color=" + enum_.func_176610_l());
        }
        this.registerItemModel(Ceramics.faucet);
        this.registerItemModel(Ceramics.channel);
    }

    @Override
    public void init() {
        BlockColors blockColors = minecraft.func_184125_al();
        if (Config.porcelainEnabled) {
            Block[] blocks = Config.barrelEnabled ? new Block[]{Ceramics.porcelain, Ceramics.porcelainBarrel, Ceramics.porcelainBarrelExtension} : new Block[]{Ceramics.porcelain};
            blockColors.func_186722_a((state, access, pos, tintIndex) -> ((BlockStained.StainedColor)((Object)state.func_177229_b(BlockStained.COLOR))).getColor(), blocks);
            minecraft.getItemColors().func_186731_a((stack, tintIndex) -> {
                IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                return blockColors.func_186724_a(iblockstate, null, null, tintIndex);
            }, blocks);
        }
    }

    private void registerItemModel(Item item) {
        this.registerItemModel(item, "inventory");
    }

    private void registerItemModel(Block block) {
        this.registerItemModel(Item.func_150898_a((Block)block));
    }

    private void registerItemModel(Item item, final String variant) {
        if (item != null && item != Items.field_190931_a) {
            final ResourceLocation location = item.getRegistryName();
            ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

                @Nonnull
                public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
                    return new ModelResourceLocation(location, variant);
                }
            });
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{location});
        }
    }

    private void registerItemModel(Block block, String variant) {
        this.registerItemModel(Item.func_150898_a((Block)block), variant);
    }

    private void registerItemModel(Item item, int meta, String name) {
        if (item != null && item != Items.field_190931_a) {
            ResourceLocation location = item.getRegistryName();
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(location, name));
        }
    }

    private void registerItemModel(Block block, int meta, String name) {
        this.registerItemModel(Item.func_150898_a((Block)block), meta, name);
    }

    private <B extends Block, T extends Enum<T> & BlockEnumBase.IEnumMeta> void registerItemModels(B block) {
        this.registerItemModels(block, "");
    }

    private <T extends Enum<T> & BlockEnumBase.IEnumMeta> void registerItemModels(BlockEnumSlabBase<T> block) {
        this.registerItemModels((Block)block, "half=bottom,");
    }

    private <B extends Block, T extends Enum<T> & BlockEnumBase.IEnumMeta> void registerItemModels(B block, String prefix) {
        if (block != null && block != Blocks.field_150350_a) {
            PropertyEnum prop = ((IBlockEnum)block).getMappingProperty();
            for (Enum value : prop.func_177700_c()) {
                this.registerItemModel(block, ((BlockEnumBase.IEnumMeta)((Object)value)).getMeta(), prefix + prop.func_177701_a() + "=" + ((IStringSerializable)value).func_176610_l());
            }
        }
    }

    private void ignoreProperty(IProperty<?> prop, Block ... blocks) {
        for (Block block : blocks) {
            if (block == null || block == Blocks.field_150350_a) continue;
            ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{prop}).func_178441_a());
        }
    }
}

