/*
 * Decompiled with CFR 0.152.
 */
package com.teamdman.animus.rituals;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

@RitualRegister(value="ritualUnmaking")
public class RitualUnmaking
extends Ritual {
    public static final String EFFECT_RANGE = "effect";

    public RitualUnmaking() {
        super("ritualUnmaking", 0, 3000, "ritual.animus.ritualUnmaking");
        this.addBlockRange(EFFECT_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-2, -2, -2), 5));
        this.setMaximumVolumeAndDistanceOfRange(EFFECT_RANGE, 0, 8, 8);
    }

    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        SoulNetwork network = NetworkHelper.getSoulNetwork((UUID)masterRitualStone.getOwner());
        int currentEssence = network.getCurrentEssence();
        BlockPos masterPos = masterRitualStone.getBlockPos();
        if (masterRitualStone.getWorldObj().field_72995_K) {
            return;
        }
        if (currentEssence < this.getRefreshCost()) {
            network.causeNausea();
            return;
        }
        AreaDescriptor effectRange = this.getBlockRange(EFFECT_RANGE);
        List itemList = world.func_72872_a(EntityItem.class, effectRange.getAABB(masterPos));
        if (itemList.isEmpty()) {
            return;
        }
        Optional<EntityItem> booksOpt = itemList.stream().filter(e -> !e.field_70128_L).filter(e -> e.func_92059_d().func_77973_b() == Items.field_151122_aG).findFirst();
        if (!booksOpt.isPresent()) {
            return;
        }
        EntityItem books = booksOpt.get();
        for (EntityItem entityItem : itemList) {
            ItemStack enchBook;
            short enchLVL;
            short enchID;
            NBTTagCompound data;
            int i;
            NBTTagList enchants;
            if (entityItem.func_92059_d().func_77973_b() == Items.field_151134_bR) {
                if (!entityItem.func_92059_d().func_77942_o() || (enchants = entityItem.func_92059_d().func_77978_p().func_150295_c("StoredEnchantments", 10)).func_82582_d()) continue;
                for (i = enchants.func_74745_c() - 1; i >= 0 && !books.func_92059_d().func_190926_b(); --i) {
                    data = enchants.func_150305_b(i);
                    enchID = data.func_74765_d("id");
                    enchLVL = data.func_74765_d("lvl");
                    enchants.func_74744_a(i);
                    enchBook = this.getEnchantedBook(enchID, (short)(enchLVL > 2 ? enchLVL - 1 : 1));
                    world.func_72838_d((Entity)new EntityItem(world, (double)masterPos.func_177958_n(), (double)(masterPos.func_177956_o() + 1), (double)masterPos.func_177952_p(), enchBook.func_77946_l()));
                    world.func_72838_d((Entity)new EntityItem(world, (double)masterPos.func_177958_n(), (double)(masterPos.func_177956_o() + 1), (double)masterPos.func_177952_p(), enchBook));
                    books.func_92059_d().func_190918_g(1);
                }
                entityItem.func_92059_d().func_190918_g(1);
                world.func_184133_a(null, masterPos, SoundEvents.field_187665_Y, SoundCategory.BLOCKS, 0.5f, 1.0f);
                masterRitualStone.stopRitual(Ritual.BreakType.DEACTIVATE);
                continue;
            }
            enchants = entityItem.func_92059_d().func_77986_q();
            for (i = enchants.func_74745_c() - 1; i >= 0 && !books.func_92059_d().func_190926_b(); --i) {
                data = enchants.func_150305_b(i);
                enchID = data.func_74765_d("id");
                enchLVL = data.func_74765_d("lvl");
                enchants.func_74744_a(i);
                enchBook = this.getEnchantedBook(enchID, enchLVL);
                world.func_72838_d((Entity)new EntityItem(world, (double)masterPos.func_177958_n(), (double)(masterPos.func_177956_o() + 1), (double)masterPos.func_177952_p(), enchBook));
                books.func_92059_d().func_190918_g(1);
            }
            world.func_184133_a(null, masterPos, SoundEvents.field_187698_i, SoundCategory.BLOCKS, 0.5f, 1.0f);
            masterRitualStone.stopRitual(Ritual.BreakType.DEACTIVATE);
        }
        network.syphon(new SoulTicket((ITextComponent)new TextComponentTranslation("text.component.animus.ticket.unmaking", new Object[0]), this.getRefreshCost()));
    }

    private ItemStack getEnchantedBook(short id, short level) {
        ItemStack book = new ItemStack(Items.field_151134_bR);
        book.func_77982_d(new NBTTagCompound());
        NBTTagList enchantmentList = new NBTTagList();
        NBTTagCompound enchantment = new NBTTagCompound();
        enchantment.func_74777_a("id", id);
        enchantment.func_74777_a("lvl", level);
        enchantmentList.func_74742_a((NBTBase)enchantment);
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("StoredEnchantments", (NBTBase)enchantmentList);
        book.func_77982_d(compound);
        return book;
    }

    public int getRefreshCost() {
        return 0;
    }

    public int getRefreshTime() {
        return 20;
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        components.accept(new RitualComponent(new BlockPos(-4, 0, -2), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(-4, 0, 0), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(-4, 0, 2), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(-3, 0, -3), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-3, 0, -1), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(-3, 0, 1), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(-3, 0, 3), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-2, 0, -4), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(-2, 0, -2), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-2, 0, 0), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(-2, 0, 2), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-2, 0, 4), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(-1, 0, -3), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(-1, 0, -1), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-1, 0, 0), EnumRuneType.FIRE));
        components.accept(new RitualComponent(new BlockPos(-1, 0, 1), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(-1, 0, 3), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(0, 0, -4), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(0, 0, -2), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(0, 0, -1), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(0, 0, 1), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(0, 0, 2), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(0, 0, 4), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(1, 0, -3), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(1, 0, -1), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(1, 0, 0), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(1, 0, 1), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(1, 0, 3), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(2, 0, -4), EnumRuneType.AIR));
        components.accept(new RitualComponent(new BlockPos(2, 0, -2), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(2, 0, 0), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(2, 0, 2), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(2, 0, 4), EnumRuneType.EARTH));
        components.accept(new RitualComponent(new BlockPos(3, 0, -3), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(3, 0, -1), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(3, 0, 1), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(3, 0, 3), EnumRuneType.DUSK));
        components.accept(new RitualComponent(new BlockPos(4, 0, -2), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(4, 0, 0), EnumRuneType.WATER));
        components.accept(new RitualComponent(new BlockPos(4, 0, 2), EnumRuneType.WATER));
    }

    public Ritual getNewCopy() {
        return new RitualUnmaking();
    }
}

