/*
 * Decompiled with CFR 0.152.
 */
package com.teamdman.animus.rituals;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.ritual.AreaDescriptor;
import WayofTime.bloodmagic.ritual.EnumRuneType;
import WayofTime.bloodmagic.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.ritual.Ritual;
import WayofTime.bloodmagic.ritual.RitualComponent;
import WayofTime.bloodmagic.ritual.RitualRegister;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

@RitualRegister(value="ritualLuna")
public class RitualLuna
extends Ritual {
    public static final String CHEST_RANGE = "chest";
    public static final String EFFECT_RANGE = "effect";

    public RitualLuna() {
        super("ritualLuna", 0, 1000, "ritual.animus.ritualLuna");
        this.addBlockRange(EFFECT_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(-32, -32, -32), 65));
        this.addBlockRange(CHEST_RANGE, (AreaDescriptor)new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(EFFECT_RANGE, 0, 128, 128);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        SoulNetwork network = NetworkHelper.getSoulNetwork((UUID)masterRitualStone.getOwner());
        int currentEssence = network.getCurrentEssence();
        BlockPos masterPos = masterRitualStone.getBlockPos();
        AreaDescriptor chestRange = this.getBlockRange(CHEST_RANGE);
        TileEntity tileInventory = world.func_175625_s((BlockPos)chestRange.getContainedPositions(masterPos).get(0));
        if (!world.field_72995_K) {
            if (currentEssence < this.getRefreshCost()) {
                network.causeNausea();
                return;
            }
            AreaDescriptor effectRange = this.getBlockRange(EFFECT_RANGE);
            for (BlockPos pos : effectRange.getContainedPositions(masterPos)) {
                ItemStack stack;
                IBlockState state = world.func_180495_p(pos);
                Block block = state.func_177230_c();
                if (state.func_177230_c().getLightValue(state, (IBlockAccess)world, pos) == 0) continue;
                Item item = Item.func_150898_a((Block)block);
                if (item == Items.field_190931_a) {
                    stack = block.getPickBlock(state, null, world, pos, null);
                    if (stack.func_190926_b()) {
                        stack = new ItemStack(block.func_180660_a(state, world.field_73012_v, 0));
                    }
                } else {
                    stack = new ItemStack(item, 1, item.func_77614_k() ? block.func_176201_c(state) : 0);
                }
                if (tileInventory != null && tileInventory.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
                    IItemHandler handler = (IItemHandler)tileInventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                    if (ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true).func_190926_b()) {
                        ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                    }
                } else {
                    EntityItem drop = new EntityItem(world, (double)masterPos.func_177958_n() + 0.5, (double)(masterPos.func_177956_o() + 1), (double)masterPos.func_177952_p() + 0.5, stack);
                    world.func_72838_d((Entity)drop);
                }
                world.func_175698_g(pos);
                network.syphon(new SoulTicket((ITextComponent)new TextComponentTranslation("text.component.animus.ticket.luna", new Object[0]), this.getRefreshCost()));
                return;
            }
        }
    }

    public int getRefreshCost() {
        return 1;
    }

    public int getRefreshTime() {
        return 5;
    }

    public void gatherComponents(Consumer<RitualComponent> components) {
        for (int layer = 0; layer < 3; ++layer) {
            components.accept(new RitualComponent(new BlockPos(2, layer, 2), EnumRuneType.DUSK));
            components.accept(new RitualComponent(new BlockPos(-2, layer, 2), EnumRuneType.DUSK));
            components.accept(new RitualComponent(new BlockPos(2, layer, -2), EnumRuneType.DUSK));
            components.accept(new RitualComponent(new BlockPos(-2, layer, -2), EnumRuneType.DUSK));
        }
    }

    public Ritual getNewCopy() {
        return new RitualLuna();
    }
}

