/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.booklet.page;

import de.ellpeck.actuallyadditions.api.booklet.internal.GuiBookletBase;
import de.ellpeck.actuallyadditions.api.recipe.LensConversionRecipe;
import de.ellpeck.actuallyadditions.mod.booklet.gui.GuiBooklet;
import de.ellpeck.actuallyadditions.mod.booklet.page.BookletPage;
import de.ellpeck.actuallyadditions.mod.booklet.page.PageTextOnly;
import de.ellpeck.actuallyadditions.mod.util.StringUtil;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PageReconstructor
extends BookletPage {
    private final LensConversionRecipe recipe;
    private boolean isWildcard;
    private int counter = 0;
    private int rotate = 0;
    private ItemStack[] stacks;

    public PageReconstructor(int localizationKey, LensConversionRecipe recipe) {
        super(localizationKey);
        this.recipe = recipe;
        if (recipe != null) {
            this.stacks = recipe.getInput().func_193365_a();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawScreenPre(GuiBookletBase gui, int startX, int startY, int mouseX, int mouseY, float partialTicks) {
        super.drawScreenPre(gui, startX, startY, mouseX, mouseY, partialTicks);
        gui.field_146297_k.func_110434_K().func_110577_a(GuiBooklet.RES_LOC_GADGETS);
        GuiUtils.drawTexturedModalRect((int)(startX + 30), (int)(startY + 10), (int)80, (int)146, (int)68, (int)48, (float)0.0f);
        gui.renderScaledAsciiString("(" + StringUtil.localize("booklet.actuallyadditions.reconstructorRecipe") + ")", startX + 6, startY + 63, 0, false, gui.getMediumFontSize());
        PageTextOnly.renderTextToPage(gui, this, startX + 6, startY + 88);
        if (this.recipe != null && this.counter++ % 50 == 0) {
            gui.addOrModifyItemRenderer(this.stacks[this.rotate++ % this.stacks.length], startX + 30 + 1, startY + 10 + 13, 1.0f, true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initGui(GuiBookletBase gui, int startX, int startY) {
        super.initGui(gui, startX, startY);
        if (this.recipe != null) {
            gui.addOrModifyItemRenderer(this.stacks[0], startX + 30 + 1, startY + 10 + 13, 1.0f, true);
            gui.addOrModifyItemRenderer(this.recipe.getOutput(), startX + 30 + 47, startY + 10 + 13, 1.0f, false);
        }
    }

    @Override
    public void getItemStacksForPage(List<ItemStack> list) {
        super.getItemStacksForPage(list);
        if (this.recipe != null) {
            ItemStack copy = this.recipe.getOutput().func_77946_l();
            if (this.isWildcard) {
                copy.func_77964_b(Short.MAX_VALUE);
            }
            list.add(copy);
        }
    }

    public BookletPage setWildcard() {
        this.isWildcard = true;
        return this;
    }

    @Override
    public int getSortingPriority() {
        return 20;
    }
}

