/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import com.feed_the_beast.ftbquests.quest.task.SimpleQuestTaskData;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;

public class DimensionTask
extends QuestTask {
    public int dimension = -1;

    public DimensionTask(Quest quest) {
        super(quest);
    }

    @Override
    public QuestTaskType getType() {
        return FTBQuestsTasks.DIMENSION;
    }

    @Override
    public long getMaxProgress() {
        return 1L;
    }

    @Override
    public boolean hideProgressNumbers() {
        return true;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74768_a("dim", this.dimension);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        try {
            this.dimension = nbt.func_74762_e("dim");
            if (this.dimension == 0 && nbt.func_150297_b("dim", 8)) {
                this.dimension = DimensionType.func_193417_a((String)nbt.func_74779_i("dim")).func_186068_a();
            }
        }
        catch (Exception ex) {
            this.dimension = -1;
        }
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarInt(this.dimension);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.dimension = data.readVarInt();
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        IntOpenHashSet dims = new IntOpenHashSet();
        for (DimensionType types : DimensionType.values()) {
            if (types == null) continue;
            dims.add(types.func_186068_a());
        }
        if (!this.quest.chapter.file.isClient()) {
            dims.addAll(Arrays.asList(DimensionManager.getIDs()));
        }
        config.addEnum("dim", () -> this.dimension, v -> {
            this.dimension = v;
        }, NameMap.create((Object)-1, (NameMap.ObjectProperties)NameMap.ObjectProperties.withName((sender, dim) -> DimensionTask.getName(dim)), (Object[])dims.toArray((Object[])new Integer[0]))).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.task.ftbquests.dimension", new Object[0]));
    }

    @Override
    public ITextComponent getAltDisplayName() {
        ITextComponent text = DimensionTask.getName(this.dimension);
        text.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
        return new TextComponentTranslation("ftbquests.task.ftbquests.dimension", new Object[]{text}).func_150258_a(": ").func_150257_a(text);
    }

    public static ITextComponent getName(int dim) {
        switch (dim) {
            case 0: {
                return new TextComponentTranslation("createWorld.customize.preset.overworld", new Object[0]);
            }
            case -1: {
                return new TextComponentTranslation("advancements.nether.root.title", new Object[0]);
            }
            case 1: {
                return new TextComponentTranslation("advancements.end.root.title", new Object[0]);
            }
        }
        try {
            return new TextComponentString(DimensionType.func_186069_a((int)dim).func_186065_b());
        }
        catch (Exception ex) {
            return new TextComponentString("dim_" + dim);
        }
    }

    @Override
    public QuestTaskData createData(ITeamData data) {
        return new Data(this, data);
    }

    public static class Data
    extends SimpleQuestTaskData<DimensionTask> {
        private Data(DimensionTask task, ITeamData data) {
            super(task, data);
        }

        @Override
        public boolean submitTask(EntityPlayerMP player, Collection<ItemStack> itemsToCheck, boolean simulate) {
            if (this.progress < 1L && player.field_71093_bK == ((DimensionTask)this.task).dimension && !player.func_175149_v()) {
                if (!simulate) {
                    this.progress = 1L;
                    this.sync();
                }
                return true;
            }
            return false;
        }
    }
}

