/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigList;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.io.Bits;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.ListUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.net.MessageDisplayCompletionToast;
import com.feed_the_beast.ftbquests.quest.Dependency;
import com.feed_the_beast.ftbquests.quest.EnumChangeProgress;
import com.feed_the_beast.ftbquests.quest.EnumDependencyType;
import com.feed_the_beast.ftbquests.quest.EnumQuestShape;
import com.feed_the_beast.ftbquests.quest.EnumVisibility;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class Quest
extends QuestObject {
    public static final int POS_LIMIT = 25;
    private static final List<QuestObjectType> DEP_TYPES = Arrays.asList(QuestObjectType.QUEST, QuestObjectType.CHAPTER, QuestObjectType.VARIABLE);
    public final QuestChapter chapter;
    public String description;
    public byte x;
    public byte y;
    public EnumQuestShape shape;
    public final List<String> text;
    public final List<Dependency> dependencies;
    public boolean canRepeat;
    public final List<QuestTask> tasks;
    public final List<QuestReward> rewards;
    public boolean tasksIgnoreDependencies;
    public String guidePage;
    public String customClick;

    public Quest(QuestChapter c) {
        this.chapter = c;
        this.description = "";
        this.x = 0;
        this.y = 0;
        this.shape = this.chapter.file.defaultShape;
        this.text = new ArrayList<String>();
        this.canRepeat = false;
        this.dependencies = new ArrayList<Dependency>(0);
        this.tasks = new ArrayList<QuestTask>(1);
        this.rewards = new ArrayList<QuestReward>(1);
        this.tasksIgnoreDependencies = false;
        this.guidePage = "";
        this.customClick = "";
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.QUEST;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.chapter.file;
    }

    @Override
    public QuestChapter getQuestChapter() {
        return this.chapter;
    }

    @Override
    public int getParentID() {
        return this.chapter.id;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (this.x != 0) {
            nbt.func_74774_a("x", this.x);
        }
        if (this.y != 0) {
            nbt.func_74774_a("y", this.y);
        }
        if (this.shape != this.chapter.file.defaultShape) {
            nbt.func_74778_a("shape", this.shape.getID());
        }
        if (!this.description.isEmpty()) {
            nbt.func_74778_a("description", this.description);
        }
        if (!this.text.isEmpty()) {
            NBTTagList array = new NBTTagList();
            for (String value : this.text) {
                array.func_74742_a((NBTBase)new NBTTagString(value));
            }
            nbt.func_74782_a("text", (NBTBase)array);
        }
        if (this.canRepeat) {
            nbt.func_74757_a("can_repeat", true);
        }
        if (this.tasksIgnoreDependencies) {
            nbt.func_74757_a("tasks_ignore_deps", true);
        }
        if (!this.guidePage.isEmpty()) {
            nbt.func_74778_a("guide_page", this.guidePage);
        }
        if (!this.customClick.isEmpty()) {
            nbt.func_74778_a("custom_click", this.customClick);
        }
        this.dependencies.removeIf(Dependency.PREDICATE_INVALID);
        if (!this.dependencies.isEmpty()) {
            boolean allRequired = true;
            for (Dependency dependency : this.dependencies) {
                if (dependency.type == EnumDependencyType.REQUIRED) continue;
                allRequired = false;
                break;
            }
            if (allRequired) {
                int[] ai = new int[this.dependencies.size()];
                for (int i = 0; i < this.dependencies.size(); ++i) {
                    ai[i] = this.dependencies.get((int)i).object.id;
                }
                if (ai.length == 1) {
                    nbt.func_74768_a("dependency", ai[0]);
                } else {
                    nbt.func_74783_a("dependencies", ai);
                }
            } else {
                NBTTagList list = new NBTTagList();
                for (Dependency dependency : this.dependencies) {
                    NBTTagCompound nbt1 = new NBTTagCompound();
                    nbt1.func_74768_a("id", dependency.object.id);
                    if (dependency.type != EnumDependencyType.REQUIRED) {
                        nbt1.func_74778_a("type", dependency.type.getID());
                    }
                    list.func_74742_a((NBTBase)nbt1);
                }
                nbt.func_74782_a("dependencies", (NBTBase)list);
            }
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.description = nbt.func_74779_i("description");
        this.x = (byte)MathHelper.func_76125_a((int)nbt.func_74771_c("x"), (int)-25, (int)25);
        this.y = (byte)MathHelper.func_76125_a((int)nbt.func_74771_c("y"), (int)-25, (int)25);
        this.shape = nbt.func_74764_b("shape") ? (EnumQuestShape)((Object)EnumQuestShape.NAME_MAP.get(nbt.func_74779_i("shape"))) : this.chapter.file.defaultShape;
        this.text.clear();
        NBTTagList list = nbt.func_150295_c("text", 8);
        for (int k = 0; k < list.func_74745_c(); ++k) {
            this.text.add(list.func_150307_f(k));
        }
        this.canRepeat = nbt.func_74767_n("can_repeat");
        this.tasksIgnoreDependencies = nbt.func_74767_n("tasks_ignore_deps");
        this.guidePage = nbt.func_74779_i("guide_page");
        this.customClick = nbt.func_74779_i("custom_click");
        this.dependencies.clear();
        NBTBase depsTag = nbt.func_74781_a("dependencies");
        if (depsTag instanceof NBTTagIntArray) {
            for (int i : nbt.func_74759_k("dependencies")) {
                QuestObject object = this.chapter.file.get(i);
                if (object == null) continue;
                Dependency dependency = new Dependency();
                dependency.object = object;
                dependency.type = EnumDependencyType.REQUIRED;
                this.dependencies.add(dependency);
            }
        } else if (depsTag instanceof NBTTagList) {
            list = (NBTTagList)depsTag;
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt1 = list.func_150305_b(i);
                QuestObject object = this.chapter.file.get(nbt1.func_74762_e("id"));
                if (object == null) continue;
                Dependency dependency = new Dependency();
                dependency.object = object;
                dependency.type = (EnumDependencyType)((Object)EnumDependencyType.NAME_MAP.get(nbt1.func_74779_i("type")));
                this.dependencies.add(dependency);
            }
        } else {
            QuestObject object = this.chapter.file.get(nbt.func_74762_e("dependency"));
            if (object != null) {
                Dependency dependency = new Dependency();
                dependency.object = object;
                dependency.type = EnumDependencyType.REQUIRED;
                this.dependencies.add(dependency);
            }
        }
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (boolean)this.canRepeat);
        flags = Bits.setFlag((int)flags, (int)2, (boolean)this.tasksIgnoreDependencies);
        flags = Bits.setFlag((int)flags, (int)4, (!this.guidePage.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)8, (!this.description.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)16, (!this.text.isEmpty() ? 1 : 0) != 0);
        flags = Bits.setFlag((int)flags, (int)32, (!this.customClick.isEmpty() ? 1 : 0) != 0);
        data.writeVarInt(flags);
        if (!this.description.isEmpty()) {
            data.writeString(this.description);
        }
        data.writeByte((int)this.x);
        data.writeByte((int)this.y);
        data.write((Object)this.shape, EnumQuestShape.NAME_MAP);
        if (!this.text.isEmpty()) {
            data.writeCollection(this.text, DataOut.STRING);
        }
        if (!this.guidePage.isEmpty()) {
            data.writeString(this.guidePage);
        }
        if (!this.customClick.isEmpty()) {
            data.writeString(this.customClick);
        }
        data.writeVarInt(this.dependencies.size());
        for (Dependency d : this.dependencies) {
            if (d.isInvalid()) {
                data.writeInt(0);
                continue;
            }
            data.writeInt(d.object.id);
            data.write((Object)d.type, EnumDependencyType.NAME_MAP);
        }
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        int flags = data.readVarInt();
        this.description = Bits.getFlag((int)flags, (int)8) ? data.readString() : "";
        this.x = data.readByte();
        this.y = data.readByte();
        this.shape = (EnumQuestShape)((Object)data.read(EnumQuestShape.NAME_MAP));
        if (Bits.getFlag((int)flags, (int)16)) {
            data.readCollection(this.text, DataIn.STRING);
        } else {
            this.text.clear();
        }
        this.canRepeat = Bits.getFlag((int)flags, (int)1);
        this.tasksIgnoreDependencies = Bits.getFlag((int)flags, (int)2);
        this.guidePage = Bits.getFlag((int)flags, (int)4) ? data.readString() : "";
        this.customClick = Bits.getFlag((int)flags, (int)32) ? data.readString() : "";
        this.dependencies.clear();
        int d = data.readVarInt();
        for (int i = 0; i < d; ++i) {
            QuestObject object = this.chapter.file.get(data.readInt());
            if (object == null) continue;
            Dependency dependency = new Dependency();
            dependency.object = object;
            dependency.type = (EnumDependencyType)((Object)data.read(EnumDependencyType.NAME_MAP));
            this.dependencies.add(dependency);
        }
    }

    @Override
    public long getProgress(ITeamData data) {
        long progress = 0L;
        for (QuestTask task : this.tasks) {
            if (task.invalid) continue;
            progress += task.getProgress(data);
        }
        return progress;
    }

    @Override
    public long getMaxProgress() {
        long maxProgress = 0L;
        for (QuestTask task : this.tasks) {
            if (task.invalid) continue;
            maxProgress += task.getMaxProgress();
        }
        return maxProgress;
    }

    @Override
    public int getRelativeProgress(ITeamData data) {
        int progress = 0;
        int s = 0;
        for (QuestTask task : this.tasks) {
            if (task.invalid) continue;
            progress += task.getRelativeProgress(data);
            ++s;
        }
        return Quest.fixRelativeProgress(progress, s);
    }

    @Override
    public boolean isComplete(ITeamData data) {
        for (QuestTask task : this.tasks) {
            if (task.invalid || task.isComplete(data)) continue;
            return false;
        }
        for (Dependency dependency : this.dependencies) {
            if (dependency.isInvalid() || dependency.type.checkFunction.check(data, dependency.object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onCompleted(ITeamData data, List<EntityPlayerMP> onlineMembers) {
        super.onCompleted(data, onlineMembers);
        new ObjectCompletedEvent.QuestEvent(data, this).post();
        if (!this.canRepeat) {
            for (EntityPlayerMP player : onlineMembers) {
                new MessageDisplayCompletionToast(this.id).sendTo(player);
            }
        }
        if (this.chapter.isComplete(data)) {
            this.chapter.onCompleted(data, onlineMembers);
        }
    }

    @Override
    public void changeProgress(ITeamData data, EnumChangeProgress type) {
        if (type.dependencies) {
            for (Dependency dependency : this.dependencies) {
                if (dependency.isInvalid()) continue;
                dependency.object.changeProgress(data, type);
            }
        }
        for (QuestTask task : this.tasks) {
            task.changeProgress(data, type);
        }
        if (type == EnumChangeProgress.RESET || type == EnumChangeProgress.RESET_DEPS) {
            data.unclaimRewards(this.rewards);
        }
    }

    public boolean canStartTasks(ITeamData data) {
        if (!this.tasksIgnoreDependencies) {
            for (Dependency dependency : this.dependencies) {
                if (dependency.object.isComplete(data)) continue;
                return false;
            }
        }
        return this.getVisibility(data).isVisible();
    }

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (QuestTask task : this.tasks) {
            list.add(task.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public ITextComponent getAltDisplayName() {
        if (!this.tasks.isEmpty()) {
            return this.tasks.get(0).getDisplayName().func_150259_f();
        }
        return new TextComponentTranslation("ftbquests.unnamed", new Object[0]);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.chapter.quests.remove(this);
    }

    @Override
    public void deleteChildren() {
        for (QuestTask task : this.tasks) {
            task.deleteChildren();
            task.invalid = true;
        }
        for (QuestReward reward : this.rewards) {
            reward.deleteChildren();
            reward.invalid = true;
        }
        this.tasks.clear();
        this.rewards.clear();
    }

    @Override
    public void onCreated() {
        this.chapter.quests.add(this);
        if (!this.tasks.isEmpty()) {
            for (QuestTask task : ListUtils.clearAndCopy(this.tasks)) {
                task.onCreated();
            }
        }
    }

    @Override
    public File getFile(File folder) {
        return new File(folder, "chapters/" + this.chapter.getCodeString() + "/" + this.getCodeString() + ".nbt");
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("x", () -> this.x, v -> {
            this.x = (byte)v;
        }, 0, -25, 25);
        config.addInt("y", () -> this.y, v -> {
            this.y = (byte)v;
        }, 0, -25, 25);
        config.addEnum("shape", () -> this.shape, v -> {
            this.shape = v;
        }, EnumQuestShape.NAME_MAP);
        config.addString("description", () -> this.description, v -> {
            this.description = v;
        }, "");
        config.addList("text", this.text, (ConfigValue)new ConfigString(""), ConfigString::new, ConfigString::getString);
        config.addBool("can_repeat", () -> this.canRepeat, v -> {
            this.canRepeat = v;
        }, false);
        config.add("dependencies", (ConfigValue)new ConfigList.SimpleList(this.dependencies, (ConfigValue)new ConfigQuestObject(this.chapter.file, null, DEP_TYPES), dep -> new ConfigQuestObject(this.chapter.file, (QuestObjectBase)dep.object, DEP_TYPES), object -> {
            Dependency dependency = new Dependency();
            dependency.object = (QuestObject)object.getObject();
            return dependency;
        }), (ConfigValue)new ConfigList((ConfigValue)new ConfigQuestObject(this.chapter.file, null, DEP_TYPES))).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.dependencies", new Object[0]));
        config.addBool("tasks_ignore_dependencies", () -> this.tasksIgnoreDependencies, v -> {
            this.tasksIgnoreDependencies = v;
        }, false);
        config.addString("guide_page", () -> this.guidePage, v -> {
            this.guidePage = v;
        }, "");
        config.addString("custom_click", () -> this.customClick, v -> {
            this.customClick = v;
        }, "");
    }

    public EnumVisibility getVisibility(@Nullable ITeamData data) {
        EnumVisibility v = EnumVisibility.VISIBLE;
        return v;
    }

    public QuestTask getTask(int index) {
        if (this.tasks.isEmpty()) {
            throw new IllegalStateException("Quest has no tasks!");
        }
        if (index <= 0) {
            return this.tasks.get(0);
        }
        if (index >= this.tasks.size()) {
            return this.tasks.get(this.tasks.size() - 1);
        }
        return this.tasks.get(index);
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (QuestTask task : this.tasks) {
            task.clearCachedData();
        }
        for (QuestReward reward : this.rewards) {
            reward.clearCachedData();
        }
    }

    public boolean hasDependency(QuestObject object) {
        if (object.invalid) {
            return false;
        }
        for (Dependency dependency : this.dependencies) {
            if (dependency.object != object || dependency.isInvalid()) continue;
            return true;
        }
        return false;
    }

    public boolean verifyDependencies(boolean autofix) {
        block6: {
            this.dependencies.removeIf(Dependency.PREDICATE_INVALID);
            if (this.dependencies.isEmpty()) {
                return true;
            }
            try {
                if (this.verifyDependenciesInternal(this, true)) {
                    return true;
                }
            }
            catch (StackOverflowError error) {
                if (!autofix) break block6;
                FTBQuests.LOGGER.error("Looping dependencies found! Deleting all dependencies for quest " + this);
            }
        }
        if (autofix) {
            this.dependencies.clear();
            if (!this.chapter.file.isClient()) {
                ServerQuestFile.INSTANCE.save();
            }
        }
        return false;
    }

    private boolean verifyDependenciesInternal(Quest original, boolean firstLoop) {
        if (this == original && !firstLoop) {
            return false;
        }
        for (Dependency dependency : this.dependencies) {
            if (!(dependency.object instanceof Quest) || ((Quest)dependency.object).verifyDependenciesInternal(original, false)) continue;
            return false;
        }
        return true;
    }

    public void checkRepeatableQuests(ITeamData data, UUID player) {
        if (!this.canRepeat) {
            return;
        }
        for (QuestReward reward1 : this.rewards) {
            if (data.isRewardClaimed(player, reward1)) continue;
            return;
        }
        this.changeProgress(data, EnumChangeProgress.RESET);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void editedFromGUI() {
        GuiQuestTree gui = (GuiQuestTree)((Object)ClientUtils.getCurrentGuiAs(GuiQuestTree.class));
        if (gui != null) {
            gui.quests.refreshWidgets();
            gui.questLeft.refreshWidgets();
            gui.questRight.refreshWidgets();
        }
        if (this.chapter.quests.size() == 1) {
            ClientQuestFile.INSTANCE.questTreeGui.resetScroll(true);
        }
    }
}

