/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftbquests.gui.tree.ButtonAddChapter;
import com.feed_the_beast.ftbquests.gui.tree.ButtonClaimAllRewards;
import com.feed_the_beast.ftbquests.gui.tree.ButtonEditSettings;
import com.feed_the_beast.ftbquests.gui.tree.ButtonEmergencyItems;
import com.feed_the_beast.ftbquests.gui.tree.ButtonOpenShop;
import com.feed_the_beast.ftbquests.gui.tree.ButtonWiki;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import net.minecraftforge.fml.common.Loader;

public class PanelOtherButtons
extends Panel {
    public final GuiQuestTree treeGui;

    public PanelOtherButtons(Panel panel) {
        super(panel);
        this.treeGui = (GuiQuestTree)panel.getGui();
    }

    private boolean hasRewards() {
        if (this.treeGui.file.self == null) {
            return false;
        }
        for (QuestChapter chapter : this.treeGui.file.chapters) {
            for (Quest quest : chapter.quests) {
                if (!quest.isComplete(this.treeGui.file.self)) continue;
                for (QuestReward reward : quest.rewards) {
                    if (this.treeGui.file.isRewardClaimed(reward)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void addWidgets() {
        if (this.treeGui.file.canEdit()) {
            this.add((Widget)new ButtonAddChapter(this));
        }
        if (this.hasRewards()) {
            this.add((Widget)new ButtonClaimAllRewards(this));
        }
        if (Loader.isModLoaded((String)"ftbmoney")) {
            this.add((Widget)new ButtonOpenShop(this));
        }
        if (!this.treeGui.file.emergencyItems.isEmpty() && (this.treeGui.file.self != null || this.treeGui.file.canEdit())) {
            this.add((Widget)new ButtonEmergencyItems(this));
        }
        this.add((Widget)new ButtonWiki(this));
        if (this.treeGui.file.canEdit()) {
            this.add((Widget)new ButtonEditSettings(this));
        }
    }

    public void alignWidgets() {
        this.setSize(this.align((WidgetLayout)new WidgetLayout.Horizontal(1, 1, 0)), this.treeGui.chapterPanel.height);
        this.setX(this.getGui().width - this.width - 1);
    }
}

