/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.event;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModBlocks;
import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.entity.ChickenEntityProperties;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityAmphithere;
import com.github.alexthe666.iceandfire.entity.EntityCockatrice;
import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import com.github.alexthe666.iceandfire.entity.EntityStoneStatue;
import com.github.alexthe666.iceandfire.entity.FrozenEntityProperties;
import com.github.alexthe666.iceandfire.entity.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.IHearsSiren;
import com.github.alexthe666.iceandfire.entity.IPhasesThroughBlock;
import com.github.alexthe666.iceandfire.entity.IVillagerFear;
import com.github.alexthe666.iceandfire.entity.MiscPlayerProperties;
import com.github.alexthe666.iceandfire.entity.SirenEntityProperties;
import com.github.alexthe666.iceandfire.entity.StoneEntityProperties;
import com.github.alexthe666.iceandfire.entity.ai.EntitySheepAIFollowCyclops;
import com.github.alexthe666.iceandfire.entity.ai.VillagerAIFearUntamed;
import com.github.alexthe666.iceandfire.item.ItemSeaSerpentArmor;
import com.github.alexthe666.iceandfire.item.ItemTrollArmor;
import com.github.alexthe666.iceandfire.message.MessagePlayerHitMultipart;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EventLiving {
    private boolean stepHeightSwitched = false;
    private static final Predicate VILLAGER_FEAR = new Predicate<EntityLivingBase>(){

        public boolean apply(@Nullable EntityLivingBase entity) {
            return entity != null && entity instanceof IVillagerFear;
        }
    };
    Random rand = new Random();

    @SubscribeEvent
    public void onArrowCollide(ProjectileImpactEvent event) {
        if (event.getEntity() instanceof EntityArrow && ((EntityArrow)event.getEntity()).field_70250_c != null && event.getRayTraceResult() != null && event.getRayTraceResult().field_72308_g != null) {
            Entity shootingEntity = ((EntityArrow)event.getEntity()).field_70250_c;
            Entity shotEntity = event.getRayTraceResult().field_72308_g;
            if (shootingEntity instanceof EntityLivingBase && shootingEntity.func_184215_y(shotEntity) && shotEntity instanceof EntityTameable && ((EntityTameable)shotEntity).func_70909_n() && shotEntity.func_184191_r(shootingEntity)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttackMob(AttackEntityEvent event) {
        if (event.getTarget() instanceof EntityMutlipartPart && event.getEntity() instanceof EntityPlayer) {
            event.setCanceled(true);
            EntityLivingBase parent = ((EntityMutlipartPart)event.getTarget()).getParent();
            ((EntityPlayer)event.getEntity()).func_71059_n((Entity)parent);
            IceAndFire.NETWORK_WRAPPER.sendToServer((IMessage)new MessagePlayerHitMultipart(parent.func_145782_y()));
        }
    }

    @SubscribeEvent
    public void onGatherCollisionBoxes(GetCollisionBoxesEvent event) {
        if (event.getEntity() != null && event.getEntity() instanceof IPhasesThroughBlock) {
            Iterator itr = event.getCollisionBoxesList().iterator();
            while (itr.hasNext()) {
                AxisAlignedBB aabb = (AxisAlignedBB)itr.next();
                BlockPos pos = new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
                if (!((IPhasesThroughBlock)event.getEntity()).canPhaseThroughBlock(event.getWorld(), pos)) continue;
                itr.remove();
            }
        }
    }

    @SubscribeEvent
    public void onEntityFall(LivingFallEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            MiscPlayerProperties properties = (MiscPlayerProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), MiscPlayerProperties.class);
            if (properties.hasDismountedDragon) {
                event.setDamageMultiplier(0.0f);
                properties.hasDismountedDragon = false;
            }
        }
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        EntityPlayer player;
        if (event.getEntityBeingMounted() instanceof EntityDragonBase) {
            EntityDragonBase dragon = (EntityDragonBase)event.getEntityBeingMounted();
            if (event.isDismounting() && event.getEntityMounting() instanceof EntityPlayer && !event.getEntityMounting().field_70170_p.field_72995_K) {
                player = (EntityPlayer)event.getEntityMounting();
                if (dragon.func_152114_e((EntityLivingBase)((EntityPlayer)event.getEntityMounting()))) {
                    dragon.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
                    player.field_70143_R = -dragon.field_70131_O;
                } else {
                    dragon.field_70761_aq = dragon.field_70177_z;
                    float modTick_0 = dragon.getAnimationTick() - 25;
                    float modTick_1 = dragon.getAnimationTick() > 25 && dragon.getAnimationTick() < 55 ? 8.0f * MathHelper.func_76131_a((float)MathHelper.func_76126_a((float)((float)(Math.PI + (double)modTick_0 * 0.25))), (float)-0.8f, (float)0.8f) : 0.0f;
                    float modTick_2 = dragon.getAnimationTick() > 30 ? 10.0f : (float)Math.max(0, dragon.getAnimationTick() - 20);
                    float radius = 0.75f * (0.6f * dragon.getRenderSize() / 3.0f) * -3.0f;
                    float angle = (float)Math.PI / 180 * dragon.field_70761_aq + 3.15f + modTick_1 * 2.0f * 0.015f;
                    double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
                    double extraZ = radius * MathHelper.func_76134_b((float)angle);
                    double extraY = modTick_2 == 0.0f ? 0.0 : (double)0.035f * ((double)(dragon.getRenderSize() / 3.0f) + (double)modTick_2 * 0.5 * (double)(dragon.getRenderSize() / 3.0f));
                    player.func_70107_b(dragon.field_70165_t + extraX, dragon.field_70163_u + extraY, dragon.field_70161_v + extraZ);
                }
            }
        }
        if (event.getEntityBeingMounted() instanceof EntityHippogryph) {
            EntityHippogryph hippogryph = (EntityHippogryph)event.getEntityBeingMounted();
            if (event.isDismounting() && event.getEntityMounting() instanceof EntityPlayer && !event.getEntityMounting().field_70170_p.field_72995_K && hippogryph.func_152114_e((EntityLivingBase)((EntityPlayer)event.getEntityMounting()))) {
                player = (EntityPlayer)event.getEntityMounting();
                hippogryph.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            }
        }
    }

    @SubscribeEvent
    public void onEntityDamage(LivingHurtEvent event) {
        if (event.getSource().func_76352_a()) {
            float multi = 1.0f;
            if (event.getEntityLiving().func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ItemTrollArmor) {
                multi = (float)((double)multi - 0.1);
            }
            if (event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemTrollArmor) {
                multi = (float)((double)multi - 0.3);
            }
            if (event.getEntityLiving().func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() instanceof ItemTrollArmor) {
                multi = (float)((double)multi - 0.2);
            }
            if (event.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemTrollArmor) {
                multi = (float)((double)multi - 0.1);
            }
            event.setAmount(event.getAmount() * multi);
        }
    }

    @SubscribeEvent
    public void onEntityDrop(LivingDropsEvent event) {
        StoneEntityProperties properties;
        if (event.getEntityLiving() instanceof EntityWitherSkeleton) {
            event.getEntityLiving().func_145779_a(ModItems.witherbone, event.getEntityLiving().func_70681_au().nextInt(2));
        }
        if (event.getEntityLiving() instanceof EntityLiving && (properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), StoneEntityProperties.class)) != null && properties.isStone) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityDespawn(LivingSpawnEvent.AllowDespawn event) {
        StoneEntityProperties properties;
        if (event.getEntityLiving() instanceof EntityLiving && (properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), StoneEntityProperties.class)) != null && properties.isStone) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingAttacked(LivingAttackEvent event) {
        if (event.getSource().func_76346_g() != null) {
            Entity attacker = event.getSource().func_76346_g();
            if (EventLiving.isAnimaniaChicken((Entity)event.getEntityLiving()) && attacker instanceof EntityLivingBase) {
                EventLiving.signalChickenAlarm(event.getEntityLiving(), (EntityLivingBase)attacker);
            }
            if (DragonUtils.isVillager((Entity)event.getEntityLiving()) && attacker instanceof EntityLivingBase) {
                EventLiving.signalAmphithereAlarm(event.getEntityLiving(), (EntityLivingBase)attacker);
            }
        }
    }

    @SubscribeEvent
    public void onLivingSetTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() != null) {
            EntityLivingBase attacker = event.getEntityLiving();
            if (EventLiving.isAnimaniaChicken((Entity)event.getTarget())) {
                EventLiving.signalChickenAlarm(event.getTarget(), attacker);
            }
            if (DragonUtils.isVillager((Entity)event.getTarget())) {
                EventLiving.signalAmphithereAlarm(event.getTarget(), attacker);
            }
        }
    }

    private static void signalChickenAlarm(EntityLivingBase chicken, EntityLivingBase attacker) {
        float d0 = IceAndFire.CONFIG.cockatriceChickenSearchLength;
        List list = chicken.field_70170_p.func_72872_a(EntityCockatrice.class, new AxisAlignedBB(chicken.field_70165_t, chicken.field_70163_u, chicken.field_70161_v, chicken.field_70165_t + 1.0, chicken.field_70163_u + 1.0, chicken.field_70161_v + 1.0).func_72314_b((double)d0, 10.0, (double)d0));
        Collections.sort(list, new EntityAINearestAttackableTarget.Sorter((Entity)attacker));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                EntityCockatrice cockatrice;
                if (!(entity instanceof EntityCockatrice) || attacker instanceof EntityCockatrice || DragonUtils.hasSameOwner(cockatrice = (EntityCockatrice)entity, (Entity)attacker)) continue;
                if (attacker instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)attacker;
                    if (player.func_184812_l_() || cockatrice.func_152114_e((EntityLivingBase)player)) continue;
                    cockatrice.func_70624_b((EntityLivingBase)player);
                    continue;
                }
                cockatrice.func_70624_b(attacker);
            }
        }
    }

    private static void signalAmphithereAlarm(EntityLivingBase villager, EntityLivingBase attacker) {
        float d0 = IceAndFire.CONFIG.amphithereVillagerSearchLength;
        List list = villager.field_70170_p.func_72872_a(EntityAmphithere.class, new AxisAlignedBB(villager.field_70165_t - 1.0, villager.field_70163_u - 1.0, villager.field_70161_v - 1.0, villager.field_70165_t + 1.0, villager.field_70163_u + 1.0, villager.field_70161_v + 1.0).func_72314_b((double)d0, (double)d0, (double)d0));
        Collections.sort(list, new EntityAINearestAttackableTarget.Sorter((Entity)attacker));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                EntityAmphithere amphithere;
                if (!(entity instanceof EntityAmphithere) || attacker instanceof EntityAmphithere || DragonUtils.hasSameOwner(amphithere = (EntityAmphithere)entity, (Entity)attacker)) continue;
                if (attacker instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)attacker;
                    if (player.func_184812_l_() || amphithere.func_152114_e((EntityLivingBase)player)) continue;
                    amphithere.func_70624_b((EntityLivingBase)player);
                    continue;
                }
                amphithere.func_70624_b(attacker);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        if (event.getTarget() != null && EventLiving.isAnimaniaSheep(event.getTarget())) {
            float dist = IceAndFire.CONFIG.cyclopesSheepSearchLength;
            List list = event.getTarget().field_70170_p.func_72839_b((Entity)event.getEntityPlayer(), event.getEntityPlayer().func_174813_aQ().func_72321_a((double)dist, (double)dist, (double)dist));
            Collections.sort(list, new EntityAINearestAttackableTarget.Sorter((Entity)event.getEntityPlayer()));
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    EntityCyclops cyclops;
                    if (!(entity instanceof EntityCyclops) || (cyclops = (EntityCyclops)entity).isBlinded() || event.getEntityPlayer().field_71075_bZ.field_75098_d) continue;
                    cyclops.func_70624_b((EntityLivingBase)event.getEntityPlayer());
                }
            }
        }
        if (event.getTarget() instanceof EntityLiving) {
            boolean stonePlayer = event.getTarget() instanceof EntityStoneStatue;
            StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)((EntityLiving)event.getTarget()), StoneEntityProperties.class);
            if (properties != null && properties.isStone || stonePlayer) {
                ItemStack stack;
                ((EntityLiving)event.getTarget()).func_70606_j(((EntityLiving)event.getTarget()).func_110138_aP());
                if (event.getEntityPlayer() != null && (stack = event.getEntityPlayer().func_184614_ca()).func_77973_b() != null && (stack.func_77973_b().func_150897_b(Blocks.field_150348_b.func_176223_P()) || stack.func_77973_b().func_77658_a().contains("pickaxe"))) {
                    boolean silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0;
                    boolean ready = false;
                    if (properties != null && !stonePlayer) {
                        ++properties.breakLvl;
                        boolean bl = ready = properties.breakLvl > 9;
                    }
                    if (stonePlayer) {
                        EntityStoneStatue statue = (EntityStoneStatue)event.getTarget();
                        statue.setCrackAmount(statue.getCrackAmount() + 1);
                        boolean bl = ready = statue.getCrackAmount() > 9;
                    }
                    if (ready) {
                        event.getTarget().func_70106_y();
                        if (silkTouch) {
                            ItemStack statuette = new ItemStack(ModItems.stone_statue);
                            statuette.func_77982_d(new NBTTagCompound());
                            statuette.func_77978_p().func_74757_a("IAFStoneStatueEntityPlayer", stonePlayer);
                            statuette.func_77978_p().func_74768_a("IAFStoneStatueEntityID", stonePlayer ? 90 : EntityList.getID(event.getTarget().getClass()));
                            ((EntityLiving)event.getTarget()).func_70014_b(statuette.func_77978_p());
                            if (!event.getTarget().field_70170_p.field_72995_K) {
                                event.getTarget().func_70099_a(statuette, 1.0f);
                            }
                        } else if (!((EntityLiving)event.getTarget()).field_70170_p.field_72995_K) {
                            event.getTarget().func_145779_a(Item.func_150898_a((Block)Blocks.field_150347_e), 2 + event.getEntityLiving().func_70681_au().nextInt(4));
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityUseItem(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntityLiving() instanceof EntityPlayer && event.getEntityLiving().field_70125_A > 87.0f && event.getEntityLiving().func_184187_bx() != null && event.getEntityLiving().func_184187_bx() instanceof EntityDragonBase) {
            ((EntityDragonBase)event.getEntityLiving().func_184187_bx()).func_184645_a((EntityPlayer)event.getEntityLiving(), event.getHand());
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        SirenEntityProperties sirenProps;
        FrozenEntityProperties frozenProps;
        ChickenEntityProperties chickenProps;
        if (event.getEntityLiving().func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ItemSeaSerpentArmor || event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemSeaSerpentArmor || event.getEntityLiving().func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() instanceof ItemSeaSerpentArmor || event.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemSeaSerpentArmor) {
            event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76427_o, 50, 0, false, false));
            if (event.getEntityLiving().func_70026_G()) {
                int headMod = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ItemSeaSerpentArmor ? 1 : 0;
                int chestMod = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemSeaSerpentArmor ? 1 : 0;
                int legMod = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() instanceof ItemSeaSerpentArmor ? 1 : 0;
                int footMod = event.getEntityLiving().func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemSeaSerpentArmor ? 1 : 0;
                event.getEntityLiving().func_70690_d(new PotionEffect(MobEffects.field_76420_g, 50, headMod + chestMod + legMod + footMod - 1, false, false));
            }
        }
        if (IceAndFire.CONFIG.chickensLayRottenEggs && !event.getEntityLiving().field_70170_p.field_72995_K && EventLiving.isAnimaniaChicken((Entity)event.getEntityLiving()) && !event.getEntityLiving().func_70631_g_() && event.getEntityLiving() instanceof EntityAnimal && (chickenProps = (ChickenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), ChickenEntityProperties.class)) != null) {
            if (chickenProps.timeUntilNextEgg < 0) {
                chickenProps.timeUntilNextEgg = 0;
            }
            if (chickenProps.timeUntilNextEgg == 0) {
                if (event.getEntityLiving().func_70681_au().nextInt(IceAndFire.CONFIG.cockatriceEggChance + 1) == 0 && event.getEntityLiving().field_70173_aa > 30) {
                    event.getEntityLiving().func_184185_a(SoundEvents.field_187666_Z, 2.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
                    event.getEntityLiving().func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
                    event.getEntityLiving().func_145779_a(ModItems.rotten_egg, 1);
                }
                chickenProps.timeUntilNextEgg = chickenProps.generateTime();
            } else if (chickenProps.timeUntilNextEgg > 0) {
                --chickenProps.timeUntilNextEgg;
            }
        }
        if ((frozenProps = (FrozenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), FrozenEntityProperties.class)) != null) {
            boolean prevFrozen = frozenProps.isFrozen;
            if (event.getEntityLiving() instanceof EntityIceDragon) {
                frozenProps.isFrozen = false;
            }
            if (!event.getEntityLiving().field_70170_p.field_72995_K) {
                if (frozenProps.isFrozen && event.getEntityLiving().func_70027_ad()) {
                    frozenProps.isFrozen = false;
                    event.getEntityLiving().func_70066_B();
                }
                if (event.getEntityLiving().field_70725_aQ > 0) {
                    frozenProps.isFrozen = false;
                }
                if (frozenProps.ticksUntilUnfrozen > 0) {
                    --frozenProps.ticksUntilUnfrozen;
                } else {
                    frozenProps.ticksUntilUnfrozen = 0;
                    frozenProps.isFrozen = false;
                }
            }
            if (!(!frozenProps.isFrozen || event.getEntityLiving() instanceof EntityPlayer && ((EntityPlayer)event.getEntityLiving()).func_184812_l_())) {
                event.getEntityLiving().field_70159_w *= 0.25;
                event.getEntityLiving().field_70179_y *= 0.25;
                if (!(event.getEntityLiving() instanceof EntityDragon)) {
                    event.getEntityLiving().field_70181_x -= 0.1;
                }
            }
            if (prevFrozen != frozenProps.isFrozen) {
                if (frozenProps.isFrozen) {
                    event.getEntityLiving().func_184185_a(SoundEvents.field_187567_bP, 1.0f, 1.0f);
                } else {
                    for (int i = 0; i < 15; ++i) {
                        event.getEntityLiving().field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, event.getEntityLiving().field_70165_t + (this.rand.nextDouble() - 0.5) * (double)event.getEntityLiving().field_70130_N, event.getEntityLiving().field_70163_u + this.rand.nextDouble() * (double)event.getEntityLiving().field_70131_O, event.getEntityLiving().field_70161_v + (this.rand.nextDouble() - 0.5) * (double)event.getEntityLiving().field_70130_N, 0.0, 0.0, 0.0, new int[]{Block.func_149682_b((Block)ModBlocks.dragon_ice)});
                    }
                    event.getEntityLiving().func_184185_a(SoundEvents.field_187561_bM, 3.0f, 1.0f);
                }
            }
        }
        if ((event.getEntityLiving() instanceof EntityPlayer || event.getEntityLiving() instanceof EntityVillager || event.getEntityLiving() instanceof IHearsSiren) && (sirenProps = (SirenEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), SirenEntityProperties.class)) != null && sirenProps.sirenID != 0) {
            EntitySiren closestSiren = sirenProps.getSiren(event.getEntityLiving().field_70170_p);
            if (closestSiren != null && closestSiren.isActuallySinging()) {
                this.stepHeightSwitched = false;
                if (EntitySiren.isWearingEarplugs(event.getEntityLiving()) || sirenProps.singTime > IceAndFire.CONFIG.sirenMaxSingTime) {
                    sirenProps.isCharmed = false;
                    sirenProps.sirenID = 0;
                    sirenProps.singTime = 0;
                    closestSiren.singCooldown = IceAndFire.CONFIG.sirenTimeBetweenSongs;
                } else {
                    sirenProps.isCharmed = true;
                    ++sirenProps.singTime;
                    if (this.rand.nextInt(7) == 0) {
                        for (int i = 0; i < 5; ++i) {
                            event.getEntityLiving().field_70170_p.func_175688_a(EnumParticleTypes.HEART, event.getEntityLiving().field_70165_t + (this.rand.nextDouble() - 0.5) * 3.0, event.getEntityLiving().field_70163_u + (this.rand.nextDouble() - 0.5) * 3.0, event.getEntityLiving().field_70161_v + (this.rand.nextDouble() - 0.5) * 3.0, 0.0, 0.0, 0.0, new int[0]);
                        }
                    }
                    EntityLivingBase entity = event.getEntityLiving();
                    entity.field_70159_w += (Math.signum(closestSiren.field_70165_t - entity.field_70165_t) * 0.5 - entity.field_70159_w) * 0.100000000372529;
                    entity.field_70181_x += (Math.signum(closestSiren.field_70163_u - entity.field_70163_u + 1.0) * 0.5 - entity.field_70181_x) * 0.100000000372529;
                    entity.field_70179_y += (Math.signum(closestSiren.field_70161_v - entity.field_70161_v) * 0.5 - entity.field_70179_y) * 0.100000000372529;
                    float angle = (float)(Math.atan2(entity.field_70179_y, entity.field_70159_w) * 180.0 / Math.PI) - 90.0f;
                    entity.field_70138_W = 1.0f;
                    double d0 = closestSiren.field_70165_t - entity.field_70165_t;
                    double d2 = closestSiren.field_70161_v - entity.field_70161_v;
                    double d1 = closestSiren.field_70163_u - 1.0 - entity.field_70163_u;
                    if (entity.func_184218_aH()) {
                        entity.func_184210_p();
                    }
                    if (entity.field_70122_E && entity.field_70123_F) {
                        entity.field_70181_x = 0.42f;
                        if (entity.func_70644_a(MobEffects.field_76430_j)) {
                            entity.field_70181_x += (double)((float)(entity.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                        }
                        if (entity.func_70051_ag()) {
                            float f = entity.field_70177_z * ((float)Math.PI / 180);
                            entity.field_70159_w -= (double)(MathHelper.func_76126_a((float)f) * 0.2f);
                            entity.field_70179_y += (double)(MathHelper.func_76134_b((float)f) * 0.2f);
                        }
                        entity.field_70160_al = true;
                        ForgeHooks.onLivingJump((EntityLivingBase)entity);
                    }
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.29577951308232));
                    entity.field_70125_A = EventLiving.updateRotation(entity.field_70125_A, f1, 30.0f);
                    entity.field_70177_z = EventLiving.updateRotation(entity.field_70177_z, f, 30.0f);
                    if ((double)entity.func_70032_d((Entity)closestSiren) < 5.0) {
                        sirenProps.isCharmed = false;
                        sirenProps.sirenID = 0;
                        sirenProps.singTime = 0;
                        closestSiren.singCooldown = IceAndFire.CONFIG.sirenTimeBetweenSongs;
                        closestSiren.setSinging(false);
                        closestSiren.func_70624_b(entity);
                        closestSiren.setAggressive(true);
                        closestSiren.triggerOtherSirens(entity);
                    }
                    if (closestSiren.field_70128_L || entity.func_70032_d((Entity)closestSiren) > 64.0f || sirenProps.getSiren(event.getEntityLiving().field_70170_p) == null || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184812_l_()) {
                        sirenProps.isCharmed = false;
                        sirenProps.sirenID = 0;
                        sirenProps.singTime = 0;
                    }
                }
            } else if (!sirenProps.isCharmed && !this.stepHeightSwitched) {
                event.getEntityLiving().field_70138_W = 0.6f;
                this.stepHeightSwitched = true;
            }
        }
        if (event.getEntityLiving() instanceof EntityLiving) {
            boolean stonePlayer = event.getEntityLiving() instanceof EntityStoneStatue;
            StoneEntityProperties properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), StoneEntityProperties.class);
            if (properties != null && properties.isStone || stonePlayer) {
                EntityLiving living = (EntityLiving)event.getEntityLiving();
                if (!living.func_184188_bt().isEmpty()) {
                    for (Entity e : living.func_184188_bt()) {
                        e.func_184210_p();
                    }
                }
                living.field_70159_w *= 0.0;
                living.field_70179_y *= 0.0;
                living.field_70181_x -= 0.1;
                living.field_70733_aJ = 0.0f;
                living.field_184619_aG = 0.0f;
                living.func_82142_c(!stonePlayer);
                living.field_70757_a = 0;
                living.field_70737_aN = 0;
                living.field_70172_ad = living.field_70771_an - 1;
                living.func_70066_B();
                if (living instanceof EntityAnimal) {
                    ((EntityAnimal)living).func_70875_t();
                }
                if (!living.func_175446_cd()) {
                    living.func_94061_f(true);
                }
                if (living.func_70638_az() != null) {
                    living.func_70624_b(null);
                }
                if (living instanceof EntityHorse) {
                    EntityHorse horse = (EntityHorse)living;
                    horse.field_110278_bp = 0;
                    horse.func_110227_p(false);
                }
            }
        }
    }

    public static float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        StoneEntityProperties properties;
        if (event.getEntityLiving() instanceof EntityLiving && (properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), StoneEntityProperties.class)) != null && properties.isStone) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        StoneEntityProperties properties;
        if (event.getEntityLiving() instanceof EntityLiving && (properties = (StoneEntityProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)event.getEntityLiving(), StoneEntityProperties.class)) != null && properties.isStone) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer() != null && event.getWorld().func_180495_p(event.getPos()).func_177230_c() instanceof BlockChest) {
            float dist = IceAndFire.CONFIG.dragonGoldSearchLength;
            List list = event.getWorld().func_72839_b((Entity)event.getEntityPlayer(), event.getEntityPlayer().func_174813_aQ().func_72321_a((double)dist, (double)dist, (double)dist));
            Collections.sort(list, new EntityAINearestAttackableTarget.Sorter((Entity)event.getEntityPlayer()));
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    EntityDragonBase dragon;
                    if (!(entity instanceof EntityDragonBase) || (dragon = (EntityDragonBase)entity).func_70909_n() || dragon.isModelDead() || dragon.func_152114_e((EntityLivingBase)event.getEntityPlayer()) || event.getEntityPlayer().field_71075_bZ.field_75098_d) continue;
                    dragon.setSleeping(false);
                    dragon.func_70904_g(false);
                    dragon.func_70624_b((EntityLivingBase)event.getEntityPlayer());
                }
            }
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (event.getPlayer() != null && (event.getState().func_177230_c() == ModBlocks.goldPile || event.getState().func_177230_c() == ModBlocks.silverPile)) {
            float dist = IceAndFire.CONFIG.dragonGoldSearchLength;
            List list = event.getWorld().func_72839_b((Entity)event.getPlayer(), event.getPlayer().func_174813_aQ().func_72321_a((double)dist, (double)dist, (double)dist));
            Collections.sort(list, new EntityAINearestAttackableTarget.Sorter((Entity)event.getPlayer()));
            if (!list.isEmpty()) {
                for (Entity entity : list) {
                    EntityDragonBase dragon;
                    if (!(entity instanceof EntityDragonBase) || (dragon = (EntityDragonBase)entity).func_70909_n() || dragon.isModelDead() || dragon.func_152114_e((EntityLivingBase)event.getPlayer()) || event.getPlayer().field_71075_bZ.field_75098_d) continue;
                    dragon.setSleeping(false);
                    dragon.func_70904_g(false);
                    dragon.func_70624_b((EntityLivingBase)event.getPlayer());
                }
            }
        }
    }

    @SubscribeEvent
    public void onChestGenerated(LootTableLoadEvent event) {
        LootPool pool1;
        if (event.getName().equals((Object)LootTableList.field_186422_d) && (pool1 = event.getTable().getPool("pool1")) != null) {
            pool1.addEntry((LootEntry)new LootEntryItem(ModItems.manuscript, 10, 5, new LootFunction[0], new LootCondition[0], "iceandfire:manuscript"));
        }
    }

    @SubscribeEvent
    public void onPlayerLeaveEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player != null && !event.player.func_184188_bt().isEmpty()) {
            Iterator itr = event.player.func_184188_bt().iterator();
            while (itr.hasNext()) {
                ((Entity)itr.next()).func_184210_p();
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        EntityAnimal animal;
        if (event.getEntity() != null && EventLiving.isAnimaniaSheep(event.getEntity()) && event.getEntity() instanceof EntityAnimal) {
            animal = (EntityAnimal)event.getEntity();
            animal.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntitySheepAIFollowCyclops(animal, 1.2));
        }
        if (event.getEntity() != null && DragonUtils.isVillager(event.getEntity()) && event.getEntity() instanceof EntityCreature && IceAndFire.CONFIG.villagersFearDragons) {
            EntityCreature villager = (EntityCreature)event.getEntity();
            villager.field_70714_bg.func_75776_a(1, (EntityAIBase)new VillagerAIFearUntamed(villager, EntityLivingBase.class, (Predicate<EntityLivingBase>)VILLAGER_FEAR, 12.0f, 0.8, 0.8));
        }
        if (event.getEntity() != null && DragonUtils.isLivestock(event.getEntity()) && event.getEntity() instanceof EntityCreature && IceAndFire.CONFIG.animalsFearDragons) {
            animal = (EntityCreature)event.getEntity();
            animal.field_70714_bg.func_75776_a(1, (EntityAIBase)new VillagerAIFearUntamed((EntityCreature)animal, EntityLivingBase.class, new Predicate<EntityLivingBase>((EntityCreature)animal){
                final /* synthetic */ EntityCreature val$animal;
                {
                    this.val$animal = entityCreature;
                }

                public boolean apply(@Nullable EntityLivingBase entity) {
                    return entity != null && entity instanceof IAnimalFear && ((IAnimalFear)entity).shouldAnimalsFear((Entity)this.val$animal);
                }
            }, 12.0f, 1.2, 1.5));
        }
    }

    public static boolean isAnimaniaSheep(Entity entity) {
        String className = entity.getClass().getName();
        return className.contains("sheep") || entity instanceof EntitySheep;
    }

    public static boolean isAnimaniaChicken(Entity entity) {
        String className = entity.getClass().getName();
        return (className.contains("chicken") || entity instanceof EntityChicken) && entity instanceof EntityLiving && !entity.isCreatureType(EnumCreatureType.MONSTER, false);
    }

    public static boolean isAnimaniaFerret(Entity entity) {
        String className = entity.getClass().getName();
        return className.contains("ferret") || className.contains("polecat");
    }
}

