/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.core.ModItems;
import com.github.alexthe666.iceandfire.core.ModSounds;
import com.github.alexthe666.iceandfire.entity.DragonUtils;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDragonIceCharge;
import com.github.alexthe666.iceandfire.entity.EntityDragonIceProjectile;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAITempt;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIAirTarget;
import com.github.alexthe666.iceandfire.entity.ai.DragonAILookIdle;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIMate;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITarget;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWander;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWatchClosest;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWaterTarget;
import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.ilexiconn.llibrary.server.animation.Animation;
import net.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityIceDragon
extends EntityDragonBase {
    private static final DataParameter<Boolean> SWIMMING = EntityDataManager.func_187226_a(EntityIceDragon.class, (DataSerializer)DataSerializers.field_187198_h);
    public static Animation ANIMATION_FIRECHARGE;
    public static final float[] growth_stage_1;
    public static final float[] growth_stage_2;
    public static final float[] growth_stage_3;
    public static final float[] growth_stage_4;
    public static final float[] growth_stage_5;
    public boolean isSwimming;
    public float swimProgress;
    public int ticksSwiming;
    public BlockPos waterTarget;
    public static final ResourceLocation FEMALE_LOOT;
    public static final ResourceLocation MALE_LOOT;
    public static final ResourceLocation SKELETON_LOOT;

    public EntityIceDragon(World worldIn) {
        super(worldIn, 1.0, 1 + IceAndFire.CONFIG.dragonAttackDamage, (double)IceAndFire.CONFIG.dragonHealth * 0.04, IceAndFire.CONFIG.dragonHealth, 0.15f, 0.4f);
        this.func_70105_a(0.78f, 1.2f);
        this.field_70158_ak = true;
        ANIMATION_SPEAK = Animation.create((int)20);
        ANIMATION_BITE = Animation.create((int)35);
        ANIMATION_SHAKEPREY = Animation.create((int)65);
        ANIMATION_TAILWHACK = Animation.create((int)40);
        ANIMATION_FIRECHARGE = Animation.create((int)25);
        ANIMATION_WINGBLAST = Animation.create((int)50);
        ANIMATION_ROAR = Animation.create((int)40);
        this.growth_stages = new float[][]{growth_stage_1, growth_stage_2, growth_stage_3, growth_stage_4, growth_stage_5};
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new DragonAIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.5, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AquaticAITempt((EntityCreature)this, 1.0, ModItems.frost_stew, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DragonAIAirTarget(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new DragonAIWaterTarget(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new DragonAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DragonAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new DragonAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new DragonAITarget<Entity>(this, EntityLivingBase.class, true, new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity instanceof EntityLivingBase && DragonUtils.isAlive((EntityLivingBase)entity);
            }
        }));
        this.field_70715_bh.func_75776_a(5, new DragonAITargetItems((EntityCreature)this, false));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWIMMING, (Object)false);
    }

    @Override
    public String getVariantName(int variant) {
        switch (variant) {
            default: {
                return "blue_";
            }
            case 1: {
                return "white_";
            }
            case 2: {
                return "sapphire_";
            }
            case 3: 
        }
        return "silver_";
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public Item getVariantScale(int variant) {
        switch (variant) {
            default: {
                return ModItems.dragonscales_blue;
            }
            case 1: {
                return ModItems.dragonscales_white;
            }
            case 2: {
                return ModItems.dragonscales_sapphire;
            }
            case 3: 
        }
        return ModItems.dragonscales_silver;
    }

    @Override
    public Item getVariantEgg(int variant) {
        switch (variant) {
            default: {
                return ModItems.dragonegg_blue;
            }
            case 1: {
                return ModItems.dragonegg_white;
            }
            case 2: {
                return ModItems.dragonegg_sapphire;
            }
            case 3: 
        }
        return ModItems.dragonegg_silver;
    }

    public boolean func_96092_aw() {
        return false;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Swimming", this.isSwimming());
        compound.func_74768_a("SwimmingTicks", this.ticksSwiming);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSwimming(compound.func_74767_n("Swimming"));
        this.ticksSwiming = compound.func_74762_e("SwimmingTicks");
    }

    @Override
    public boolean func_82171_bF() {
        return true;
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == ANIMATION_WINGBLAST) {
            return false;
        }
        switch (new Random().nextInt(4)) {
            case 0: {
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                    return false;
                }
                if (this.getAnimationTick() <= 15 || this.getAnimationTick() >= 25) break;
                boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                this.attackDecision = this.func_70681_au().nextBoolean();
                return flag;
            }
            case 1: {
                if (new Random().nextInt(2) == 0 && this.isDirectPathBetweenPoints((Entity)this, this.func_174791_d(), entityIn.func_174791_d()) && entityIn.field_70130_N < this.field_70130_N * 0.5f && this.func_184179_bs() == null && this.getDragonStage() > 1 && !(entityIn instanceof EntityDragonBase) && !DragonUtils.isAnimaniaMob(entityIn)) {
                    if (this.getAnimation() == ANIMATION_SHAKEPREY) break;
                    this.setAnimation(ANIMATION_SHAKEPREY);
                    entityIn.func_184220_m((Entity)this);
                    this.attackDecision = this.func_70681_au().nextBoolean();
                    return true;
                }
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                    return false;
                }
                if (this.getAnimationTick() <= 15 || this.getAnimationTick() >= 25) break;
                boolean flag1 = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                this.attackDecision = this.func_70681_au().nextBoolean();
                return flag1;
            }
            case 2: {
                if (this.getAnimation() != ANIMATION_TAILWHACK) {
                    this.setAnimation(ANIMATION_TAILWHACK);
                    return false;
                }
                if (this.getAnimationTick() <= 20 || this.getAnimationTick() >= 25) break;
                boolean flag2 = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                if (entityIn instanceof EntityLivingBase) {
                    ((EntityLivingBase)entityIn).func_70653_a(entityIn, 1.0f, 1.0, 1.0);
                }
                this.attackDecision = this.func_70681_au().nextBoolean();
                return flag2;
            }
            case 3: {
                if (this.field_70122_E && !this.isHovering() && !this.isFlying() && this.getDragonStage() > 2) {
                    if (this.getAnimation() == ANIMATION_WINGBLAST) break;
                    this.setAnimation(ANIMATION_WINGBLAST);
                    return false;
                }
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                    return false;
                }
                if (this.getAnimationTick() <= 15 || this.getAnimationTick() >= 25) break;
                boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                this.attackDecision = this.func_70681_au().nextBoolean();
                return flag;
            }
            default: {
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                    return false;
                }
                if (this.getAnimationTick() <= 15 || this.getAnimationTick() >= 25) break;
                boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
                this.attackDecision = this.func_70681_au().nextBoolean();
                return flag;
            }
        }
        return false;
    }

    @Override
    public void func_70636_d() {
        boolean swimming;
        super.func_70636_d();
        if (this.func_180799_ab() && !this.isFlying() && this.func_184188_bt().isEmpty() && !this.func_70631_g_() && !this.isHovering() && !this.isSleeping() && this.canMove() && this.field_70122_E) {
            this.setHovering(true);
            this.setSleeping(false);
            this.func_70904_g(false);
            this.flyHovering = 0;
            this.flyTicks = 0;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() != null && !this.isSleeping() && this.getAnimation() != ANIMATION_SHAKEPREY) {
                if (!(this.attackDecision && !this.isFlying() || this.isTargetBlocked(new Vec3d(this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u, this.func_70638_az().field_70161_v)))) {
                    this.shootIceAtMob(this.func_70638_az());
                } else if (this.func_174813_aQ().func_72314_b((double)(this.getRenderSize() * 0.5f), (double)(this.getRenderSize() * 0.5f), (double)(this.getRenderSize() * 0.5f)).func_72326_a(this.func_70638_az().func_174813_aQ())) {
                    this.func_70652_k((Entity)this.func_70638_az());
                }
            } else {
                this.setBreathingFire(false);
            }
        }
        boolean bl = swimming = this.isSwimming() && !this.isHovering() && !this.isFlying() && this.ridingProgress == 0.0f;
        if (swimming && this.swimProgress < 20.0f) {
            this.swimProgress += 0.5f;
        } else if (!swimming && this.swimProgress > 0.0f) {
            this.swimProgress -= 0.5f;
        }
        if (this.isInsideWaterBlock() && !this.isSwimming()) {
            this.setSwimming(true);
            this.ticksSwiming = 0;
        }
        if (this.isInsideWaterBlock()) {
            this.swimAround();
        }
        if (!this.isInsideWaterBlock() && this.isSwimming()) {
            this.setSwimming(false);
            this.ticksSwiming = 0;
        }
        if (this.isSwimming()) {
            ++this.ticksSwiming;
            if (this.isInsideWaterBlock() && this.ticksSwiming > 1000 && !this.func_70631_g_() && !this.isHovering() && !this.isFlying()) {
                this.setHovering(true);
            }
        }
    }

    public boolean isInsideWaterBlock() {
        return this.func_70055_a(Material.field_151586_h);
    }

    @Override
    public void riderShootFire(Entity controller) {
        if (this.func_70681_au().nextInt(5) == 0 && !this.func_70631_g_()) {
            if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                this.setAnimation(ANIMATION_FIRECHARGE);
            } else if (this.getAnimationTick() == 15) {
                this.field_70177_z = this.field_70761_aq;
                float headPosX = (float)(this.field_70165_t + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosZ = (float)(this.field_70161_v + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosY = (float)(this.field_70163_u + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                this.func_184185_a(ModSounds.ICEDRAGON_BREATH, 4.0f, 1.0f);
                double d2 = controller.func_70040_Z().field_72450_a;
                double d3 = controller.func_70040_Z().field_72448_b;
                double d4 = controller.func_70040_Z().field_72449_c;
                EntityDragonIceCharge entitylargefireball = new EntityDragonIceCharge(this.field_70170_p, this, d2, d3, d4);
                float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                entitylargefireball.setSizes(size, size);
                entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                }
            }
        } else if (this.isBreathingFire()) {
            if (this.isActuallyBreathingFire() && this.field_70173_aa % 3 == 0) {
                this.field_70177_z = this.field_70761_aq;
                float headPosX = (float)(this.field_70165_t + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosZ = (float)(this.field_70161_v + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                float headPosY = (float)(this.field_70163_u + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                double d2 = controller.func_70040_Z().field_72450_a;
                double d3 = controller.func_70040_Z().field_72448_b;
                double d4 = controller.func_70040_Z().field_72449_c;
                EntityDragonIceProjectile entitylargefireball = new EntityDragonIceProjectile(this.field_70170_p, this, d2, d3, d4);
                this.func_184185_a(ModSounds.ICEDRAGON_BREATH, 4.0f, 1.0f);
                float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                }
            }
        } else {
            this.setBreathingFire(true);
        }
    }

    public void swimAround() {
        if (this.waterTarget != null) {
            if (!this.isTargetInWater() || this.func_70011_f((double)this.waterTarget.func_177958_n() + 0.5, (double)this.waterTarget.func_177956_o() + 0.5, (double)this.waterTarget.func_177952_p() + 0.5) < 2.0 || this.ticksSwiming > 6000) {
                this.waterTarget = null;
            }
            this.swimTowardsTarget();
        }
    }

    @Override
    public ResourceLocation getDeadLootTable() {
        if (this.getDeathStage() >= this.getAgeInDays() / 5 / 2) {
            return SKELETON_LOOT;
        }
        return this.isMale() ? MALE_LOOT : FEMALE_LOOT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void swimTowardsTarget() {
        if (this.waterTarget != null && this.isTargetInWater() && this.isInsideWaterBlock()) {
            Vec3d vec3d = new Vec3d((double)this.waterTarget.func_177958_n(), this.field_70163_u, (double)this.waterTarget.func_177952_p());
            if (this.getDistanceSquared(vec3d) > 3.0f) {
                double targetX = (double)this.waterTarget.func_177958_n() + 0.5 - this.field_70165_t;
                double targetY = (double)this.waterTarget.func_177956_o() + 1.0 - this.field_70163_u;
                double targetZ = (double)this.waterTarget.func_177952_p() + 0.5 - this.field_70161_v;
                this.field_70159_w += (Math.signum(targetX) * 0.5 - this.field_70159_w) * 0.100000000372529 * (double)(3 * (this.getAgeInDays() / 125) + 2);
                this.field_70181_x += (Math.signum(targetY) * 0.5 - this.field_70181_x) * 0.100000000372529 * (double)(3 * (this.getAgeInDays() / 125) + 2);
                this.field_70179_y += (Math.signum(targetZ) * 0.5 - this.field_70179_y) * 0.100000000372529 * (double)(3 * (this.getAgeInDays() / 125) + 2);
                float angle = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
                float rotation = MathHelper.func_76142_g((float)(angle - this.field_70177_z));
                this.field_191988_bg = 0.5f;
                this.field_70126_B = this.field_70177_z;
                this.field_70177_z += rotation;
                return;
            }
        }
        this.waterTarget = null;
    }

    protected boolean isTargetInWater() {
        return this.waterTarget != null && this.field_70170_p.func_180495_p(this.waterTarget).func_185904_a() == Material.field_151586_h;
    }

    private void shootIceAtMob(EntityLivingBase entity) {
        if (!this.attackDecision) {
            if (this.func_70681_au().nextInt(5) == 0) {
                if (this.getAnimation() != ANIMATION_FIRECHARGE) {
                    this.setAnimation(ANIMATION_FIRECHARGE);
                } else if (this.getAnimationTick() == 15) {
                    this.field_70177_z = this.field_70761_aq;
                    float headPosX = (float)(this.field_70165_t + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosZ = (float)(this.field_70161_v + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosY = (float)(this.field_70163_u + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                    double d2 = entity.field_70165_t - (double)headPosX;
                    double d3 = entity.field_70163_u - (double)headPosY;
                    double d4 = entity.field_70161_v - (double)headPosZ;
                    this.func_184185_a(ModSounds.ICEDRAGON_BREATH, 4.0f, 1.0f);
                    EntityDragonIceCharge entitylargefireball = new EntityDragonIceCharge(this.field_70170_p, this, d2, d3, d4);
                    float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                    entitylargefireball.setSizes(size, size);
                    entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                    }
                    if (entity.field_70128_L || entity == null) {
                        this.setBreathingFire(false);
                        this.attackDecision = true;
                    }
                }
            } else if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire() && this.field_70173_aa % 3 == 0) {
                    this.field_70177_z = this.field_70761_aq;
                    float headPosX = (float)(this.field_70165_t + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.cos((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosZ = (float)(this.field_70161_v + (double)(1.8f * this.getRenderSize() * 0.3f) * Math.sin((double)(this.field_70177_z + 90.0f) * Math.PI / 180.0));
                    float headPosY = (float)(this.field_70163_u + 0.5 * (double)this.getRenderSize() * (double)0.3f);
                    double d2 = entity.field_70165_t - (double)headPosX;
                    double d3 = entity.field_70163_u - (double)headPosY;
                    double d4 = entity.field_70161_v - (double)headPosZ;
                    this.func_184185_a(ModSounds.ICEDRAGON_BREATH, 4.0f, 1.0f);
                    EntityDragonIceProjectile entitylargefireball = new EntityDragonIceProjectile(this.field_70170_p, this, d2, d3, d4);
                    float size = this.func_70631_g_() ? 0.4f : (this.isAdult() ? 1.3f : 0.8f);
                    entitylargefireball.func_70107_b(headPosX, headPosY, headPosZ);
                    if (!this.field_70170_p.field_72995_K && !entity.field_70128_L) {
                        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
                    }
                    entitylargefireball.setSizes(size, size);
                    if (entity.field_70128_L || entity == null) {
                        this.setBreathingFire(false);
                        this.attackDecision = true;
                    }
                }
            } else {
                this.setBreathingFire(true);
            }
        }
        this.func_70625_a((Entity)entity, 360.0f, 360.0f);
    }

    public boolean isSwimming() {
        if (this.field_70170_p.field_72995_K) {
            boolean swimming;
            this.isSwimming = swimming = ((Boolean)this.field_70180_af.func_187225_a(SWIMMING)).booleanValue();
            return swimming;
        }
        return this.isSwimming;
    }

    public void setSwimming(boolean swimming) {
        this.field_70180_af.func_187227_b(SWIMMING, (Object)swimming);
        if (!this.field_70170_p.field_72995_K) {
            this.isSwimming = swimming;
        }
    }

    protected SoundEvent func_184639_G() {
        return this.isTeen() ? ModSounds.ICEDRAGON_TEEN_IDLE : (this.isAdult() ? ModSounds.ICEDRAGON_ADULT_IDLE : ModSounds.ICEDRAGON_CHILD_IDLE);
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return this.isTeen() ? ModSounds.ICEDRAGON_TEEN_HURT : (this.isAdult() ? ModSounds.ICEDRAGON_ADULT_HURT : ModSounds.ICEDRAGON_CHILD_HURT);
    }

    protected SoundEvent func_184615_bR() {
        return this.isTeen() ? ModSounds.ICEDRAGON_TEEN_DEATH : (this.isAdult() ? ModSounds.ICEDRAGON_ADULT_DEATH : ModSounds.ICEDRAGON_CHILD_DEATH);
    }

    @Override
    public SoundEvent getRoarSound() {
        return this.isTeen() ? ModSounds.ICEDRAGON_TEEN_ROAR : (this.isAdult() ? ModSounds.ICEDRAGON_ADULT_ROAR : ModSounds.ICEDRAGON_CHILD_ROAR);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, EntityDragonBase.ANIMATION_EAT, EntityDragonBase.ANIMATION_SPEAK, EntityDragonBase.ANIMATION_BITE, EntityDragonBase.ANIMATION_SHAKEPREY, ANIMATION_TAILWHACK, ANIMATION_FIRECHARGE, ANIMATION_WINGBLAST, ANIMATION_ROAR};
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() == ModItems.frost_stew;
    }

    static {
        growth_stage_1 = new float[]{1.0f, 3.0f};
        growth_stage_2 = new float[]{3.0f, 7.0f};
        growth_stage_3 = new float[]{7.0f, 12.5f};
        growth_stage_4 = new float[]{12.5f, 20.0f};
        growth_stage_5 = new float[]{20.0f, 30.0f};
        FEMALE_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "dragon/ice_dragon_female"));
        MALE_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "dragon/ice_dragon_male"));
        SKELETON_LOOT = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("iceandfire", "dragon/ice_dragon_skeleton"));
    }
}

