/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.common.book.Book;

public class GuiBookEntry
extends GuiBook
implements IComponentRenderContext {
    BookEntry entry;
    BookPage leftPage;
    BookPage rightPage;
    Map<GuiButton, Runnable> customButtons = new HashMap<GuiButton, Runnable>();

    public GuiBookEntry(Book book, BookEntry entry) {
        this(book, entry, 0);
    }

    public GuiBookEntry(Book book, BookEntry entry, int page) {
        super(book);
        this.entry = entry;
        this.page = page;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.maxpages = (int)Math.ceil((float)this.entry.getPages().size() / 2.0f);
        this.setupPages();
    }

    @Override
    public void onFirstOpened() {
        int index;
        super.onFirstOpened();
        boolean dirty = false;
        String key = this.entry.getResource().toString();
        PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(this.book);
        if (!data.viewedEntries.contains(key)) {
            data.viewedEntries.add(key);
            dirty = true;
            this.entry.markReadStateDirty();
        }
        if ((index = data.history.indexOf(key)) != 0) {
            if (index > 0) {
                data.history.remove(key);
            }
            data.history.add(0, key);
            while (data.history.size() > 13) {
                data.history.remove(13);
            }
            dirty = true;
        }
        if (dirty) {
            PersistentData.save();
        }
    }

    @Override
    void drawForegroundElements(int mouseX, int mouseY, float partialTicks) {
        this.drawPage(this.leftPage, mouseX, mouseY, partialTicks);
        this.drawPage(this.rightPage, mouseX, mouseY, partialTicks);
        if (this.rightPage == null) {
            GuiBookEntry.drawPageFiller(this.leftPage.book);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.clickPage(this.leftPage, mouseX, mouseY, mouseButton);
        this.clickPage(this.rightPage, mouseX, mouseY, mouseButton);
    }

    @Override
    public void func_146284_a(GuiButton button) throws IOException {
        if (this.customButtons.containsKey(button)) {
            this.customButtons.get(button).run();
            return;
        }
        if (this.leftPage != null && this.leftPage.interceptButton(button) || this.rightPage != null && this.rightPage.interceptButton(button)) {
            return;
        }
        super.func_146284_a(button);
    }

    void drawPage(BookPage page, int mouseX, int mouseY, float pticks) {
        if (page == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)page.left, (float)page.top, (float)0.0f);
        page.render(mouseX - page.left, mouseY - page.top, pticks);
        GlStateManager.func_179121_F();
    }

    void clickPage(BookPage page, int mouseX, int mouseY, int mouseButton) {
        if (page != null) {
            page.mouseClicked(mouseX - page.left, mouseY - page.top, mouseButton);
        }
    }

    @Override
    void onPageChanged() {
        this.setupPages();
        this.needsBookmarkUpdate = true;
    }

    void setupPages() {
        this.customButtons.clear();
        if (this.leftPage != null) {
            this.leftPage.onHidden(this);
        }
        if (this.rightPage != null) {
            this.rightPage.onHidden(this);
        }
        List<BookPage> pages = this.entry.getPages();
        int leftNum = this.page * 2;
        int rightNum = this.page * 2 + 1;
        this.leftPage = leftNum < pages.size() ? pages.get(leftNum) : null;
        BookPage bookPage = this.rightPage = rightNum < pages.size() ? pages.get(rightNum) : null;
        if (this.leftPage != null) {
            this.leftPage.onDisplayed(this, 15, 18);
        }
        if (this.rightPage != null) {
            this.rightPage.onDisplayed(this, 141, 18);
        }
    }

    public BookEntry getEntry() {
        return this.entry;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof GuiBookEntry && ((GuiBookEntry)obj).entry == this.entry && ((GuiBookEntry)obj).page == this.page;
    }

    @Override
    public boolean canBeOpened() {
        return !this.entry.isLocked() && !this.equals(Minecraft.func_71410_x().field_71462_r);
    }

    @Override
    protected boolean shouldAddAddBookmarkButton() {
        return !this.isBookmarkedAlready();
    }

    boolean isBookmarkedAlready() {
        String entryKey = this.entry.getResource().toString();
        PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(this.book);
        for (PersistentData.DataHolder.BookData.Bookmark bookmark : data.bookmarks) {
            if (!bookmark.entry.equals(entryKey) || bookmark.page != this.page) continue;
            return true;
        }
        return false;
    }

    @Override
    public void bookmarkThis() {
        String entryKey = this.entry.getResource().toString();
        PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(this.book);
        data.bookmarks.add(new PersistentData.DataHolder.BookData.Bookmark(entryKey, this.page));
        PersistentData.save();
        this.needsBookmarkUpdate = true;
    }

    public static void displayOrBookmark(GuiBook currGui, BookEntry entry) {
        Book book = currGui.book;
        GuiBookEntry gui = new GuiBookEntry(currGui.book, entry);
        if (GuiScreen.func_146272_n()) {
            PersistentData.DataHolder.BookData data = PersistentData.data.getBookData(book);
            if (gui.isBookmarkedAlready()) {
                String key = entry.getResource().toString();
                data.bookmarks.removeIf(bm -> bm.entry.equals(key) && bm.page == 0);
                PersistentData.save();
                currGui.needsBookmarkUpdate = true;
                return;
            }
            if (data.bookmarks.size() < 10) {
                gui.bookmarkThis();
                currGui.needsBookmarkUpdate = true;
                return;
            }
        }
        book.contents.openLexiconGui(gui, true);
    }

    @Override
    public GuiScreen getGui() {
        return this;
    }

    @Override
    public FontRenderer getFont() {
        return this.field_146289_q;
    }

    @Override
    public void renderItemStack(int x, int y, int mouseX, int mouseY, ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        RenderHelper.func_74520_c();
        this.field_146297_k.func_175599_af().func_180450_b(stack, x, y);
        this.field_146297_k.func_175599_af().func_175030_a(this.field_146289_q, stack, x, y);
        if (this.isMouseInRelativeRange(mouseX, mouseY, x, y, 16, 16)) {
            this.setTooltipStack(stack);
        }
    }

    @Override
    public void renderIngredient(int x, int y, int mouseX, int mouseY, Ingredient ingr) {
        ItemStack[] stacks = ingr.func_193365_a();
        if (stacks.length > 0) {
            this.renderItemStack(x, y, mouseX, mouseY, stacks[this.ticksInBook / 20 % stacks.length]);
        }
    }

    @Override
    public void setHoverTooltip(List<String> tooltip) {
        this.setTooltip(tooltip);
    }

    @Override
    public boolean isAreaHovered(int mouseX, int mouseY, int x, int y, int w, int h) {
        return this.isMouseInRelativeRange(mouseX, mouseY, x, y, w, h);
    }

    @Override
    public void registerButton(GuiButton button, int pageNum, Runnable onClick) {
        button.field_146128_h = button.field_146128_h + (this.bookLeft + (pageNum % 2 == 0 ? 15 : 141));
        button.field_146129_i += this.bookTop;
        this.customButtons.put(button, onClick);
        this.field_146292_n.add(button);
    }

    @Override
    public ResourceLocation getBookTexture() {
        return this.book.bookResource;
    }

    @Override
    public ResourceLocation getCraftingTexture() {
        return this.book.craftingResource;
    }

    @Override
    public int getTextColor() {
        return this.book.textColor;
    }

    @Override
    public int getHeaderColor() {
        return this.book.headerColor;
    }
}

