/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.misc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.bones.ConfigBoneType;
import yuudaari.soulus.common.config.bones.ConfigBoneTypes;
import yuudaari.soulus.common.config.creature.ConfigCreature;
import yuudaari.soulus.common.config.creature.ConfigCreatureBiome;
import yuudaari.soulus.common.config.creature.ConfigCreatureDimension;
import yuudaari.soulus.common.config.creature.ConfigCreatureDrops;
import yuudaari.soulus.common.config.creature.ConfigCreatures;
import yuudaari.soulus.common.config.essence.ConfigCreatureLoot;
import yuudaari.soulus.common.config.essence.ConfigEssence;
import yuudaari.soulus.common.config.essence.ConfigEssences;
import yuudaari.soulus.common.util.Range;

@Mod.EventBusSubscriber
@ConfigInjected(value="soulus")
public class BoneDrops {
    @ConfigInjected.Inject
    public static ConfigCreatures CONFIG_CREATURES;
    @ConfigInjected.Inject
    public static ConfigEssences CONFIG_ESSENCES;
    @ConfigInjected.Inject
    public static ConfigBoneTypes CONFIG_BONE_TYPES;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onMobDrops(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null || !(entity instanceof EntityLiving)) {
            return;
        }
        List drops = event.getDrops();
        String entityName = EntityList.func_191301_a((Entity)entity).toString();
        ConfigCreature config = BoneDrops.getCreatureConfig(entity, entityName);
        if (config != null) {
            boolean wasSummoned;
            BoneDrops.addBoneDrops(entity, entityName, drops);
            boolean bl = wasSummoned = entity.getEntityData().func_74771_c("soulus:spawn_whitelisted") == 2;
            if (!wasSummoned && ((EntityLiving)entity).func_104002_bU() && entity instanceof EntitySlime) {
                wasSummoned = true;
            }
            String spawnType = wasSummoned ? "summoned" : "spawned";
            ConfigCreatureDrops dropConfig = config.drops.get(spawnType);
            ConfigCreatureDrops dropConfigAll = config.drops.get("all");
            if (dropConfig == null && dropConfigAll == null) {
                return;
            }
            ArrayList emptyList = new ArrayList();
            boolean dc = dropConfig != null;
            boolean dca = dropConfigAll != null;
            List<Object> whitelistedDrops = dc ? dropConfig.whitelistedDrops : emptyList;
            List<Object> blacklistedDrops = dc ? dropConfig.blacklistedDrops : emptyList;
            List<Object> whitelistedDropsAll = dca ? dropConfigAll.whitelistedDrops : emptyList;
            List<Object> blacklistedDropsAll = dca ? dropConfigAll.blacklistedDrops : emptyList;
            boolean allBlacklisted = blacklistedDrops.contains("*");
            if (allBlacklisted) {
                drops.clear();
                return;
            }
            if (!whitelistedDrops.contains("*") && !whitelistedDropsAll.contains("*") || blacklistedDrops.size() + blacklistedDropsAll.size() > 0) {
                drops.removeIf(existingDrop -> {
                    ResourceLocation res = existingDrop.func_92059_d().func_77973_b().getRegistryName();
                    String modWild = res.func_110624_b() + ":*";
                    String name = res.toString();
                    if (!(whitelistedDrops.contains("*") || whitelistedDropsAll.contains("*") || whitelistedDrops.contains(modWild) || whitelistedDropsAll.contains(modWild) || whitelistedDrops.contains(name) || whitelistedDropsAll.contains(name))) {
                        return true;
                    }
                    return allBlacklisted || blacklistedDrops.contains(modWild) || blacklistedDrops.contains(name) || blacklistedDropsAll.contains(modWild) && !whitelistedDrops.contains(modWild) && !whitelistedDrops.contains(name) || blacklistedDropsAll.contains(name) && !whitelistedDrops.contains(modWild) && !whitelistedDrops.contains(name);
                });
            }
        }
    }

    private static void addBoneDrops(EntityLivingBase entity, String entityName, List<EntityItem> drops) {
        block0: for (ConfigEssence essenceConfig : BoneDrops.CONFIG_ESSENCES.essences) {
            if (essenceConfig.loot == null) continue;
            for (Map.Entry<String, ConfigCreatureLoot> lootConfig : essenceConfig.loot.entrySet()) {
                if (essenceConfig.bones == null || !lootConfig.getKey().equals(entityName)) continue;
                ItemStack stack = BoneDrops.getStack(entity.field_70170_p.field_73012_v, essenceConfig.bones.type, lootConfig.getValue());
                if (stack == null) continue block0;
                drops.add(new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack));
                continue block0;
            }
        }
    }

    private static ConfigCreature getCreatureConfig(EntityLivingBase entity) {
        return BoneDrops.getCreatureConfig(entity, EntityList.func_191301_a((Entity)entity).toString());
    }

    private static ConfigCreature getCreatureConfig(EntityLivingBase entity, String entityName) {
        DimensionType dimension = entity.field_70170_p.field_73011_w.func_186058_p();
        ConfigCreatureDimension dimensionConfig = BoneDrops.CONFIG_CREATURES.dimensionConfigs.get(dimension.func_186065_b());
        if (dimensionConfig == null && (dimensionConfig = BoneDrops.CONFIG_CREATURES.dimensionConfigs.get("*")) == null) {
            return null;
        }
        BlockPos pos = entity.func_180425_c();
        Biome biome = entity.field_70170_p.func_180494_b(pos);
        ConfigCreatureBiome biomeConfig = dimensionConfig.biomeConfigs.get(biome.getRegistryName().toString());
        if (biomeConfig == null && (biomeConfig = dimensionConfig.biomeConfigs.get(biome.getRegistryName().func_110624_b() + ":*")) == null && (biomeConfig = dimensionConfig.biomeConfigs.get("*")) == null) {
            return null;
        }
        ConfigCreature creatureConfig = biomeConfig.creatureConfigs.get(entityName);
        if (creatureConfig == null && (creatureConfig = biomeConfig.creatureConfigs.get(new ResourceLocation(entityName).func_110624_b() + ":*")) == null && (creatureConfig = biomeConfig.creatureConfigs.get("*")) == null) {
            return null;
        }
        return creatureConfig;
    }

    private static ItemStack getStack(Random rand, String boneType, ConfigCreatureLoot lootConfig) {
        if (lootConfig.chance < rand.nextDouble()) {
            return null;
        }
        ConfigBoneType boneConfig = CONFIG_BONE_TYPES.get(boneType);
        if (boneConfig == null) {
            return null;
        }
        return boneConfig.getBoneStack(new Range(lootConfig.min, lootConfig.max).getInt(rand));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onMobXp(LivingExperienceDropEvent event) {
        boolean dca;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null || !(entity instanceof EntityLiving)) {
            return;
        }
        ConfigCreature config = BoneDrops.getCreatureConfig(entity);
        if (config == null) {
            return;
        }
        boolean wasSummoned = entity.getEntityData().func_74771_c("soulus:spawn_whitelisted") == 2;
        String spawnType = wasSummoned ? "summoned" : "spawned";
        ConfigCreatureDrops dropConfig = config.drops.get(spawnType);
        ConfigCreatureDrops dropConfigAll = config.drops.get("all");
        if (dropConfig == null && dropConfigAll == null) {
            return;
        }
        boolean dc = dropConfig != null;
        boolean bl = dca = dropConfigAll != null;
        if (!(dc ? dropConfig.hasXp : !dca || dropConfigAll.hasXp)) {
            event.setCanceled(true);
        }
    }
}

