/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityList;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import yuudaari.soulus.common.block.composer.ComposerCell;
import yuudaari.soulus.common.block.composer.IFillableWithEssence;
import yuudaari.soulus.common.block.summoner.Summoner;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.essence.ConfigColor;
import yuudaari.soulus.common.config.essence.ConfigEssence;
import yuudaari.soulus.common.config.essence.ConfigEssences;
import yuudaari.soulus.common.recipe.ingredient.IngredientPotentialEssence;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.registration.Registration;
import yuudaari.soulus.common.util.Colour;
import yuudaari.soulus.common.util.EssenceType;
import yuudaari.soulus.common.util.Translation;

@ConfigInjected(value="soulus")
public class Soulbook
extends Registration.Item
implements ComposerCell.IHasComposerCellInfo,
IFillableWithEssence {
    @ConfigInjected.Inject
    public static ConfigEssences CONFIG;

    public static ItemStack getFilled(String essenceType) {
        return Soulbook.getStack(essenceType, CONFIG.getSoulbookQuantity(essenceType));
    }

    public static ItemStack getStack(String essenceType) {
        return Soulbook.getStack(essenceType, 0);
    }

    public static ItemStack getStack(String essenceType, int essenceAmount) {
        ItemStack stack = new ItemStack((Item)ItemRegistry.SOULBOOK, 1);
        EssenceType.setEssenceType(stack, essenceType);
        Soulbook.setContainedEssence(stack, essenceAmount);
        return stack;
    }

    public static boolean isFilled(ItemStack stack) {
        String essenceType = EssenceType.getEssenceType(stack);
        if (essenceType == null) {
            return false;
        }
        return Soulbook.getContainedEssence(stack) >= CONFIG.getSoulbookQuantity(essenceType);
    }

    public Soulbook() {
        super("soulbook");
        this.setMaxStackSize(1);
        this.setHasDescription();
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.registerColorHandler((stack, tintIndex) -> {
                int color;
                if (tintIndex == 2) {
                    return -1;
                }
                int defaultColour = tintIndex == 0 ? 3358552 : 6183319;
                String essenceType = EssenceType.getEssenceType(stack);
                if (essenceType == null) {
                    return defaultColour;
                }
                EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(essenceType));
                if (entry == null) {
                    return defaultColour;
                }
                ConfigEssence essenceConfig = CONFIG.get(essenceType);
                if (essenceConfig == null) {
                    return defaultColour;
                }
                ConfigColor colors = essenceConfig.colors;
                if (colors == null) {
                    EntityList.EntityEggInfo eggInfo = entry.getEgg();
                    if (eggInfo == null) {
                        return defaultColour;
                    }
                    colors = new ConfigColor(eggInfo);
                }
                int n = color = tintIndex == 0 ? colors.primary : colors.secondary;
                if (Summoner.CONFIG.soulbookEssenceRequiredToInsert <= 0.0) {
                    return color;
                }
                double percent = (double)Soulbook.getContainedEssence(stack) / Summoner.CONFIG.soulbookEssenceRequiredToInsert / (double)essenceConfig.soulbookQuantity;
                return Colour.mix(defaultColour, color, percent).get();
            });
        }
    }

    @Override
    public void onRegisterRecipes(IForgeRegistry<IRecipe> registry) {
        registry.registerAll((IForgeRegistryEntry[])new IRecipe[]{new SoulbookRecipe(this.getRegistryName(), 2), new SoulbookRecipe(this.getRegistryName(), 3)});
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        String essenceType = EssenceType.getEssenceType(stack);
        ConfigEssence config = CONFIG.get(essenceType);
        if (essenceType == null || config == null) {
            return Translation.localize(this.func_77658_a() + ".unfocused.name", new Object[0]).trim();
        }
        String alignment = config.name;
        if (alignment == null) {
            alignment = Translation.localizeEntity(essenceType);
        }
        return Translation.localize(this.func_77658_a() + ".focused.name", alignment).trim();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        String essenceType = EssenceType.getEssenceType(stack);
        int containedEssence = Soulbook.getContainedEssence(stack);
        if (essenceType == null) {
            return containedEssence == 0;
        }
        return containedEssence < CONFIG.getSoulbookQuantity(essenceType);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        String essenceType = EssenceType.getEssenceType(stack);
        if (essenceType == null) {
            return 1.0;
        }
        int containedEssence = Soulbook.getContainedEssence(stack);
        return 1.0 - (double)containedEssence / (double)CONFIG.getSoulbookQuantity(essenceType);
    }

    @Override
    public int fill(ItemStack currentStack, ItemStack fillWith, int quantity) {
        int requiredEssence;
        int insertQuantity;
        int currentEssence = Soulbook.getContainedEssence(currentStack);
        String essenceType = EssenceType.getEssenceType(currentStack);
        String fillWithEssenceType = EssenceType.getEssenceType(fillWith);
        if (fillWithEssenceType == null || essenceType != null && !essenceType.equals(fillWithEssenceType)) {
            return 0;
        }
        if (essenceType == null) {
            essenceType = fillWithEssenceType;
            EssenceType.setEssenceType(currentStack, essenceType);
        }
        if ((insertQuantity = Math.max(0, Math.min(quantity, (requiredEssence = CONFIG.getSoulbookQuantity(essenceType)) - currentEssence))) > 0) {
            Soulbook.setContainedEssence(currentStack, currentEssence + insertQuantity);
        }
        return insertQuantity;
    }

    @Override
    public float getFillPercentage(ItemStack stack) {
        String essenceType = EssenceType.getEssenceType(stack);
        if (essenceType == null) {
            return 0.0f;
        }
        int requiredEssence = CONFIG.getSoulbookQuantity(essenceType);
        if (requiredEssence < 0) {
            return 0.0f;
        }
        return (float)Soulbook.getContainedEssence(stack) / (float)requiredEssence;
    }

    public static int getContainedEssence(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_150297_b("essence_quantity", 3)) {
            return tag.func_74762_e("essence_quantity");
        }
        return 0;
    }

    public static ItemStack setContainedEssence(ItemStack stack, int count) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74768_a("essence_quantity", count);
        return stack;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)this.getItemStack());
        for (ConfigEssence essence : Soulbook.CONFIG.essences) {
            if (essence.essence.equals("NONE")) continue;
            items.add((Object)Soulbook.getStack(essence.essence, essence.soulbookQuantity));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        this.addImportantInformation(tooltip, stack);
    }

    public void addImportantInformation(List<String> tooltip, ItemStack stack) {
        int requiredEssence;
        int containedEssence = Soulbook.getContainedEssence(stack);
        String mobTarget = EssenceType.getEssenceType(stack);
        if (mobTarget != null && containedEssence < (requiredEssence = CONFIG.getSoulbookQuantity(mobTarget))) {
            tooltip.add(new Translation("tooltip.soulus:soulbook.contained_essence", new Object[0]).addArgs(containedEssence, requiredEssence).get(new Object[0]));
        }
    }

    @Override
    public void addComposerCellInfo(List<String> tooltip, ItemStack stack, int stackSize) {
        if (stackSize == 1) {
            this.addImportantInformation(tooltip, stack);
        }
    }

    public static class SoulbookRecipe
    extends ShapelessOreRecipe {
        public static NonNullList<Ingredient> getIngredients(int size) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            ingredients.addAll(Collections.nCopies(size * size - 1, IngredientPotentialEssence.getInstanceNoAsh()));
            ingredients.add(Ingredient.func_193367_a((Item)ItemRegistry.SOULBOOK));
            return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])ingredients.toArray(new Ingredient[0]));
        }

        public SoulbookRecipe(ResourceLocation name, int size) {
            super(new ResourceLocation(""), SoulbookRecipe.getIngredients(size), Soulbook.getFilled("unfocused"));
            this.setRegistryName(name + "" + size);
        }

        @ParametersAreNonnullByDefault
        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            return !this.func_77572_b(inv).func_190926_b();
        }

        @ParametersAreNonnullByDefault
        public ItemStack func_77572_b(InventoryCrafting inv) {
            int essenceCount = 0;
            ItemStack soulbook = null;
            String essenceType = null;
            int containedEssence = 0;
            int inventorySize = inv.func_70302_i_();
            for (int i = 0; i < inventorySize; ++i) {
                String itemTarget;
                ItemStack stack = inv.func_70301_a(i);
                Item stackItem = stack.func_77973_b();
                if (stack == null || stack.func_190926_b()) continue;
                if (stackItem == ItemRegistry.SOULBOOK) {
                    if (soulbook != null) {
                        return ItemStack.field_190927_a;
                    }
                    itemTarget = EssenceType.getEssenceType(stack);
                    if (itemTarget != null) {
                        if (essenceType != null && !itemTarget.equals(essenceType)) {
                            return ItemStack.field_190927_a;
                        }
                        essenceType = itemTarget;
                    }
                    containedEssence = Soulbook.getContainedEssence(stack);
                    soulbook = stack;
                    continue;
                }
                if (stackItem == ItemRegistry.ESSENCE) {
                    itemTarget = EssenceType.getEssenceType(stack);
                    if (itemTarget == null || essenceType != null && !itemTarget.equals(essenceType)) {
                        return ItemStack.field_190927_a;
                    }
                    essenceType = itemTarget;
                    ++essenceCount;
                    continue;
                }
                return ItemStack.field_190927_a;
            }
            if (soulbook != null && essenceCount > 0 && containedEssence + essenceCount <= CONFIG.getSoulbookQuantity(essenceType)) {
                ItemStack newStack = soulbook.func_77946_l();
                EssenceType.setEssenceType(newStack, essenceType);
                Soulbook.setContainedEssence(newStack, containedEssence + essenceCount);
                return newStack;
            }
            return ItemStack.field_190927_a;
        }
    }
}

