/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.config;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CaseConversion {
    private static final Pattern camelCaseRegex = Pattern.compile("[A-Z]");
    private static final Pattern snakeCaseRegex = Pattern.compile("_[A-Za-z]");

    public static String toSnakeCase(String camelCase) {
        return CaseConversion.stringReplaceAll(camelCase, camelCaseRegex, matcher -> {
            String match = matcher.group();
            return "_" + match.toLowerCase();
        });
    }

    public static String toCamelCase(String snakeCase) {
        return CaseConversion.stringReplaceAll(snakeCase, snakeCaseRegex, matcher -> {
            String match = matcher.group();
            return match.substring(1).toUpperCase();
        });
    }

    private static String stringReplaceAll(String string, Pattern pattern, ReplaceHandler handler) {
        Matcher matcher = pattern.matcher(string);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buffer, handler.handle(matcher));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private static interface ReplaceHandler {
        public String handle(Matcher var1);
    }
}

