/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block.summoner;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import yuudaari.soulus.common.CreativeTab;
import yuudaari.soulus.common.advancement.Advancements;
import yuudaari.soulus.common.block.EndersteelType;
import yuudaari.soulus.common.block.summoner.SummonerTileEntity;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlock;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlockTileEntity;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.block.ConfigSummoner;
import yuudaari.soulus.common.config.essence.ConfigEssence;
import yuudaari.soulus.common.config.essence.ConfigEssences;
import yuudaari.soulus.common.item.CrystalBlood;
import yuudaari.soulus.common.item.OrbMurky;
import yuudaari.soulus.common.item.Soulbook;
import yuudaari.soulus.common.registration.BlockRegistry;
import yuudaari.soulus.common.registration.IBlockRegistration;
import yuudaari.soulus.common.registration.ItemRegistry;
import yuudaari.soulus.common.registration.Registration;
import yuudaari.soulus.common.util.EssenceType;
import yuudaari.soulus.common.util.Material;
import yuudaari.soulus.common.util.Translation;

@ConfigInjected(value="soulus")
public class Summoner
extends UpgradeableBlock<SummonerTileEntity> {
    @ConfigInjected.Inject
    public static ConfigSummoner CONFIG;
    @ConfigInjected.Inject
    public static ConfigEssences CONFIG_ESSENCES;
    public static final IProperty<EndersteelType> VARIANT;
    public static final PropertyBool HAS_SOULBOOK;

    @Override
    public UpgradeableBlock.IUpgrade[] getUpgrades() {
        return Upgrade.values();
    }

    public Summoner() {
        super("summoner", new Material(MapColor.field_151665_m).setTransparent());
        this.setHasItem();
        this.func_149711_c(5.0f);
        this.func_149752_b(30.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149649_H();
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)HAS_SOULBOOK, (Comparable)Boolean.valueOf(false)).func_177226_a(VARIANT, (Comparable)((Object)EndersteelType.NORMAL)));
        this.setHasDescription();
    }

    @Override
    public UpgradeableBlock<SummonerTileEntity> getInstance() {
        return BlockRegistry.SUMMONER;
    }

    @Override
    public boolean canActivateWithStack(ItemStack stack, World world, BlockPos pos) {
        return super.canActivateWithStack(stack, world, pos) || stack.func_77973_b() == ItemRegistry.ESSENCE_PERFECT;
    }

    @Override
    public boolean canActivateTileEntity(SummonerTileEntity te) {
        return te == null || !te.hasMalice();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        SummonerTileEntity te = (SummonerTileEntity)world.func_175625_s(pos);
        return te == null ? 0 : te.getSignalStrength();
    }

    @Override
    public void addBlockToList(List<ItemStack> list, World world, BlockPos pos) {
        list.add(this.getStackFromEndersteelType((EndersteelType)((Object)world.func_180495_p(pos).func_177229_b(VARIANT))));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EndersteelType variant : EndersteelType.values()) {
            list.add((Object)this.getStackFromEndersteelType(variant));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerItemModel() {
        NonNullList stacks = NonNullList.func_191196_a();
        this.func_149666_a(CreativeTab.INSTANCE, (NonNullList<ItemStack>)stacks);
        for (ItemStack stack : stacks) {
            IBlockState state = this.func_176203_a(stack.func_77960_j());
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)stack.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), HAS_SOULBOOK.func_177701_a() + "=false," + VARIANT.func_177701_a() + "=" + ((EndersteelType)((Object)state.func_177229_b(VARIANT))).func_176610_l().toLowerCase()));
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)(stack.func_77960_j() + 1), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), HAS_SOULBOOK.func_177701_a() + "=true," + VARIANT.func_177701_a() + "=" + ((EndersteelType)((Object)state.func_177229_b(VARIANT))).func_176610_l().toLowerCase()));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, HAS_SOULBOOK});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HAS_SOULBOOK, (Comparable)Boolean.valueOf((meta & 1) != 0)).func_177226_a(VARIANT, (Comparable)((Object)EndersteelType.byMetadata(meta / 2)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EndersteelType)((Object)state.func_177229_b(VARIANT))).getMeta() * 2 + ((Boolean)state.func_177229_b((IProperty)HAS_SOULBOOK) != false ? 1 : 0);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state.func_177226_a((IProperty)HAS_SOULBOOK, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ItemBlock createItemBlock() {
        return new Registration.ItemMultiTexture(this, i -> "summoner_" + EndersteelType.byMetadata(i.func_77952_i()).func_176610_l()){

            public int func_77647_b(int damage) {
                return damage;
            }

            public String func_77653_i(ItemStack stack) {
                String essenceType = EssenceType.getEssenceType(stack);
                ConfigEssence config = CONFIG_ESSENCES.get(essenceType);
                if (essenceType == null || config == null) {
                    return Translation.localize(this.func_77658_a() + ".unfocused.name", new Object[0]).trim();
                }
                String alignment = config.name;
                if (alignment == null) {
                    alignment = Translation.localizeEntity(essenceType);
                }
                return Translation.localize(this.func_77658_a() + ".focused.name", alignment).trim();
            }

            @SideOnly(value=Side.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
                tooltip.add(Translation.localize("tooltip.soulus:summoner.style." + EndersteelType.byMetadata(stack.func_77952_i() / 2).func_176610_l(), new Object[0]));
            }
        }.setHasSubtypes(true);
    }

    public ItemStack getItemStack(SummonerTileEntity te, int count, int metadata) {
        ItemStack itemStack = new ItemStack((Item)this.getItemBlock(), count, metadata);
        itemStack.func_77982_d(te.func_189515_b(new NBTTagCompound()));
        return itemStack;
    }

    @Override
    public boolean hasTileEntity(IBlockState blockState) {
        return (Boolean)blockState.func_177229_b((IProperty)HAS_SOULBOOK);
    }

    @Override
    public Class<? extends UpgradeableBlockTileEntity> getTileEntityClass() {
        return SummonerTileEntity.class;
    }

    @Override
    public void onRegisterRecipes(IForgeRegistry<IRecipe> registry) {
        registry.registerAll((IForgeRegistryEntry[])Summoner.CONFIG.styleItems.entrySet().stream().map(item -> (IRecipe)new ShapelessOreRecipe(null, this.getStackFromEndersteelType((EndersteelType)((Object)((Object)item.getValue()))), new Object[]{this.getIngredientFromStacksOfOtherEndersteelTypes((EndersteelType)((Object)((Object)item.getValue()))), ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)item.getKey()))}).setRegistryName(this.getRegistryName() + "_dye_" + ((EndersteelType)((Object)((Object)item.getValue()))).func_176610_l().toLowerCase())).toArray(ShapelessOreRecipe[]::new));
        registry.registerAll((IForgeRegistryEntry[])Summoner.CONFIG.styleItems.entrySet().stream().map(item -> (IRecipe)new ShapedOreRecipe(null, this.getStackFromEndersteelType((EndersteelType)((Object)((Object)item.getValue()))), new Object[]{"BBB", "BeB", "BBB", Character.valueOf('B'), BlockRegistry.BARS_ENDERSTEEL.getStackFromEndersteelType((EndersteelType)((Object)((Object)item.getValue()))), Character.valueOf('e'), ItemRegistry.BONEMEAL_ENDER}).setRegistryName(this.getRegistryName() + "_" + ((EndersteelType)((Object)((Object)item.getValue()))).func_176610_l().toLowerCase())).toArray(ShapedOreRecipe[]::new));
    }

    private ItemStack getStackFromEndersteelType(EndersteelType type) {
        return this.getItemStack(1, this.func_176201_c(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)type))));
    }

    private Ingredient getIngredientFromStacksOfOtherEndersteelTypes(EndersteelType type) {
        return Ingredient.func_193369_a((ItemStack[])((ItemStack[])Arrays.stream(EndersteelType.values()).filter(e -> e != type).map(e -> this.getStackFromEndersteelType((EndersteelType)((Object)e))).toArray(ItemStack[]::new)));
    }

    @Override
    public boolean onActivateEmptyHand(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state = world.func_180495_p(pos);
        if (!((Boolean)state.func_177229_b((IProperty)HAS_SOULBOOK)).booleanValue()) {
            return false;
        }
        boolean returnedUpgrade = super.onActivateEmptyHand(world, pos, player);
        if (!returnedUpgrade) {
            SummonerTileEntity te = (SummonerTileEntity)world.func_175625_s(pos);
            Summoner.returnItemsToPlayer(world, Collections.singletonList(this.getSoulbook(te)), player);
            world.func_175656_a(pos, this.func_176223_P().func_177226_a(VARIANT, state.func_177229_b(VARIANT)));
            return true;
        }
        return false;
    }

    @Override
    public boolean onActivateEmptyHandSneaking(World world, BlockPos pos, EntityPlayer player) {
        super.onActivateEmptyHandSneaking(world, pos, player);
        IBlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, this.func_176223_P().func_177226_a(VARIANT, state.func_177229_b(VARIANT)));
        return true;
    }

    @Override
    public void onBlockDestroy(World world, BlockPos pos, int fortune, EntityPlayer player) {
        SummonerTileEntity ste;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof SummonerTileEntity && (ste = (SummonerTileEntity)te).hasMalice()) {
            Advancements.BREAK_SUMMONER_MALICE.trigger(player, null);
        }
        super.onBlockDestroy(world, pos, fortune, player);
    }

    @Override
    public void addOtherDropStacksToList(List<ItemStack> list, World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof SummonerTileEntity) {
            SummonerTileEntity ste = (SummonerTileEntity)te;
            list.add(this.getSoulbook(ste));
        }
    }

    @Override
    public boolean onActivateInsert(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        Item item = stack.func_77973_b();
        IBlockState state = world.func_180495_p(pos);
        EndersteelType itemStyle = Summoner.CONFIG.styleItems.get(item.getRegistryName().toString().toLowerCase());
        if (itemStyle != null && state.func_177229_b(VARIANT) != itemStyle) {
            world.func_175656_a(pos, state.func_177226_a(VARIANT, (Comparable)((Object)itemStyle)));
            stack.func_190918_g(1);
            Advancements.STYLE_SUMMONER.trigger(player, itemStyle.func_176610_l());
            return true;
        }
        if (item == ItemRegistry.SOULBOOK) {
            SummonerTileEntity te;
            String oldEssenceType;
            if ((Summoner.CONFIG.soulbookUses == null || Summoner.CONFIG.soulbookUses <= 0) && !Soulbook.isFilled(stack) || (double)Soulbook.getContainedEssence(stack) < Summoner.CONFIG.soulbookEssenceRequiredToInsert * (double)CONFIG_ESSENCES.getSoulbookQuantity(EssenceType.getEssenceType(stack))) {
                return false;
            }
            if (!((Boolean)state.func_177229_b((IProperty)HAS_SOULBOOK)).booleanValue()) {
                world.func_175656_a(pos, this.func_176223_P().func_177226_a(VARIANT, state.func_177229_b(VARIANT)).func_177226_a((IProperty)HAS_SOULBOOK, (Comparable)Boolean.valueOf(true)));
            }
            if ((oldEssenceType = (te = (SummonerTileEntity)world.func_175625_s(pos)).getEssenceType()) != null) {
                Summoner.returnItemsToPlayer(world, Collections.singletonList(this.getSoulbook(te)), player);
            }
            String newEssenceType = EssenceType.getEssenceType(stack);
            te.setEssenceType(newEssenceType);
            if (Summoner.CONFIG.soulbookUses != null && Summoner.CONFIG.soulbookUses > 0) {
                te.setSoulbookUses(Float.valueOf((float)((double)Soulbook.getContainedEssence(stack) / (double)CONFIG_ESSENCES.getSoulbookQuantity(newEssenceType) * (double)Summoner.CONFIG.soulbookUses.intValue())));
            } else {
                te.setSoulbookUses(null);
            }
            te.reset();
            stack.func_190918_g(1);
            return true;
        }
        if (!((Boolean)state.func_177229_b((IProperty)HAS_SOULBOOK)).booleanValue()) {
            return false;
        }
        if (item == ItemRegistry.ESSENCE_PERFECT) {
            SummonerTileEntity te = (SummonerTileEntity)world.func_175625_s(pos);
            return te.insertPerfectEssence(stack, player.func_70093_af());
        }
        return super.onActivateInsert(world, pos, player, stack);
    }

    public ItemStack getSoulbook(SummonerTileEntity te) {
        String essenceType = te.getEssenceType();
        if (te.hasMalice()) {
            int essenceQuantity = Summoner.CONFIG.midnightJewelSoulbookEssenceQuantity.getInt(te.func_145831_w().field_73012_v);
            return Soulbook.getStack(essenceType, essenceQuantity);
        }
        if (Summoner.CONFIG.soulbookUses != null && Summoner.CONFIG.soulbookUses > 0) {
            int essenceQuantity = (int)Math.max(0.0, (double)te.getSoulbookUses() / (double)Summoner.CONFIG.soulbookUses.intValue() * (double)CONFIG_ESSENCES.getSoulbookQuantity(essenceType));
            return Soulbook.getStack(essenceType, essenceQuantity);
        }
        return Soulbook.getFilled(essenceType);
    }

    @Override
    protected void onWailaTooltipHeader(List<String> currentTooltip, IBlockState blockState, SummonerTileEntity te, EntityPlayer player) {
        if (te == null) {
            return;
        }
        if ((Integer)te.upgrades.get(Upgrade.CRYSTAL_DARK) > 0) {
            return;
        }
        int summonPercentage = (int)Math.floor(te.getSpawnPercent() * 100.0f);
        currentTooltip.add(Translation.localize("waila.soulus:summoner.summon_percentage", summonPercentage));
        if (Summoner.CONFIG.soulbookUses != null && Summoner.CONFIG.soulbookUses > 0) {
            int summonsRemaining = (int)Math.ceil(te.getSoulbookUses() / (float)Summoner.CONFIG.soulbookUses.intValue() * 100.0f);
            currentTooltip.add(Translation.localize("waila.soulus:summoner.summons_remaining", summonsRemaining));
        }
    }

    @Override
    protected boolean shouldWailaTooltipShowAll(IBlockState blockState, SummonerTileEntity te) {
        return (Integer)te.upgrades.get(Upgrade.CRYSTAL_DARK) > 0;
    }

    @Override
    protected String getWailaTooltipUpgrade(UpgradeableBlock.IUpgrade upgrade, SummonerTileEntity te) {
        if (upgrade != Upgrade.CRYSTAL_DARK && (Integer)te.upgrades.get(Upgrade.CRYSTAL_DARK) > 0) {
            return null;
        }
        return super.getWailaTooltipUpgrade(upgrade, te);
    }

    @Override
    protected List<String> onWailaTooltipMore(IBlockState blockState, SummonerTileEntity te, EntityPlayer player) {
        String variant = ((EndersteelType)((Object)blockState.func_177229_b(VARIANT))).func_176610_l();
        return Collections.singletonList(Translation.localize("tooltip.soulus:summoner.style." + variant, new Object[0]));
    }

    @Override
    public ItemStack getWailaStack(IBlockRegistration.IDataAccessor accessor) {
        TileEntity te = accessor.getTileEntity();
        if (te == null || !(te instanceof SummonerTileEntity)) {
            return null;
        }
        return this.getItemStack((SummonerTileEntity)te, 1, te.func_145832_p());
    }

    static {
        VARIANT = PropertyEnum.func_177709_a((String)"variant", EndersteelType.class);
        HAS_SOULBOOK = PropertyBool.func_177716_a((String)"has_soulbook");
    }

    public static enum Upgrade implements UpgradeableBlock.IUpgrade
    {
        COUNT(0, "count", ItemRegistry.CRYSTAL_BLOOD.getItemStack()),
        DELAY(1, "delay", ItemRegistry.GEAR_OSCILLATING.getItemStack()),
        RANGE(2, "range", ItemRegistry.ORB_MURKY.getItemStack()),
        EFFICIENCY(3, "efficiency", ItemRegistry.GEAR_NIOBIUM.getItemStack()),
        CRYSTAL_DARK(4, "crystal_dark", ItemRegistry.CRYSTAL_DARK.getItemStack());

        private final int index;
        private final String name;
        private final ItemStack stack;
        private int maxQuantity = 16;

        private Upgrade(int index, String name, ItemStack item) {
            this.index = index;
            this.name = name;
            this.stack = item;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getMaxQuantity() {
            return this.maxQuantity;
        }

        @Override
        public void setMaxQuantity(int quantity) {
            this.maxQuantity = quantity;
        }

        @Override
        public boolean isItemStack(ItemStack stack) {
            if (stack.func_77973_b() != this.stack.func_77973_b()) {
                return false;
            }
            if (this.name == "count") {
                return CrystalBlood.isFilled(stack);
            }
            if (this.name == "range") {
                return OrbMurky.isFilled(stack);
            }
            return true;
        }

        @Override
        public boolean isItemStackForTileEntity(ItemStack stack, UpgradeableBlockTileEntity te) {
            if (te.upgrades.get(CRYSTAL_DARK) > 0) {
                return false;
            }
            if (this.name == "crystal_dark") {
                for (Upgrade upgrade : Upgrade.values()) {
                    if (te.upgrades.get(upgrade) <= 0) continue;
                    return false;
                }
            }
            return UpgradeableBlock.IUpgrade.super.isItemStackForTileEntity(stack, te);
        }

        @Override
        public ItemStack getItemStackForTileEntity(UpgradeableBlockTileEntity te, int quantity) {
            SummonerTileEntity ste = (SummonerTileEntity)te;
            if (this.name == "crystal_dark" && ste.hasMalice()) {
                return null;
            }
            return UpgradeableBlock.IUpgrade.super.getItemStackForTileEntity(te, quantity);
        }

        @Override
        public ItemStack getItemStack(int quantity) {
            ItemStack stack = new ItemStack(this.stack.func_77973_b(), quantity);
            if (this.name == "count") {
                CrystalBlood.setFilled(stack);
            } else if (this.name == "range") {
                OrbMurky.setFilled(stack);
            }
            return stack;
        }

        @Override
        public boolean isSecret() {
            return this.name == "crystal_dark";
        }
    }
}

