/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block.skewer;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import yuudaari.soulus.common.advancement.Advancements;
import yuudaari.soulus.common.block.skewer.Skewer;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlock;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlockTileEntity;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.block.ConfigSkewer;
import yuudaari.soulus.common.item.CrystalBlood;
import yuudaari.soulus.common.misc.ModDamageSource;
import yuudaari.soulus.common.network.SoulsPacketHandler;
import yuudaari.soulus.common.network.packet.client.TetherEntity;
import yuudaari.soulus.common.registration.BlockRegistry;
import yuudaari.soulus.common.util.ModPotionEffect;

@Mod.EventBusSubscriber
@ConfigInjected(value="soulus")
public class SkewerTileEntity
extends UpgradeableBlockTileEntity {
    public int crystalBloodContainedBlood = 0;
    @Nullable
    private UUID owner;
    private Map<EntityLivingBase, Long> entityHitTimes = new HashMap<EntityLivingBase, Long>();
    @ConfigInjected.Inject
    public static ConfigSkewer CONFIG;

    public Skewer getBlock() {
        return BlockRegistry.SKEWER;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    private DamageSource getDamageSource() {
        if (!this.field_145850_b.field_72995_K && (Integer)this.upgrades.get(Skewer.Upgrade.PLAYER) > 0) {
            return ModDamageSource.getSkewerPlayer((WorldServer)this.field_145850_b);
        }
        return ModDamageSource.SKEWER;
    }

    public void setOwner(EntityPlayer owner) {
        this.owner = owner.func_110124_au();
    }

    @Nullable
    public EntityPlayer getOwner() {
        return this.owner == null ? null : this.field_145850_b.func_152378_a(this.owner);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (((Boolean)state.func_177229_b((IProperty)Skewer.EXTENDED)).booleanValue()) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)Skewer.FACING);
            long time = this.field_145850_b.func_82737_E();
            this.entityHitTimes.entrySet().removeIf(entityHitTime -> time - (Long)entityHitTime.getValue() > (long)SkewerTileEntity.CONFIG.ticksBetweenDamage);
            for (EntityLivingBase entity : this.field_145850_b.func_72872_a(EntityLivingBase.class, Skewer.getSpikeHitbox(facing, this.field_174879_c))) {
                if (entity.func_190530_aW() || this.entityHitTimes.containsKey(entity)) continue;
                this.entityHitTimes.put(entity, this.field_145850_b.func_82737_E());
                float damage = SkewerTileEntity.CONFIG.baseDamage;
                int rtime = entity.field_70172_ad;
                entity.func_70097_a(this.getDamageSource(), damage += SkewerTileEntity.CONFIG.upgradeDamageEffectiveness * (float)((Integer)this.upgrades.get(Skewer.Upgrade.DAMAGE)).intValue());
                entity.field_70172_ad = rtime;
                if (entity.func_110143_aJ() <= 0.0f && this.getOwner() != null) {
                    Advancements.SKEWER_KILL.trigger(this.getOwner(), EntityList.func_191301_a((Entity)entity).toString());
                }
                if ((Integer)this.upgrades.get(Skewer.Upgrade.POISON) > 0 && (double)this.field_145850_b.field_73012_v.nextFloat() < SkewerTileEntity.CONFIG.poisonChance.get(((Integer)this.upgrades.get(Skewer.Upgrade.POISON)).intValue())) {
                    for (ModPotionEffect effect : SkewerTileEntity.CONFIG.poisonEffects) {
                        effect.apply(entity);
                    }
                }
                if ((Integer)this.upgrades.get(Skewer.Upgrade.TETHER) > 0 && (double)this.field_145850_b.field_73012_v.nextFloat() < SkewerTileEntity.CONFIG.tetherChance.get(((Integer)this.upgrades.get(Skewer.Upgrade.TETHER)).intValue())) {
                    SkewerTileEntity.tetherEntity(entity);
                    SoulsPacketHandler.INSTANCE.sendToAllAround((IMessage)new TetherEntity(entity), new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 256.0));
                } else if (entity instanceof EntityEnderman && !entity.getEntityData().func_74764_b("soulus:tethered")) {
                    ((EntityEnderman)entity).func_70820_n();
                }
                if (!(this.field_145850_b.field_73012_v.nextFloat() < SkewerTileEntity.CONFIG.chanceForBloodPerHit) || (Integer)this.upgrades.get(Skewer.Upgrade.CRYSTAL_BLOOD) <= 0) continue;
                this.crystalBloodContainedBlood = (int)((float)this.crystalBloodContainedBlood + (float)SkewerTileEntity.CONFIG.bloodPerDamage * damage);
                if (this.crystalBloodContainedBlood > CrystalBlood.CONFIG.requiredBlood) {
                    this.crystalBloodContainedBlood = CrystalBlood.CONFIG.requiredBlood;
                }
                CrystalBlood.bloodParticles(entity);
                this.blockUpdate();
            }
        }
    }

    public static void tetherEntity(EntityLivingBase entity) {
        entity.getEntityData().func_74774_a("soulus:tethered", (byte)0);
    }

    @Override
    public void onInsertUpgrade(ItemStack stack, UpgradeableBlock.IUpgrade upgrade, int newQuantity) {
        if (upgrade == Skewer.Upgrade.CRYSTAL_BLOOD) {
            this.crystalBloodContainedBlood = CrystalBlood.getContainedBlood(stack);
        } else if ((Integer)this.upgrades.get(Skewer.Upgrade.CRYSTAL_BLOOD) > 0) {
            this.insertionOrder.remove(Skewer.Upgrade.CRYSTAL_BLOOD);
            this.insertionOrder.push(Skewer.Upgrade.CRYSTAL_BLOOD);
        }
        if (upgrade == Skewer.Upgrade.POWER) {
            this.getBlock().updateExtendedState(this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public int removeUpgrade(UpgradeableBlock.IUpgrade upgrade) {
        int result = super.removeUpgrade(upgrade);
        if (upgrade == Skewer.Upgrade.POWER && result > 0) {
            this.getBlock().updateExtendedState(this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b, this.field_174879_c);
        }
        return result;
    }

    @SubscribeEvent
    public static void onEnderTeleport(EnderTeleportEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity != null && !(entity instanceof EntityPlayer) && entity.getEntityData().func_74764_b("soulus:tethered")) {
            event.setCanceled(true);
        }
    }

    @Override
    public void onReadFromNBT(NBTTagCompound compound) {
        this.crystalBloodContainedBlood = compound.func_74762_e("crystal_blood_stored_blood");
        String ownerString = compound.func_74779_i("owner");
        this.owner = ownerString == "" ? null : UUID.fromString(ownerString);
    }

    @Override
    public void onWriteToNBT(NBTTagCompound compound) {
        compound.func_74768_a("crystal_blood_stored_blood", this.crystalBloodContainedBlood);
        if (this.owner != null) {
            compound.func_74778_a("owner", this.owner.toString());
        }
    }
}

