/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block.enderlink;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import scala.Tuple2;
import yuudaari.soulus.Soulus;
import yuudaari.soulus.common.advancement.Advancements;
import yuudaari.soulus.common.block.enderlink.Enderlink;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlockTileEntity;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.block.ConfigEnderlink;
import yuudaari.soulus.common.registration.BlockRegistry;

@ConfigInjected(value="soulus")
public class EnderlinkTileEntity
extends UpgradeableBlockTileEntity
implements ITickable {
    private static final Map<UUID, Tuple2<Long, Integer>> TELEPORT_TIMES = new HashMap<UUID, Tuple2<Long, Integer>>();
    @ConfigInjected.Inject
    public static ConfigEnderlink CONFIG;
    private int range;
    public EnumDyeColor color = EnumDyeColor.LIGHT_BLUE;

    public Enderlink getBlock() {
        return BlockRegistry.ENDERLINK;
    }

    public boolean setColor(EnumDyeColor color) {
        if (this.color == color) {
            return false;
        }
        this.color = color;
        this.blockUpdate();
        return true;
    }

    public boolean teleportEntity(Entity entity) {
        EnumFacing facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)Enderlink.FACING);
        BlockPos teleportPos = this.field_174879_c.func_177972_a(facing);
        boolean isItem = entity instanceof EntityItem;
        int particleCount = isItem ? EnderlinkTileEntity.CONFIG.particleCountTeleportItem : EnderlinkTileEntity.CONFIG.particleCountTeleport;
        this.explosionParticles(entity, particleCount);
        if (isItem) {
            ItemStack item = ((EntityItem)entity).func_92059_d();
            IInventory facingInventory = EnderlinkTileEntity.getFacingInventory(this.field_145850_b, this.field_174879_c, facing);
            if (facingInventory != null) {
                EnderlinkTileEntity.insertItem(item, this.field_145850_b, this.field_174879_c, facing);
                return true;
            }
        }
        double x = (double)teleportPos.func_177958_n() + 0.5 - (double)facing.func_82601_c() / 2.0;
        double y = (double)teleportPos.func_177956_o() + 0.5 - (double)facing.func_96559_d() / 2.0;
        double z = (double)teleportPos.func_177952_p() + 0.5 - (double)facing.func_82599_e() / 2.0;
        if (facing == EnumFacing.DOWN) {
            y -= (double)entity.field_70131_O;
        } else if (facing != EnumFacing.UP) {
            x += (double)((float)facing.func_82601_c() * entity.field_70130_N / 2.0f);
            y += (double)((float)facing.func_96559_d() * entity.field_70130_N / 2.0f);
            z += (double)((float)facing.func_82599_e() * entity.field_70130_N / 2.0f);
        }
        if (!isItem) {
            Vec3d entityPos = entity.func_174791_d();
            AxisAlignedBB entityBox = entity.func_174813_aQ().func_72317_d(x - entityPos.field_72450_a, y - entityPos.field_72448_b, z - entityPos.field_72449_c).func_186664_h(0.2);
            if (this.field_145850_b.func_184143_b(entityBox)) {
                return false;
            }
        }
        this.field_145850_b.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.25f + 0.6f);
        entity.func_70634_a(x, y, z);
        this.explosionParticles(entity, particleCount);
        this.field_145850_b.func_184133_a(null, teleportPos, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.25f + 0.6f);
        if (entity instanceof EntityPlayer) {
            UUID id = entity.func_110124_au();
            Tuple2<Long, Integer> teleportationData = TELEPORT_TIMES.get(id);
            long worldTime = this.field_145850_b.func_72820_D();
            int teleports = 1;
            if (teleportationData != null && worldTime - (Long)teleportationData._1() <= 40L) {
                teleports += ((Integer)teleportationData._2()).intValue();
            }
            TELEPORT_TIMES.put(id, (Tuple2<Long, Integer>)new Tuple2((Object)worldTime, (Object)teleports));
            Advancements.TELEPORT.trigger((EntityPlayer)entity, teleports);
        }
        return true;
    }

    public boolean isWithinRange(Entity entity) {
        return this.isWithinRange(entity, entity.func_174831_c(this.field_174879_c));
    }

    public boolean isWithinRange(Entity entity, double distance) {
        return distance < (double)this.range;
    }

    public void func_73660_a() {
    }

    private void onUpdateUpgrades() {
        this.onUpdateUpgrades(false);
    }

    @Override
    public void onUpdateUpgrades(boolean readFromNBT) {
        if (this.func_145837_r()) {
            Soulus.removeConfigReloadHandler(this::onUpdateUpgrades);
            return;
        }
        Soulus.onConfigReload(this::onUpdateUpgrades);
        int rangeUpgrades = (Integer)this.upgrades.get(Enderlink.Upgrade.RANGE);
        this.range = (int)Math.pow(EnderlinkTileEntity.CONFIG.nonUpgradedRange + rangeUpgrades * EnderlinkTileEntity.CONFIG.upgradeRangeEffectiveness, 2.0);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.blockUpdate();
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Override
    public void onReadFromNBT(NBTTagCompound compound) {
        this.color = EnumDyeColor.func_176764_b((int)compound.func_74762_e("color"));
        this.onUpdateUpgrades(false);
        Enderlink.notifyEnderlink(this);
    }

    @Override
    public void onWriteToNBT(NBTTagCompound compound) {
        compound.func_74768_a("color", this.color.func_176765_a());
    }

    private void explosionParticles(Entity entity, int particleCount) {
        Random rand = this.field_145850_b.field_73012_v;
        WorldServer worldServer = this.field_145850_b.func_73046_m().func_71218_a(entity.field_71093_bK);
        for (int i = 0; i < particleCount; ++i) {
            double d0 = rand.nextGaussian() * 0.02;
            double d1 = rand.nextGaussian() * 0.02;
            double d2 = rand.nextGaussian() * 0.02;
            double w = entity.field_70130_N;
            double h = entity.field_70131_O;
            double x = entity.field_70165_t + (double)rand.nextFloat() * w * 2.0 - w - d0 * 10.0;
            double y = entity.field_70163_u + (double)rand.nextFloat() * h - d1 * 10.0;
            double z = entity.field_70161_v + (double)rand.nextFloat() * w * 2.0 - w - d2 * 10.0;
            double s = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
            worldServer.func_175739_a(EnumParticleTypes.DRAGON_BREATH, x, y, z, 1, d0, d1, d2, s, new int[0]);
        }
    }
}

