/*
 * Decompiled with CFR 0.152.
 */
package yuudaari.soulus.common.block.composer;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import yuudaari.soulus.common.block.composer.ComposerCell;
import yuudaari.soulus.common.block.composer.ComposerTileEntity;
import yuudaari.soulus.common.block.composer.HasRenderItemTileEntity;
import yuudaari.soulus.common.block.composer.IFillableWithEssence;
import yuudaari.soulus.common.block.upgradeable_block.UpgradeableBlockTileEntity;
import yuudaari.soulus.common.config.ConfigInjected;
import yuudaari.soulus.common.config.block.ConfigComposerCell;
import yuudaari.soulus.common.registration.BlockRegistry;
import yuudaari.soulus.common.registration.ItemRegistry;

@ConfigInjected(value="soulus")
public class ComposerCellTileEntity
extends HasRenderItemTileEntity {
    @ConfigInjected.Inject
    public static ConfigComposerCell CONFIG;
    public ChangeItemHandler changeItemHandler;
    public BlockPos composerLocation;
    public int changeComposerCooldown = 0;
    public byte slot = (byte)-1;
    @Nullable
    public ItemStack storedItem;
    public int storedQuantity;
    public boolean shouldCheckSignal = true;
    private boolean lastSignalIn = false;
    private double itemRotation = Math.random() * 360.0;
    private double prevItemRotation = 0.0;

    public ComposerCell getBlock() {
        return BlockRegistry.COMPOSER_CELL;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        boolean signalIn;
        --this.changeComposerCooldown;
        double diff = this.itemRotation - this.prevItemRotation;
        this.prevItemRotation = this.itemRotation;
        this.itemRotation = this.itemRotation + (double)0.05f + diff * 0.8;
        if (!this.field_145850_b.field_72995_K && this.storedQuantity < ComposerCellTileEntity.CONFIG.maxQuantity) {
            this.pullItems();
        }
        if (!this.shouldCheckSignal || this.field_145850_b.field_72995_K) {
            return;
        }
        this.shouldCheckSignal = false;
        boolean bl = signalIn = this.field_145850_b.func_175687_A(this.field_174879_c) > 0;
        if (signalIn && !this.lastSignalIn && this.storedItem != null) {
            UpgradeableBlockTileEntity.dispenseItem(this.storedItem.func_77946_l(), this.field_145850_b, this.field_174879_c, EnumFacing.DOWN);
            --this.storedQuantity;
            if (this.storedQuantity == 0) {
                this.storedItem = null;
            }
            this.onChangeItem();
            this.blockUpdate();
        }
        this.lastSignalIn = signalIn;
    }

    public void onChangeItem() {
        if (this.composerLocation == null) {
            return;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.composerLocation);
        if (te == null || !(te instanceof ComposerTileEntity) || !((ComposerTileEntity)te).isConnected()) {
            return;
        }
        if (this.changeItemHandler != null) {
            this.changeItemHandler.handle(this);
        }
    }

    public void onChangeItem(ChangeItemHandler handler) {
        this.changeItemHandler = handler;
    }

    public boolean pullItems() {
        for (EntityItem item : this.getCaptureItems()) {
            ItemStack stack;
            if (item.field_70173_aa < 2 || !this.tryInsert(stack = item.func_92059_d(), stack.func_190916_E())) continue;
            return true;
        }
        return false;
    }

    public boolean tryInsert(ItemStack stack, int requestedQuantity) {
        IFillableWithEssence fillable;
        int insertQuantity;
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        ItemStack currentStack = this.storedItem;
        if (currentStack != null && currentStack.func_190926_b()) {
            this.storedItem = null;
            currentStack = null;
        }
        if (currentStack == null || ComposerCellTileEntity.areItemStacksEqual(stack, currentStack)) {
            int canStillBeInsertedQuantity = ComposerCellTileEntity.CONFIG.maxQuantity - (currentStack == null ? 0 : this.storedQuantity);
            int insertQuantity2 = Math.min(requestedQuantity, canStillBeInsertedQuantity);
            if (currentStack == null) {
                this.storedItem = stack.func_77946_l();
                this.storedItem.func_190920_e(1);
                this.storedQuantity = insertQuantity2;
            } else {
                this.storedQuantity += insertQuantity2;
            }
            stack.func_190918_g(insertQuantity2);
            this.onChangeItem();
            this.blockUpdate();
            return true;
        }
        if (this.composerLocation == null && currentStack.func_77973_b() instanceof IFillableWithEssence && this.storedQuantity == 1 && (stack.func_77973_b() == ItemRegistry.ESSENCE || stack.func_77973_b() == ItemRegistry.ASH) && (insertQuantity = (fillable = (IFillableWithEssence)currentStack.func_77973_b()).fill(currentStack, stack, requestedQuantity)) > 0) {
            stack.func_190918_g(insertQuantity);
            this.blockUpdate();
        }
        return false;
    }

    public static boolean areItemStacksEqual(ItemStack stackA, ItemStack stackB) {
        if (stackA.func_77973_b() != stackB.func_77973_b()) {
            return false;
        }
        if (stackA.func_77952_i() != stackB.func_77952_i()) {
            return false;
        }
        if (stackA.func_77978_p() == null && stackB.func_77978_p() != null) {
            return false;
        }
        return (stackA.func_77978_p() == null || stackA.func_77978_p().equals((Object)stackB.func_77978_p())) && stackA.areCapsCompatible(stackB);
    }

    public List<EntityItem> getCaptureItems() {
        return this.field_145850_b.func_175647_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c).func_186670_a(new BlockPos(EnumFacing.UP.func_176730_m())).func_191195_a(0.0, 0.8, 0.0), EntitySelectors.field_94557_a);
    }

    @Override
    public void onWriteToNBT(NBTTagCompound compound) {
        compound.func_74757_a("has_composer", this.composerLocation != null);
        if (this.composerLocation != null) {
            compound.func_74768_a("composer_x", this.composerLocation.func_177958_n());
            compound.func_74768_a("composer_y", this.composerLocation.func_177956_o());
            compound.func_74768_a("composer_z", this.composerLocation.func_177952_p());
        }
        compound.func_74768_a("stored_quantity", this.storedQuantity);
        if (this.storedQuantity > 0) {
            compound.func_74782_a("stored_item", (NBTBase)this.storedItem.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74774_a("slot", this.slot);
    }

    @Override
    public void onReadFromNBT(NBTTagCompound compound) {
        if (compound.func_74767_n("has_composer")) {
            this.composerLocation = new BlockPos(compound.func_74762_e("composer_x"), compound.func_74762_e("composer_y"), compound.func_74762_e("composer_z"));
        }
        this.storedQuantity = compound.func_74762_e("stored_quantity");
        this.storedItem = this.storedQuantity > 0 ? new ItemStack(compound.func_74775_l("stored_item")) : null;
        this.slot = compound.func_74771_c("slot");
    }

    @Override
    public double getItemRotation() {
        return this.itemRotation;
    }

    @Override
    public double getPrevItemRotation() {
        return this.prevItemRotation;
    }

    @Override
    @Nullable
    public ItemStack getStoredItem() {
        return this.storedItem;
    }

    public static interface ChangeItemHandler {
        public Boolean handle(ComposerCellTileEntity var1);
    }
}

