/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearningbm.common.items;

import WayofTime.bloodmagic.tile.TileAltar;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xt9.deepmoblearning.common.util.ItemStackNBTHelper;
import xt9.deepmoblearningbm.ModConfig;
import xt9.deepmoblearningbm.common.blocks.BlockDigitalAgonizer;
import xt9.deepmoblearningbm.common.items.ItemBase;
import xt9.deepmoblearningbm.common.tile.TileEntityDigitalAgonizer;

public class ItemAltarLinker
extends ItemBase {
    private final int linkingRange = 25;

    public ItemAltarLinker() {
        super("altar_linker", 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        list.add("Max linking range: \u00a7r25 blocks");
        if (this.hasTargetAgonizer(stack)) {
            BlockPos pos = BlockPos.func_177969_a((long)this.getTargetAgonizerPos(stack));
            list.add("Agonizer target: \u00a7f(x: " + pos.func_177958_n() + " y: " + pos.func_177956_o() + " z: " + pos.func_177952_p() + ")\u00a7r");
            list.add("\u00a7fSneak + Right-click\u00a77 to link an altar");
            list.add("Clear target with \u00a7rRight-click");
        } else {
            list.add("No Agonizer target, link while sneaking");
            list.add("Clear target with \u00a7rRight-click");
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        if (!player.field_70170_p.field_72995_K && !player.func_70093_af()) {
            this.removeTargetAccelerator(player.func_184586_b(handIn));
            player.func_146105_b((ITextComponent)new TextComponentString("Cleared Target!"), true);
        }
        return super.func_77659_a(worldIn, player, handIn);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack agonizerLinker = player.func_184586_b(hand);
        if (!player.field_70170_p.field_72995_K && player.func_70093_af()) {
            if (this.isBlockDigitalAgonizerAtPos(world, pos)) {
                this.setTargetAgonizer(agonizerLinker, pos);
                player.func_146105_b((ITextComponent)new TextComponentString("Set Agonizer target!"), true);
            } else if (this.isValidAltar(world, pos) && this.hasTargetAgonizer(agonizerLinker)) {
                BlockPos agonizerPos = BlockPos.func_177969_a((long)this.getTargetAgonizerPos(agonizerLinker));
                if (!ModConfig.isMultipleAgonizersAllowed && this.isAltarLinked(world, pos, agonizerPos)) {
                    player.func_146105_b((ITextComponent)new TextComponentString("Altar is already linked to an Agonizer."), true);
                    return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
                }
                if (this.getBlockDistance(pos, agonizerPos) <= 25.0) {
                    if (this.isBlockDigitalAgonizerAtPos(world, agonizerPos)) {
                        TileEntityDigitalAgonizer tile = this.getAgonizerFromPos(world, agonizerPos);
                        tile.setAltarPos(pos);
                        tile.updateState(true);
                        player.func_146105_b((ITextComponent)new TextComponentString("Linked Altar to target Agonizer!"), true);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentString("Altar too far away from Agonizer!"), true);
                }
            }
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    private boolean isAltarLinked(World world, BlockPos altarPos, BlockPos currentAgonizerPos) {
        Iterable altarSurroundings = BlockPos.func_177980_a((BlockPos)new BlockPos(altarPos.func_177958_n() - 50, altarPos.func_177956_o() - 50, altarPos.func_177952_p() - 50), (BlockPos)new BlockPos(altarPos.func_177958_n() + 50, altarPos.func_177956_o() + 50, altarPos.func_177952_p() + 50));
        for (BlockPos blockPos : altarSurroundings) {
            TileEntityDigitalAgonizer tile;
            if (!this.isBlockDigitalAgonizerAtPos(world, blockPos) || blockPos.equals((Object)currentAgonizerPos) || !this.isValidAltar(world, (tile = this.getAgonizerFromPos(world, blockPos)).getAltarPos())) continue;
            return true;
        }
        return false;
    }

    private double getBlockDistance(BlockPos pos, BlockPos pos2) {
        double x = Math.pow(pos.func_177958_n() - pos2.func_177958_n(), 2.0);
        double y = Math.pow(pos.func_177956_o() - pos2.func_177956_o(), 2.0);
        double z = Math.pow(pos.func_177952_p() - pos2.func_177952_p(), 2.0);
        return Math.sqrt(x + y + z);
    }

    private boolean isBlockDigitalAgonizerAtPos(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockDigitalAgonizer;
    }

    private boolean isValidAltar(World world, BlockPos pos) {
        return world.func_175625_s(pos) instanceof TileAltar;
    }

    private TileEntityDigitalAgonizer getAgonizerFromPos(World world, BlockPos pos) {
        return (TileEntityDigitalAgonizer)world.func_175625_s(pos);
    }

    private boolean hasTargetAgonizer(ItemStack stack) {
        return ItemStackNBTHelper.hasKey((ItemStack)stack, (String)"targetAgonizer");
    }

    private void removeTargetAccelerator(ItemStack stack) {
        ItemStackNBTHelper.removeTag((ItemStack)stack, (String)"targetAgonizer");
    }

    private long getTargetAgonizerPos(ItemStack stack) {
        return ItemStackNBTHelper.getLong((ItemStack)stack, (String)"targetAgonizer", (long)0L);
    }

    private void setTargetAgonizer(ItemStack stack, BlockPos pos) {
        ItemStackNBTHelper.setLong((ItemStack)stack, (String)"targetAgonizer", (long)pos.func_177986_g());
    }
}

