/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.mmec.common.entity.ai;

import java.util.HashSet;
import me.ichun.mods.mmec.common.MightyEnderChicken;
import me.ichun.mods.mmec.common.core.SoundIndex;
import me.ichun.mods.mmec.common.entity.EntityEnderChicken;
import me.ichun.mods.mmec.common.entity.ai.EntityAICharging;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class EntityAIForcefieldRetaliation
extends EntityAIBase {
    public EntityEnderChicken chicken;
    public int attackTime;
    public BlockPos chargeStart;
    public float chargeYaw;
    public double chargeLastDist;
    public double lastX;
    public double lastZ;

    public EntityAIForcefieldRetaliation(EntityEnderChicken chicken) {
        this.chicken = chicken;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        return this.chicken.canUseAbility() && this.chicken.forcefieldAttacker != null;
    }

    public void func_75249_e() {
        this.chicken.useAbility();
        this.attackTime = -5;
        this.chargeLastDist = -1.0;
        this.chicken.setFlapping(true);
        this.chicken.func_70624_b(this.chicken.forcefieldAttacker);
    }

    public void func_75251_c() {
        this.chicken.endAbility();
        this.chicken.setFlapping(false);
        this.chargeStart = null;
        this.chargeYaw = 0.0f;
        this.attackTime = 0;
    }

    public boolean func_75253_b() {
        return this.chicken.forcefieldAttacker != null && this.chicken.func_70089_S();
    }

    public void func_75246_d() {
        ++this.attackTime;
        if (this.attackTime < 0) {
            return;
        }
        if (this.attackTime < 100) {
            this.chicken.func_70605_aq().func_75642_a(this.chicken.forcefieldAttacker.field_70165_t, this.chicken.forcefieldAttacker.field_70163_u, this.chicken.forcefieldAttacker.field_70161_v, 1.2);
            double dist = (double)this.chicken.func_70032_d((Entity)this.chicken.forcefieldAttacker) - (double)this.chicken.field_70130_N * 0.75;
            if (dist < 3.0) {
                this.chicken.peck();
            }
            if (!this.chicken.isPecking) {
                this.chicken.func_70671_ap().func_75650_a(this.chicken.forcefieldAttacker.field_70165_t, this.chicken.forcefieldAttacker.field_70163_u + (double)this.chicken.forcefieldAttacker.func_70047_e(), this.chicken.forcefieldAttacker.field_70161_v, (float)this.chicken.func_184649_cE(), (float)this.chicken.func_70646_bf());
            }
        } else {
            float scale = this.chicken.getScale();
            double speed = 0.41 + 0.044 * (double)scale;
            if (this.chicken.getIsChaos()) {
                speed *= 1.1;
            }
            double x = -MathHelper.func_76126_a((float)((this.chargeStart != null ? this.chargeYaw : this.chicken.field_70761_aq + 180.0f) * ((float)Math.PI / 180)));
            double z = MathHelper.func_76134_b((float)((this.chargeStart != null ? this.chargeYaw : this.chicken.field_70761_aq + 180.0f) * ((float)Math.PI / 180)));
            float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
            x /= (double)f1;
            z /= (double)f1;
            this.chicken.field_70159_w = x *= speed;
            this.chicken.field_70179_y = z *= speed;
            if (this.attackTime == 100) {
                this.chicken.setCharging(true);
                if (this.chicken.isHeadAvailable()) {
                    this.chicken.func_184185_a(SoundIndex.charge_start, 1.0f + 0.2f * scale, 1.0f);
                }
                this.chargeStart = new BlockPos((Entity)this.chicken);
                this.chargeYaw = this.chicken.field_70761_aq + 180.0f;
                this.lastX = this.chicken.field_70165_t;
                this.lastZ = this.chicken.field_70161_v;
            } else if (this.attackTime > 100) {
                this.chicken.field_70759_as = this.chicken.field_70761_aq = this.chargeYaw;
                this.chicken.field_70177_z = this.chicken.field_70761_aq;
                this.chicken.field_70125_A = -10.0f;
                double diffX = this.chicken.field_70165_t - this.lastX;
                double diffZ = this.chicken.field_70161_v - this.lastZ;
                double newDist = Math.sqrt(diffX * diffX + diffZ * diffZ);
                if (newDist > this.chargeLastDist) {
                    this.chargeLastDist = newDist;
                } else if (newDist / this.chargeLastDist < 0.8) {
                    if (this.chicken.getEggState() < 0 && this.chicken.func_174818_b(this.chargeStart) < 9.0) {
                        this.chicken.explode(this.chicken.field_70165_t, this.chicken.field_70163_u, this.chicken.field_70161_v, 0.75f * this.chicken.getScale(), false, true);
                    }
                    this.chicken.breakEgg();
                    this.chicken.setCharging(false);
                    this.chicken.forcefieldAttacker = null;
                    this.chicken.field_70179_y = 0.0;
                    this.chicken.field_70159_w = 0.0;
                    EntityAICharging.destroyBlocksInAABB((Entity)this.chicken, this.chicken.partBody.func_174813_aQ().func_72321_a(this.chicken.field_70159_w, this.chicken.field_70181_x, this.chicken.field_70179_y).func_186662_g((double)this.chicken.partBody.field_70130_N / 3.0));
                    if (this.chicken.isHeadAvailable()) {
                        EntityAICharging.destroyBlocksInAABB((Entity)this.chicken, this.chicken.partHead.func_174813_aQ().func_72321_a(this.chicken.field_70159_w, this.chicken.field_70181_x, this.chicken.field_70179_y).func_186662_g((double)this.chicken.partHead.field_70130_N / 3.0));
                        EntityAICharging.destroyBlocksInAABB((Entity)this.chicken, this.chicken.partBill.func_174813_aQ().func_72321_a(this.chicken.field_70159_w, this.chicken.field_70181_x, this.chicken.field_70179_y).func_186662_g((double)this.chicken.partBill.field_70130_N / 3.0));
                    }
                }
                if (Double.isNaN(newDist / this.chargeLastDist) || this.chargeStart != null && Math.sqrt(this.chicken.func_174818_b(this.chargeStart)) > (double)MightyEnderChicken.config.chargeDistanceCancel || this.attackTime > 200) {
                    this.chicken.setCharging(false);
                    this.chicken.forcefieldAttacker = null;
                }
                if (this.chicken.getCharging()) {
                    double diffY = this.chicken.field_70163_u - this.chicken.field_70167_r;
                    HashSet collidedEnts = new HashSet();
                    collidedEnts.addAll(this.chicken.field_70170_p.func_175674_a((Entity)this.chicken, this.chicken.partFootL.func_174813_aQ().func_72321_a(diffX, diffY, diffZ), this.chicken.predicateTargets));
                    collidedEnts.addAll(this.chicken.field_70170_p.func_175674_a((Entity)this.chicken, this.chicken.partFootR.func_174813_aQ().func_72321_a(diffX, diffY, diffZ), this.chicken.predicateTargets));
                    collidedEnts.addAll(this.chicken.field_70170_p.func_175674_a((Entity)this.chicken, this.chicken.partLegL.func_174813_aQ().func_72321_a(diffX, diffY, diffZ), this.chicken.predicateTargets));
                    collidedEnts.addAll(this.chicken.field_70170_p.func_175674_a((Entity)this.chicken, this.chicken.partLegR.func_174813_aQ().func_72321_a(diffX, diffY, diffZ), this.chicken.predicateTargets));
                    collidedEnts.addAll(this.chicken.field_70170_p.func_175674_a((Entity)this.chicken, this.chicken.partBody.func_174813_aQ().func_72321_a(diffX, diffY, diffZ), this.chicken.predicateTargets));
                    for (Entity ent : collidedEnts) {
                        double d = ent.field_70165_t - this.chicken.field_70165_t;
                        double d1 = ent.field_70163_u + (ent.func_174813_aQ().field_72337_e - ent.func_174813_aQ().field_72338_b) / 2.0 - this.chicken.field_70163_u;
                        double d2 = ent.field_70161_v - this.chicken.field_70161_v;
                        double dist2 = d * d + d1 * d1 + d2 * d2 + this.chicken.func_70681_au().nextGaussian() * 1.0E-5;
                        if (dist2 < (double)(this.chicken.field_70130_N * this.chicken.field_70130_N)) {
                            int amp = 7;
                            ent.field_70159_w = ent.field_70159_w + ((double)amp / dist2 * (d * d / dist2) * (d > 0.0 ? 1.0 : -1.0) + this.chicken.field_70159_w);
                            ent.field_70181_x = ent.field_70181_x + ((double)amp * 1.5 / dist2 * (d1 * d1 / dist2) * (d1 > 0.0 ? 1.0 : -1.0) + this.chicken.field_70181_x + 0.07 * (double)scale);
                            ent.field_70179_y = ent.field_70179_y + ((double)amp / dist2 * (d2 * d2 / dist2) * (d2 > 0.0 ? 1.0 : -1.0) + this.chicken.field_70179_y);
                            if (ent instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)ent).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(ent.func_145782_y(), ent.field_70159_w, ent.field_70181_x, ent.field_70179_y));
                            }
                        }
                        float damage = this.chicken.getScale();
                        if (this.chicken.getIsChaos()) {
                            damage *= 2.5f;
                            damage *= (float)MightyEnderChicken.config.chaosChickenDamageMultiplier / 100.0f;
                        }
                        ent.func_70097_a(ent.func_174813_aQ().field_72337_e > this.chicken.partBody.field_70163_u ? new EntityDamageSource("chicken_charge_body", (Entity)this.chicken).func_76348_h().func_151518_m() : new EntityDamageSource("chicken_charge", (Entity)this.chicken).func_76348_h().func_151518_m(), damage);
                    }
                }
                this.chargeLastDist = newDist;
                this.lastX = this.chicken.field_70165_t;
                this.lastZ = this.chicken.field_70161_v;
            }
        }
    }
}

