/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math.vec;

import com.creativemd.creativecore.common.utils.math.box.BoxUtils;
import com.creativemd.creativecore.common.utils.math.box.OrientatedBoundingBox;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.util.math.AxisAlignedBB;

public interface IVecOrigin {
    public double offX();

    public double offY();

    public double offZ();

    public double rotX();

    public double rotY();

    public double rotZ();

    public boolean isRotated();

    public void offX(double var1);

    public void offY(double var1);

    public void offZ(double var1);

    public void off(double var1, double var3, double var5);

    public void rotX(double var1);

    public void rotY(double var1);

    public void rotZ(double var1);

    public void rot(double var1, double var3, double var5);

    public Vector3d center();

    public Matrix3d rotation();

    public Matrix3d rotationInv();

    public Vector3d translation();

    default public void transformPointToWorld(Vector3d vec) {
        vec.sub((Tuple3d)this.center());
        this.rotation().transform((Tuple3d)vec);
        vec.add((Tuple3d)this.center());
        vec.add((Tuple3d)this.translation());
    }

    default public void transformPointToFakeWorld(Vector3d vec) {
        vec.sub((Tuple3d)this.translation());
        vec.sub((Tuple3d)this.center());
        this.rotationInv().transform((Tuple3d)vec);
        vec.add((Tuple3d)this.center());
    }

    default public AxisAlignedBB getAxisAlignedBox(AxisAlignedBB box) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        for (int i = 0; i < BoxUtils.BoxCorner.values().length; ++i) {
            Vector3d vec = BoxUtils.BoxCorner.values()[i].getVector(box);
            vec.sub((Tuple3d)this.center());
            this.rotation().transform((Tuple3d)vec);
            vec.add((Tuple3d)this.center());
            vec.add((Tuple3d)this.translation());
            minX = Math.min(minX, vec.x);
            minY = Math.min(minY, vec.y);
            minZ = Math.min(minZ, vec.z);
            maxX = Math.max(maxX, vec.x);
            maxY = Math.max(maxY, vec.y);
            maxZ = Math.max(maxZ, vec.z);
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    default public OrientatedBoundingBox getOrientatedBox(AxisAlignedBB box) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        for (int i = 0; i < BoxUtils.BoxCorner.values().length; ++i) {
            Vector3d vec = BoxUtils.BoxCorner.values()[i].getVector(box);
            vec.sub((Tuple3d)this.translation());
            vec.sub((Tuple3d)this.center());
            this.rotationInv().transform((Tuple3d)vec);
            vec.add((Tuple3d)this.center());
            minX = Math.min(minX, vec.x);
            minY = Math.min(minY, vec.y);
            minZ = Math.min(minZ, vec.z);
            maxX = Math.max(maxX, vec.x);
            maxY = Math.max(maxY, vec.y);
            maxZ = Math.max(maxZ, vec.z);
        }
        return new OrientatedBoundingBox(this, minX, minY, minZ, maxX, maxY, maxZ);
    }
}

