/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.helper;

import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import java.util.HashMap;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;

public class ShapeMap
extends HashMap<ShapedRecipeSlot, ItemHandle> {
    private boolean cut = true;

    public ShapeMap() {
        this.put(ShapedRecipeSlot.UPPER_LEFT, null);
        this.put(ShapedRecipeSlot.UPPER_CENTER, null);
        this.put(ShapedRecipeSlot.UPPER_RIGHT, null);
        this.put(ShapedRecipeSlot.LEFT, null);
        this.put(ShapedRecipeSlot.CENTER, null);
        this.put(ShapedRecipeSlot.RIGHT, null);
        this.put(ShapedRecipeSlot.LOWER_LEFT, null);
        this.put(ShapedRecipeSlot.LOWER_CENTER, null);
        this.put(ShapedRecipeSlot.LOWER_RIGHT, null);
    }

    void setCut(boolean cut) {
        this.cut = cut;
    }

    public Baked bake() {
        Baked baked = new Baked(this.cut);
        for (ShapedRecipeSlot srs : ShapedRecipeSlot.values()) {
            ItemHandle handle = (ItemHandle)this.get((Object)srs);
            if (handle != null) {
                baked.put(srs, handle.getRecipeIngredient());
                continue;
            }
            baked.put(srs, Ingredient.field_193370_a);
        }
        return baked.sanitize();
    }

    public static class Baked
    extends HashMap<ShapedRecipeSlot, Ingredient> {
        private int width = -1;
        private int height = -1;
        private NonNullList<Ingredient> rawIngredientList = null;

        private Baked(boolean doCut) {
            if (!doCut) {
                this.width = 3;
                this.height = 3;
            }
        }

        private Baked sanitize() {
            this.calculateWidth();
            this.calculateHeight();
            if (this.width > 0 && this.height > 0 && (this.width < 3 || this.height < 3)) {
                while (this.tryShiftIngredients()) {
                }
            }
            return this;
        }

        private boolean tryShiftIngredients() {
            int x;
            Ingredient i;
            int y;
            boolean needsShift = true;
            for (y = 0; y < 3; ++y) {
                i = (Ingredient)this.get((Object)ShapedRecipeSlot.getByRowColumnIndex(0, y));
                if (i == Ingredient.field_193370_a) continue;
                needsShift = false;
            }
            if (needsShift) {
                for (x = 1; x < 3; ++x) {
                    for (int y2 = 0; y2 < 3; ++y2) {
                        ShapedRecipeSlot source = ShapedRecipeSlot.getByRowColumnIndex(x, y2);
                        ShapedRecipeSlot to = ShapedRecipeSlot.getByRowColumnIndex(x - 1, y2);
                        this.put(to, this.put(source, Ingredient.field_193370_a));
                    }
                }
                return true;
            }
            needsShift = true;
            for (x = 0; x < 3; ++x) {
                i = (Ingredient)this.get((Object)ShapedRecipeSlot.getByRowColumnIndex(x, 0));
                if (i == Ingredient.field_193370_a) continue;
                needsShift = false;
            }
            if (needsShift) {
                for (y = 1; y < 3; ++y) {
                    for (int x2 = 0; x2 < 3; ++x2) {
                        ShapedRecipeSlot source = ShapedRecipeSlot.getByRowColumnIndex(x2, y);
                        ShapedRecipeSlot to = ShapedRecipeSlot.getByRowColumnIndex(x2, y - 1);
                        this.put(to, this.put(source, Ingredient.field_193370_a));
                    }
                }
                return true;
            }
            return false;
        }

        public NonNullList<Ingredient> getRawIngredientList() {
            if (this.rawIngredientList != null) {
                return this.rawIngredientList;
            }
            this.rawIngredientList = NonNullList.func_191196_a();
            for (ShapedRecipeSlot srs : ShapedRecipeSlot.values()) {
                Ingredient i = (Ingredient)this.get((Object)srs);
                this.rawIngredientList.add((Object)i);
            }
            return this.rawIngredientList;
        }

        private void calculateHeight() {
            if (this.height != -1) {
                return;
            }
            boolean up = false;
            for (int y = 0; y < 3; ++y) {
                ShapedRecipeSlot srs = ShapedRecipeSlot.getByRowColumnIndex(0, y);
                if (this.get((Object)srs) == Ingredient.field_193370_a) continue;
                up = true;
            }
            boolean mid = false;
            for (int y = 0; y < 3; ++y) {
                ShapedRecipeSlot srs = ShapedRecipeSlot.getByRowColumnIndex(1, y);
                if (this.get((Object)srs) == Ingredient.field_193370_a) continue;
                mid = true;
            }
            boolean down = false;
            for (int y = 0; y < 3; ++y) {
                ShapedRecipeSlot srs = ShapedRecipeSlot.getByRowColumnIndex(2, y);
                if (this.get((Object)srs) == Ingredient.field_193370_a) continue;
                down = true;
            }
            this.height = up ? (mid ? (down ? 3 : 2) : (down ? 3 : 1)) : (mid ? (down ? 2 : 1) : (down ? 1 : 0));
        }

        private void calculateWidth() {
            if (this.width != -1) {
                return;
            }
            boolean left = false;
            for (int y = 0; y < 3; ++y) {
                ShapedRecipeSlot srs = ShapedRecipeSlot.getByRowColumnIndex(y, 0);
                if (this.get((Object)srs) == Ingredient.field_193370_a) continue;
                left = true;
            }
            boolean mid = false;
            for (int y = 0; y < 3; ++y) {
                ShapedRecipeSlot srs = ShapedRecipeSlot.getByRowColumnIndex(y, 1);
                if (this.get((Object)srs) == Ingredient.field_193370_a) continue;
                mid = true;
            }
            boolean right = false;
            for (int y = 0; y < 3; ++y) {
                ShapedRecipeSlot srs = ShapedRecipeSlot.getByRowColumnIndex(y, 2);
                if (this.get((Object)srs) == Ingredient.field_193370_a) continue;
                right = true;
            }
            this.width = left ? (mid ? (right ? 3 : 2) : (right ? 3 : 1)) : (mid ? (right ? 2 : 1) : (right ? 1 : 0));
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

