/*
 * Decompiled with CFR 0.152.
 */
package cubex2.mods.chesttransporter.chests;

import com.google.common.collect.Lists;
import cubex2.mods.chesttransporter.chests.TransportableChestImpl;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;

public class QuarkChest
extends TransportableChestImpl {
    private static final String[] variants = new String[]{"spruce", "birch", "jungle", "acacia", "dark_oak"};

    public QuarkChest(Block chestBlock, int transporterDV, String name) {
        super(chestBlock, -1, transporterDV, name);
    }

    @Override
    public boolean copyTileEntity() {
        return true;
    }

    @Override
    public ItemStack createChestStack(ItemStack transporter) {
        ItemStack stack = super.createChestStack(transporter);
        String type = transporter.func_77978_p().func_74775_l("ChestTile").func_74779_i("type");
        stack.func_77964_b(ArrayUtils.indexOf((Object[])variants, (Object)type));
        return stack;
    }

    @Override
    public ResourceLocation getChestModel(ItemStack stack) {
        String type = stack.func_77978_p().func_74775_l("ChestTile").func_74779_i("type");
        return QuarkChest.locationFromName("quark_chest_" + type);
    }

    @Override
    public Collection<ResourceLocation> getChestModels() {
        ArrayList models = Lists.newArrayList();
        for (String variant : variants) {
            models.add(QuarkChest.locationFromName("quark_chest_" + variant));
        }
        return models;
    }
}

