/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet.tileentity;

import cofh.api.energy.IEnergyTransport;
import com.brandon3055.brandonscore.lib.EnergyHelper;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.network.wrappers.SyncableEnum;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.client.render.effect.CrystalFXIO;
import com.brandon3055.draconicevolution.client.render.effect.CrystalGLFXBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileCrystalDirectIO
extends TileCrystalBase
implements IEnergyTransport {
    public final SyncableEnum<EnumFacing> facing = new SyncableEnum((Enum)EnumFacing.DOWN, true, false);
    public final SyncableEnum<IEnergyTransport.InterfaceType> transportState = new SyncableEnum((Enum)IEnergyTransport.InterfaceType.BALANCE, true, false);

    public TileCrystalDirectIO() {
        this.registerSyncableObject((SyncableObject)this.facing, true);
        this.registerSyncableObject((SyncableObject)this.transportState, true, true);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a((EnumFacing)this.facing.value));
        if (this.transportState.value == IEnergyTransport.InterfaceType.SEND && tile != null) {
            this.energyStorage.extractEnergy(EnergyHelper.insertEnergy((TileEntity)tile, (int)this.energyStorage.extractEnergy(this.energyStorage.getMaxExtract(), true), (EnumFacing)((EnumFacing)this.facing.value).func_176734_d(), (boolean)false), false);
        }
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return from != null && this.transportState.value != IEnergyTransport.InterfaceType.SEND && from.equals((Object)this.facing.value) ? this.energyStorage.receiveEnergy(maxReceive, simulate) : 0;
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return from != null && from.equals((Object)this.facing.value) ? this.energyStorage.extractEnergy(maxExtract, simulate) : 0;
    }

    public IEnergyTransport.InterfaceType getTransportState(EnumFacing from) {
        return (IEnergyTransport.InterfaceType)this.transportState.value;
    }

    public boolean setTransportState(IEnergyTransport.InterfaceType state, EnumFacing from) {
        this.transportState.value = state;
        return true;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return from != null && from.equals((Object)this.facing.value);
    }

    @Override
    public boolean onBlockActivated(IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            this.transportState.value = this.transportState.value == IEnergyTransport.InterfaceType.SEND ? IEnergyTransport.InterfaceType.BALANCE : (this.transportState.value == IEnergyTransport.InterfaceType.BALANCE ? IEnergyTransport.InterfaceType.RECEIVE : IEnergyTransport.InterfaceType.SEND);
            return true;
        }
        return super.onBlockActivated(state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    @Override
    public EnergyCrystal.CrystalType getType() {
        return EnergyCrystal.CrystalType.CRYSTAL_IO;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CrystalGLFXBase createStaticFX() {
        return new CrystalFXIO(this.field_145850_b, this);
    }

    @Override
    public Vec3D getBeamLinkPos(BlockPos linkTo) {
        return Vec3D.getCenter((BlockPos)this.field_174879_c);
    }

    @Override
    public boolean renderBeamTermination() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDisplayData(List<String> displayList) {
        super.addDisplayData(displayList);
        IEnergyTransport.InterfaceType state = (IEnergyTransport.InterfaceType)this.transportState.value;
        TextFormatting colour = state == IEnergyTransport.InterfaceType.SEND ? TextFormatting.GOLD : (state == IEnergyTransport.InterfaceType.RECEIVE ? TextFormatting.DARK_AQUA : TextFormatting.DARK_PURPLE);
        displayList.add(I18n.func_135052_a((String)("eNet.de.IOMode" + this.transportState.value + ".info"), (Object[])new Object[]{colour}));
    }

    @Override
    public void onTilePlaced(World world, BlockPos pos, EnumFacing placedAgainst, float hitX, float hitY, float hitZ, EntityPlayer placer, ItemStack stack) {
        super.onTilePlaced(world, pos, placedAgainst, hitX, hitY, hitZ, placer, stack);
        this.facing.value = placedAgainst.func_176734_d();
    }
}

