/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.itemconfig;

import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemConfigFieldRegistry {
    protected Map<Integer, IItemConfigField> fieldRegistry = new HashMap<Integer, IItemConfigField>();
    protected Map<String, Integer> nameToIndexMap = new HashMap<String, Integer>();
    private int index = 0;

    public ItemConfigFieldRegistry register(ItemStack stack, IItemConfigField field) {
        this.fieldRegistry.put(this.index, field);
        this.nameToIndexMap.put(field.getName(), this.index);
        NBTTagCompound fieldStorage = ToolConfigHelper.getFieldStorage(stack);
        if (!fieldStorage.func_74764_b(field.getName())) {
            field.writeToNBT(fieldStorage);
        } else {
            field.readFromNBT(fieldStorage);
        }
        ++this.index;
        return this;
    }

    public IItemConfigField getField(int index) {
        return this.fieldRegistry.get(index);
    }

    public IItemConfigField getField(String name) {
        for (IItemConfigField field : this.fieldRegistry.values()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public String getNameFromIndex(int index) {
        IItemConfigField field = this.getField(index);
        return field == null ? "" : field.getName();
    }

    public int getIndexFromName(String name) {
        Integer index = this.nameToIndexMap.get(name);
        return index == null ? -1 : index;
    }

    public Collection<IItemConfigField> getFields() {
        return this.fieldRegistry.values();
    }

    public void clear() {
        this.index = 0;
        this.fieldRegistry.clear();
        this.nameToIndexMap.clear();
    }

    public int size() {
        return this.fieldRegistry.size();
    }
}

