/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.achievements;

import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class Achievements {
    private static AchievementPage achievementsPage;
    private static HashMap<String, Achievement> achievementsList;
    private static HashMap<String, AchievementCondition> achievementItems;

    public static void addAchievement(String name, Achievement achievement, ItemStack stack, String triggerCondition) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        achievementsList.put(name, achievement.func_75971_g());
        achievementItems.put(stack.func_77977_a(), new AchievementCondition(name, triggerCondition));
    }

    public static void addAchievement(String name, Achievement achievement, String triggerCondition) {
        Achievements.addAchievement(name, achievement, achievement.field_75990_d, triggerCondition);
    }

    public static void addAchievement(String name, Achievement achievement) {
        Achievements.addAchievement(name, achievement, achievement.field_75990_d, "null");
    }

    public static Achievement getAchievement(String name) {
        return achievementsList.get(name);
    }

    public static void triggerAchievement(EntityPlayer player, String name) {
        Achievement ach = Achievements.getAchievement(name);
        if (ach != null) {
            player.func_71029_a((StatBase)ach);
        }
    }

    public static void addModAchievements() {
        int x = 5;
    }

    public static void registerAchievementPane() {
        Achievement[] achievements = new Achievement[achievementsList.size()];
        achievements = achievementsList.values().toArray(achievements);
        achievementsPage = new AchievementPage(I18n.func_74838_a((String)"draconicevolution.achievementPage.name"), achievements);
        AchievementPage.registerAchievementPage((AchievementPage)achievementsPage);
    }

    @SubscribeEvent
    public void entityPickupEvent(EntityItemPickupEvent event) {
        ItemStack stack = event.getItem().func_92059_d().func_77946_l();
        stack.field_77994_a = 1;
        if (achievementItems.containsKey(stack.func_77977_a()) && achievementItems.get(stack.func_77977_a()).isCorrectCondition("pickup")) {
            Achievements.triggerAchievement(event.getEntityPlayer(), achievementItems.get(stack.func_77977_a()).getName());
        }
    }

    @SubscribeEvent
    public void craftEvent(PlayerEvent.ItemCraftedEvent event) {
        ItemStack stack = event.crafting.func_77946_l();
        stack.field_77994_a = 1;
        if (achievementItems.containsKey(stack.func_77977_a()) && achievementItems.get(stack.func_77977_a()).isCorrectCondition("craft")) {
            Achievements.triggerAchievement(event.player, achievementItems.get(stack.func_77977_a()).getName());
        }
    }

    @SubscribeEvent
    public void smeltEvent(PlayerEvent.ItemSmeltedEvent event) {
        ItemStack stack = event.smelting.func_77946_l();
        stack.field_77994_a = 1;
        if (achievementItems.containsKey(stack.func_77977_a()) && achievementItems.get(stack.func_77977_a()).isCorrectCondition("smelt")) {
            Achievements.triggerAchievement(event.player, achievementItems.get(stack.func_77977_a()).getName());
        }
    }

    static {
        achievementsList = new HashMap();
        achievementItems = new HashMap();
    }

    private static class AchievementCondition {
        private final String name;
        public final String condition;

        public AchievementCondition(String name, String condition) {
            this.name = name;
            this.condition = condition;
        }

        public boolean isCorrectCondition(String s) {
            return s.equals(this.condition);
        }

        public String getName() {
            return this.name;
        }
    }
}

