/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.proxy;

import com.minemaarten.signals.client.ClientEventHandler;
import com.minemaarten.signals.client.glasses.GlassesHUD;
import com.minemaarten.signals.client.gui.GuiCartHopper;
import com.minemaarten.signals.client.gui.GuiItemHandlerDestination;
import com.minemaarten.signals.client.gui.GuiMinecart;
import com.minemaarten.signals.client.gui.GuiNetworkController;
import com.minemaarten.signals.client.gui.GuiSelectDestinationProvider;
import com.minemaarten.signals.client.gui.GuiStationMarker;
import com.minemaarten.signals.client.render.tileentity.SignalStatusRenderer;
import com.minemaarten.signals.init.ModBlocks;
import com.minemaarten.signals.init.ModItems;
import com.minemaarten.signals.proxy.CommonProxy;
import com.minemaarten.signals.tileentity.TileEntityCartHopper;
import com.minemaarten.signals.tileentity.TileEntitySignalBase;
import com.minemaarten.signals.tileentity.TileEntityStationMarker;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)GlassesHUD.getInstance());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySignalBase.class, (TileEntitySpecialRenderer)new SignalStatusRenderer());
    }

    @Override
    public void init() {
        for (Block block : new Block[]{ModBlocks.blockSignal, ModBlocks.pathSignal, ModBlocks.stationMarker, ModBlocks.limiterRail, ModBlocks.cartHopper, ModBlocks.railLink}) {
            Item item = Item.func_150898_a((Block)block);
            this.registerItemModels(item);
        }
        this.registerItemModels(ModItems.railNetworkController);
        this.registerItemModels(ModItems.cartEngine);
        this.registerItemModels(ModItems.railConfigurator);
    }

    private void registerItemModels(Item item) {
        ArrayList stacks = new ArrayList();
        item.func_150895_a(item, null, stacks);
        for (ItemStack stack : stacks) {
            ResourceLocation resLoc = new ResourceLocation("Signals", stack.func_77977_a().substring(5));
            ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{resLoc});
            Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178086_a(item, stack.func_77952_i(), new ModelResourceLocation(resLoc, "inventory"));
        }
    }

    @Override
    public EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public void addScheduledTask(Runnable runnable, boolean serverSide) {
        if (serverSide) {
            super.addScheduledTask(runnable, serverSide);
        } else {
            Minecraft.func_71410_x().func_152344_a(runnable);
        }
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = y >= 0 ? world.func_175625_s(new BlockPos(x, y, z)) : null;
        Entity entity = y == -1 ? world.func_73045_a(x) : null;
        switch (CommonProxy.EnumGuiId.values()[ID]) {
            case STATION_MARKER: {
                return new GuiStationMarker((TileEntityStationMarker)te);
            }
            case MINECART_DESTINATION: {
                return new GuiMinecart(player.field_71071_by, (EntityMinecart)entity, z == 1);
            }
            case NETWORK_CONTROLLER: {
                return new GuiNetworkController();
            }
            case SELECT_DESTINATION_PROVIDER: {
                return new GuiSelectDestinationProvider(te);
            }
            case ITEM_HANDLER_DESTINATION: {
                return new GuiItemHandlerDestination(te);
            }
            case CART_HOPPER: {
                return new GuiCartHopper((TileEntityCartHopper)te);
            }
        }
        throw new IllegalStateException("No Gui for gui id: " + ID);
    }

    @Override
    public boolean isSneakingInGui() {
        return GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74311_E);
    }
}

