/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.signals.client.gui;

import com.minemaarten.signals.capabilities.CapabilityMinecartDestination;
import com.minemaarten.signals.client.gui.GuiContainerBase;
import com.minemaarten.signals.client.gui.widget.IGuiWidget;
import com.minemaarten.signals.client.gui.widget.WidgetComboBox;
import com.minemaarten.signals.inventory.ContainerMinecart;
import com.minemaarten.signals.network.NetworkHandler;
import com.minemaarten.signals.network.PacketUpdateTextfieldEntity;
import com.minemaarten.signals.rail.RailCacheManager;
import java.awt.Point;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.tileentity.TileEntity;

public class GuiMinecart
extends GuiContainerBase<TileEntity> {
    private WidgetComboBox[] stationNameFields;
    private final CapabilityMinecartDestination cap;
    private final EntityMinecart cart;
    private final boolean isMotorized;

    public GuiMinecart(InventoryPlayer playerInventory, EntityMinecart cart, boolean isMotorized) {
        super(new ContainerMinecart(playerInventory, cart, isMotorized), null, null);
        this.cart = cart;
        this.cap = (CapabilityMinecartDestination)cart.getCapability(CapabilityMinecartDestination.INSTANCE, null);
        this.field_147000_g = 200;
        this.field_146999_f = isMotorized ? 295 : 120;
        this.isMotorized = isMotorized;
    }

    @Override
    public void func_73866_w_() {
        int i;
        super.func_73866_w_();
        WidgetComboBox[] oldFields = this.stationNameFields;
        this.stationNameFields = new WidgetComboBox[this.cap.getTotalDestinations() + 1];
        for (i = 0; i < this.stationNameFields.length; ++i) {
            this.stationNameFields[i] = new WidgetComboBox(this.field_146289_q, this.field_147003_i + 10, this.field_146295_m / 2 - 5 - this.stationNameFields.length * 7 + i * 14, 100, this.field_146289_q.field_78288_b);
            this.stationNameFields[i].setElements(RailCacheManager.getAllStationNames());
            this.addWidget(this.stationNameFields[i]);
        }
        if (oldFields != null) {
            for (i = 0; i < oldFields.length && i < this.stationNameFields.length; ++i) {
                if (oldFields[i].func_146206_l()) {
                    this.stationNameFields[i].func_146180_a(oldFields[i].func_146179_b());
                }
                this.stationNameFields[i].func_146195_b(oldFields[i].func_146206_l());
            }
        }
    }

    @Override
    protected boolean shouldDrawBackground() {
        return false;
    }

    @Override
    protected Point getInvTextOffset() {
        return null;
    }

    @Override
    protected void func_146976_a(float partialTicks, int i, int j) {
        this.drawBackLayer();
        this.drawDarkGreyText(this.field_147003_i, this.field_147009_r, "signals.gui.cart.schedule", new Object[0]);
        String dest = this.cap.getCurrentDestination();
        if (dest.equals("")) {
            this.drawDarkGreyTextCentered(this.field_147003_i + 60, this.field_147009_r + this.field_147000_g - 18, "signals.gui.cart.no_destination", new Object[0]);
        } else {
            this.drawDarkGreyTextCentered(this.field_147003_i + 60, this.field_147009_r + this.field_147000_g - 18, "signals.gui.cart.destination", dest);
        }
        if (this.isMotorized) {
            this.func_73728_b(this.field_147003_i + 120, this.field_147009_r - 1, this.field_147009_r + this.field_147000_g, -14540254);
            this.drawDarkGreyText(this.field_147003_i + 120, this.field_147009_r, "signals.gui.cart.engine_fuel", new Object[0]);
            int barSize = 87;
            this.func_73730_a(this.field_147003_i + 164, this.field_147003_i + 164 + barSize, this.field_147009_r + 67, -14540254);
            int fuelSize = this.cap.getScaledFuel(barSize + 1);
            if (fuelSize > 0) {
                this.func_73730_a(this.field_147003_i + 164, this.field_147003_i + 164 + fuelSize - 1, this.field_147009_r + 67, -65536);
            }
        }
        if (this.cap.getTotalDestinations() > 0) {
            this.drawDestinationRect(this.cap.getDestinationIndex(), -16755456);
            for (int invalidDest : this.cap.getInvalidDestinationIndeces()) {
                this.drawDestinationRect(invalidDest, -1426128896);
            }
        }
        super.func_146976_a(partialTicks, i, j);
    }

    private void drawDestinationRect(int destinationIndex, int color) {
        int indicatorX = this.field_147003_i + 7;
        int indicatorY = this.field_146295_m / 2 - this.stationNameFields.length * 7 + destinationIndex * 14 - 8;
        GuiMinecart.func_73734_a((int)indicatorX, (int)indicatorY, (int)(indicatorX + 106), (int)(indicatorY + this.field_146289_q.field_78288_b + 6), (int)color);
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        for (int i = 0; i < this.stationNameFields.length; ++i) {
            if (this.stationNameFields[i].func_146206_l()) continue;
            this.stationNameFields[i].func_146180_a(i < this.cap.getTotalDestinations() ? this.cap.getDestination(i) : "");
        }
        if (this.cap.getTotalDestinations() != this.stationNameFields.length - 1) {
            this.scheduleRefresh();
        }
    }

    @Override
    public void onKeyTyped(IGuiWidget widget) {
        super.onKeyTyped(widget);
        this.cap.setText(0, this.getDestinationString());
        NetworkHandler.sendToServer(new PacketUpdateTextfieldEntity(this.cart, 0));
    }

    private String getDestinationString() {
        StringBuilder sb = new StringBuilder();
        for (WidgetComboBox widget : this.stationNameFields) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(widget.func_146179_b());
        }
        return sb.toString();
    }
}

