/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.retro;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.Level;

@Mod(modid="simpleretrogen", name="Simple Retrogen", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.9,1.11)")
@ParametersAreNonnullByDefault
public class WorldRetrogen {
    private List<Marker> markers = Lists.newArrayList();
    private Map<String, TargetWorldWrapper> delegates;
    private Map<World, ListMultimap<ChunkPos, String>> pendingWork;
    private Map<World, ListMultimap<ChunkPos, String>> completedWork;
    private ConcurrentMap<World, Semaphore> completedWorkLocks;
    private int maxPerTick;
    private Map<String, String> retros = Maps.newHashMap();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        Configuration cfg = new Configuration(evt.getSuggestedConfigurationFile(), null, true);
        cfg.load();
        Property property = cfg.get("general", "maxPerTick", 100);
        property.setComment("Maximum number of retrogens to run in a single tick");
        this.maxPerTick = property.getInt(100);
        Property amProperty = cfg.get("general", "markerList", new String[0]);
        amProperty.setComment("Active markers");
        ArrayList activeMarkerList = Lists.newArrayList((Object[])amProperty.getStringList());
        Set categories = cfg.getCategoryNames();
        if (categories.size() == 1) {
            property = cfg.get("general", "worldGens", new String[0]);
            Object[] retros = property.getStringList();
            property = cfg.get("general", "marker", "CPWRGMARK");
            Marker m = new Marker(property.getString(), Sets.newHashSet((Object[])retros));
            this.markers.add(m);
        } else {
            for (String marker : activeMarkerList) {
                if (categories.contains(marker)) {
                    Property property1 = cfg.get(marker, "worldGens", new String[0]);
                    property1.setComment("World Generator classes for marker");
                    this.markers.add(new Marker(marker, Sets.newHashSet((Object[])property1.getStringList())));
                    cfg.getCategory(marker).setComment("Marker definition\nYou can create as many of these as you wish\nActivate by adding to active list");
                    continue;
                }
                evt.getModLog().log(Level.INFO, "Ignoring missing marker definition for active marker %s", new Object[]{marker});
            }
        }
        cfg.getCategory("general").remove((Object)"worldGens");
        cfg.getCategory("general").remove((Object)"marker");
        for (Marker m : this.markers) {
            for (String clz : m.classes) {
                if (this.retros.put(clz, m.marker) == null) continue;
                evt.getModLog().log(Level.ERROR, "Configuration error, duplicate class for multiple markers found : %s", new Object[]{clz});
            }
            if (categories.contains(m.marker)) continue;
            Property p = cfg.get(m.marker, "worldGens", new String[0]);
            p.setComment("World Generator classes for marker");
            p.set(m.classes.toArray(new String[0]));
            cfg.getCategory(m.marker).setComment("Marker definition\nYou can create as many of these as you wish\nActivate by adding to active list");
            if (activeMarkerList.contains(m.marker)) continue;
            activeMarkerList.add(m.marker);
            amProperty.set(activeMarkerList.toArray(new String[0]));
        }
        if (cfg.hasChanged()) {
            cfg.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new LastTick());
        this.delegates = Maps.newHashMap();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new CommandBase(){

            @Nonnull
            public String func_71517_b() {
                return "listretrogenclasstargets";
            }

            @Nonnull
            public String func_71518_a(ICommandSender sender) {
                return "List retrogens";
            }

            public int func_82362_a() {
                return 0;
            }

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                Set worldGens = (Set)ObfuscationReflectionHelper.getPrivateValue(GameRegistry.class, null, (String[])new String[]{"worldGenerators"});
                ArrayList targets = Lists.newArrayList();
                for (IWorldGenerator worldGen : worldGens) {
                    if (worldGen instanceof TargetWorldWrapper) continue;
                    targets.add(worldGen.getClass().getName());
                }
                if (targets.isEmpty()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("There are no retrogen target classes"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(CommandBase.func_96333_a((Collection)targets)));
                }
            }
        });
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent evt) {
        this.pendingWork = new MapMaker().weakKeys().makeMap();
        this.completedWork = new MapMaker().weakKeys().makeMap();
        this.completedWorkLocks = new MapMaker().weakKeys().makeMap();
        Set worldGens = (Set)ObfuscationReflectionHelper.getPrivateValue(GameRegistry.class, null, (String[])new String[]{"worldGenerators"});
        Map worldGenIdx = (Map)ObfuscationReflectionHelper.getPrivateValue(GameRegistry.class, null, (String[])new String[]{"worldGeneratorIndex"});
        for (String retro : ImmutableSet.copyOf(this.retros.keySet())) {
            if (this.delegates.containsKey(retro)) continue;
            FMLLog.info((String)"Substituting worldgenerator %s with delegate", (Object[])new Object[]{retro});
            Iterator iterator = worldGens.iterator();
            while (iterator.hasNext()) {
                IWorldGenerator wg = (IWorldGenerator)iterator.next();
                if (!wg.getClass().getName().equals(retro)) continue;
                iterator.remove();
                TargetWorldWrapper tww = new TargetWorldWrapper();
                tww.delegate = wg;
                tww.tag = retro;
                worldGens.add(tww);
                Integer idx = (Integer)worldGenIdx.remove(wg);
                worldGenIdx.put(tww, idx);
                FMLLog.info((String)"Successfully substituted %s with delegate", (Object[])new Object[]{retro});
                this.delegates.put(retro, tww);
                break;
            }
            if (this.delegates.containsKey(retro)) continue;
            FMLLog.warning((String)"WorldRetrogen was not able to locate world generator class %s, it will be skipped, found %s", (Object[])new Object[]{retro, worldGens});
            this.retros.remove(retro);
        }
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent evt) {
        Set worldGens = (Set)ObfuscationReflectionHelper.getPrivateValue(GameRegistry.class, null, (String[])new String[]{"worldGenerators"});
        Map worldGenIdx = (Map)ObfuscationReflectionHelper.getPrivateValue(GameRegistry.class, null, (String[])new String[]{"worldGeneratorIndex"});
        for (TargetWorldWrapper tww : this.delegates.values()) {
            worldGens.remove(tww);
            Integer idx = (Integer)worldGenIdx.remove(tww);
            worldGens.add(tww.delegate);
            worldGenIdx.put(tww.delegate, idx);
        }
        this.delegates.clear();
    }

    private Semaphore getSemaphoreFor(World w) {
        this.completedWorkLocks.putIfAbsent(w, new Semaphore(1));
        return (Semaphore)this.completedWorkLocks.get(w);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load chunkevt) {
        World w = chunkevt.getWorld();
        if (!(w instanceof WorldServer)) {
            return;
        }
        this.getSemaphoreFor(w);
        Chunk chk = chunkevt.getChunk();
        HashSet existingGens = Sets.newHashSet();
        NBTTagCompound data = chunkevt.getData();
        for (Marker m : this.markers) {
            NBTTagCompound marker = data.func_74775_l(m.marker);
            NBTTagList tagList = marker.func_150295_c("list", 8);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                existingGens.add(tagList.func_150307_f(i));
            }
            Sets.SetView difference = Sets.difference((Set)m.classes, (Set)existingGens);
            for (String retro : difference) {
                if (!this.retros.containsKey(retro)) continue;
                this.queueRetrogen(retro, w, chk.func_76632_l());
            }
        }
        for (String retro : existingGens) {
            this.completeRetrogen(chk.func_76632_l(), w, retro);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save chunkevt) {
        World w = chunkevt.getWorld();
        if (!(w instanceof WorldServer)) {
            return;
        }
        this.getSemaphoreFor(w).acquireUninterruptibly();
        try {
            if (this.completedWork.containsKey(w)) {
                ListMultimap<ChunkPos, String> doneChunks = this.completedWork.get(w);
                List retroClassList = doneChunks.get((Object)chunkevt.getChunk().func_76632_l());
                if (retroClassList.isEmpty()) {
                    return;
                }
                NBTTagCompound data = chunkevt.getData();
                for (String retroClass : retroClassList) {
                    NBTTagList lst;
                    String marker = this.retros.get(retroClass);
                    if (marker == null) {
                        FMLLog.log((Level)Level.DEBUG, (String)"Encountered retrogen class %s with no existing marker, removing from chunk. You probably removed it from the active configuration", (Object[])new Object[]{retroClass});
                        continue;
                    }
                    if (data.func_74764_b(marker)) {
                        lst = data.func_74775_l(marker).func_150295_c("list", 8);
                    } else {
                        NBTTagCompound retro = new NBTTagCompound();
                        lst = new NBTTagList();
                        retro.func_74782_a("list", (NBTBase)lst);
                        data.func_74782_a(marker, (NBTBase)retro);
                    }
                    lst.func_74742_a((NBTBase)new NBTTagString(retroClass));
                }
            }
        }
        finally {
            this.getSemaphoreFor(w).release();
        }
    }

    private void queueRetrogen(String retro, World world, ChunkPos chunkCoords) {
        if (world instanceof WorldServer) {
            ArrayListMultimap currentWork = this.pendingWork.get(world);
            if (currentWork == null) {
                currentWork = ArrayListMultimap.create();
                this.pendingWork.put(world, (ListMultimap<ChunkPos, String>)currentWork);
            }
            currentWork.put((Object)chunkCoords, (Object)retro);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeRetrogen(ChunkPos chunkCoords, World world, String retroClass) {
        ListMultimap<ChunkPos, String> pendingMap = this.pendingWork.get(world);
        if (pendingMap != null && pendingMap.containsKey((Object)chunkCoords)) {
            pendingMap.remove((Object)chunkCoords, (Object)retroClass);
        }
        this.getSemaphoreFor(world).acquireUninterruptibly();
        try {
            ArrayListMultimap completedMap = this.completedWork.get(world);
            if (completedMap == null) {
                completedMap = ArrayListMultimap.create();
                this.completedWork.put(world, (ListMultimap<ChunkPos, String>)completedMap);
            }
            completedMap.put((Object)chunkCoords, (Object)retroClass);
        }
        finally {
            this.getSemaphoreFor(world).release();
        }
    }

    private void runRetrogen(WorldServer world, ChunkPos chunkCoords, String retroClass) {
        long worldSeed = world.func_72905_C();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkCoords.field_77276_a + zSeed * (long)chunkCoords.field_77275_b ^ worldSeed;
        fmlRandom.setSeed(chunkSeed);
        ChunkProviderServer providerServer = world.func_72863_F();
        IChunkGenerator generator = (IChunkGenerator)ObfuscationReflectionHelper.getPrivateValue(ChunkProviderServer.class, (Object)providerServer, (String[])new String[]{"field_186029_c", "chunkGenerator"});
        this.delegates.get(retroClass).delegate.generate(fmlRandom, chunkCoords.field_77276_a, chunkCoords.field_77275_b, (World)world, generator, (IChunkProvider)providerServer);
        FMLLog.fine((String)"Retrogenerated chunk for %s", (Object[])new Object[]{retroClass});
        this.completeRetrogen(chunkCoords, (World)world, retroClass);
    }

    private class TargetWorldWrapper
    implements IWorldGenerator {
        private IWorldGenerator delegate;
        private String tag;

        private TargetWorldWrapper() {
        }

        public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
            FMLLog.fine((String)"Passing generation for %s through to underlying generator", (Object[])new Object[]{this.tag});
            this.delegate.generate(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
            ChunkPos chunkCoordIntPair = new ChunkPos(chunkX, chunkZ);
            WorldRetrogen.this.completeRetrogen(chunkCoordIntPair, world, this.tag);
        }
    }

    private class LastTick {
        private int counter = 0;

        private LastTick() {
        }

        @SubscribeEvent
        public void tickStart(TickEvent.WorldTickEvent tick) {
            World w = tick.world;
            if (!(w instanceof WorldServer)) {
                return;
            }
            if (tick.phase == TickEvent.Phase.START) {
                this.counter = 0;
                WorldRetrogen.this.getSemaphoreFor(w);
            } else {
                ListMultimap pending = (ListMultimap)WorldRetrogen.this.pendingWork.get(w);
                if (pending == null) {
                    return;
                }
                ImmutableList forProcessing = ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)pending.entries(), (int)(WorldRetrogen.this.maxPerTick + 1)));
                for (Map.Entry entry : forProcessing) {
                    if (this.counter++ > WorldRetrogen.this.maxPerTick) {
                        FMLLog.fine((String)"Completed %d retrogens this tick. There are %d left for world %s", (Object[])new Object[]{this.counter, pending.size(), w.func_72912_H().func_76065_j()});
                        return;
                    }
                    WorldRetrogen.this.runRetrogen((WorldServer)w, (ChunkPos)entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }

    private static class Marker {
        private final String marker;
        private final Set<String> classes;

        Marker(String marker, Set<String> classes) {
            this.marker = marker;
            this.classes = classes;
        }
    }
}

