/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.network.messages;

import edgarallen.mods.scf.blocks.craftingframe.TileEntityCraftingFrame;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageCraftItem
implements IMessage {
    private BlockPos pos;
    private int subFrame;
    private boolean fullStack;

    public MessageCraftItem() {
    }

    public MessageCraftItem(BlockPos pos, int subFrame, boolean fullStack) {
        this.pos = pos;
        this.subFrame = subFrame;
        this.fullStack = fullStack;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.subFrame);
        buf.writeBoolean(this.fullStack);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.subFrame = buf.readInt();
        this.fullStack = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<MessageCraftItem, IMessage> {
        public IMessage onMessage(MessageCraftItem message, MessageContext ctx) {
            IThreadListener thread = FMLCommonHandler.instance().getWorldThread(ctx.netHandler);
            if (thread.func_152345_ab()) {
                this.handle(message, ctx);
            } else {
                thread.func_152344_a(() -> this.handle(message, ctx));
            }
            return null;
        }

        private void handle(MessageCraftItem message, MessageContext ctx) {
            World world = ctx.getServerHandler().field_147369_b.field_70170_p;
            TileEntity te = world.func_175625_s(message.pos);
            if (te != null && te instanceof TileEntityCraftingFrame) {
                TileEntityCraftingFrame cte = (TileEntityCraftingFrame)te;
                cte.performCraft((EntityPlayer)ctx.getServerHandler().field_147369_b, message.subFrame, message.fullStack);
            }
        }
    }
}

