/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.teleportationframe.utils;

import edgarallen.mods.scf.blocks.teleportationframe.nbt.DestinationMarkerNBTReader;
import edgarallen.mods.scf.blocks.teleportationframe.nbt.TeleportationFrameNBTReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;

public class TooltipHelper {
    public static void addSingleFrameTooltip(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.single.tooltip.subheader"));
        if (!stack.func_77942_o()) {
            tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.tooltip.destination.none"));
            return;
        }
        NBTTagCompound rootCompound = TeleportationFrameNBTReader.readRootTagCompoundFromNBT(stack.func_77978_p());
        ItemStack[] destinations = TeleportationFrameNBTReader.readDestinationsFromNBT(1, rootCompound);
        for (int i = 0; i < destinations.length; ++i) {
            TooltipHelper.addDestinationToTooltip(destinations[i], tooltip);
        }
    }

    public static void addDoubleFrameTooltip(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.double.tooltip.subheader"));
        if (!stack.func_77942_o()) {
            tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.tooltip.destination.none"));
            tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.tooltip.destination.none"));
            return;
        }
        NBTTagCompound rootCompound = TeleportationFrameNBTReader.readRootTagCompoundFromNBT(stack.func_77978_p());
        ItemStack[] destinations = TeleportationFrameNBTReader.readDestinationsFromNBT(2, rootCompound);
        for (int i = 0; i < destinations.length; ++i) {
            TooltipHelper.addDestinationToTooltip(destinations[i], tooltip);
        }
    }

    public static void addTripleFrameTooltip(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.triple.tooltip.subheader"));
        if (!stack.func_77942_o()) {
            tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.tooltip.destination.none"));
            tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.tooltip.destination.none"));
            tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.tooltip.destination.none"));
            return;
        }
        NBTTagCompound rootCompound = TeleportationFrameNBTReader.readRootTagCompoundFromNBT(stack.func_77978_p());
        ItemStack[] destinations = TeleportationFrameNBTReader.readDestinationsFromNBT(3, rootCompound);
        for (int i = 0; i < destinations.length; ++i) {
            TooltipHelper.addDestinationToTooltip(destinations[i], tooltip);
        }
    }

    public static void addQuadFrameTooltip(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.quad.tooltip.subheader"));
        if (!stack.func_77942_o()) {
            tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.tooltip.destination.none"));
            tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.tooltip.destination.none"));
            tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.tooltip.destination.none"));
            tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.tooltip.destination.none"));
            return;
        }
        NBTTagCompound rootCompound = TeleportationFrameNBTReader.readRootTagCompoundFromNBT(stack.func_77978_p());
        ItemStack[] destinations = TeleportationFrameNBTReader.readDestinationsFromNBT(4, rootCompound);
        for (int i = 0; i < destinations.length; ++i) {
            TooltipHelper.addDestinationToTooltip(destinations[i], tooltip);
        }
    }

    private static void addDestinationToTooltip(ItemStack stack, List<String> tooltip) {
        if (stack != null && DestinationMarkerNBTReader.hasDestinationSet(stack)) {
            String languageKey = "item.destination_marker.tooltip.destination.coords";
            boolean showCoords = true;
            if (stack.func_82837_s()) {
                tooltip.add(I18n.func_74837_a((String)"item.super_teleportation_frame.tooltip.destination.name", (Object[])new Object[]{stack.func_82833_r()}));
                languageKey = "item.super_teleportation_frame.tooltip.destination.coords";
                showCoords = GuiScreen.func_146272_n();
            }
            if (showCoords) {
                Vec3d dest = DestinationMarkerNBTReader.getDestinationPosition(stack);
                tooltip.add(I18n.func_74837_a((String)languageKey, (Object[])new Object[]{new BigDecimal(dest.field_72450_a).setScale(4, RoundingMode.HALF_UP).doubleValue(), new BigDecimal(dest.field_72448_b).setScale(4, RoundingMode.HALF_UP).doubleValue(), new BigDecimal(dest.field_72449_c).setScale(4, RoundingMode.HALF_UP).doubleValue()}));
            }
        } else {
            tooltip.add(I18n.func_74838_a((String)"item.super_teleportation_frame.tooltip.destination.none"));
        }
    }
}

