/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.craftingframe.utils;

import edgarallen.mods.scf.blocks.craftingframe.core.SubFrame;
import edgarallen.mods.scf.blocks.craftingframe.nbt.CraftingFrameNBTReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;

public class TooltipHelper {
    public static void addSingleFrameTooltip(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        SubFrame[] subFrames;
        tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.single.tooltip.subheader"));
        if (!stack.func_77942_o()) {
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.none"));
            return;
        }
        NBTTagCompound rootCompound = CraftingFrameNBTReader.readRootTagCompoundFromNBT(stack.func_77978_p());
        for (SubFrame subFrame : subFrames = CraftingFrameNBTReader.readSubFramesFromNBT(1, rootCompound)) {
            TooltipHelper.addSubFrameToTooltip(subFrame, tooltip);
        }
        if (!GuiScreen.func_146272_n()) {
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.shift"));
        }
    }

    public static void addDoubleFrameTooltip(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        SubFrame[] subFrames;
        tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.double.tooltip.subheader"));
        if (!stack.func_77942_o()) {
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.none"));
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.none"));
            return;
        }
        NBTTagCompound rootCompound = CraftingFrameNBTReader.readRootTagCompoundFromNBT(stack.func_77978_p());
        for (SubFrame subFrame : subFrames = CraftingFrameNBTReader.readSubFramesFromNBT(2, rootCompound)) {
            TooltipHelper.addSubFrameToTooltip(subFrame, tooltip);
        }
        if (!GuiScreen.func_146272_n()) {
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.shift"));
        }
    }

    public static void addTripleFrameTooltip(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        SubFrame[] subFrames;
        tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.triple.tooltip.subheader"));
        if (!stack.func_77942_o()) {
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.none"));
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.none"));
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.none"));
            return;
        }
        NBTTagCompound rootCompound = CraftingFrameNBTReader.readRootTagCompoundFromNBT(stack.func_77978_p());
        for (SubFrame subFrame : subFrames = CraftingFrameNBTReader.readSubFramesFromNBT(3, rootCompound)) {
            TooltipHelper.addSubFrameToTooltip(subFrame, tooltip);
        }
        if (!GuiScreen.func_146272_n()) {
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.shift"));
        }
    }

    public static void addQuadFrameTooltip(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        SubFrame[] subFrames;
        tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.quad.tooltip.subheader"));
        if (!stack.func_77942_o()) {
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.none"));
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.none"));
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.none"));
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.none"));
            return;
        }
        NBTTagCompound rootCompound = CraftingFrameNBTReader.readRootTagCompoundFromNBT(stack.func_77978_p());
        for (SubFrame subFrame : subFrames = CraftingFrameNBTReader.readSubFramesFromNBT(4, rootCompound)) {
            TooltipHelper.addSubFrameToTooltip(subFrame, tooltip);
        }
        if (!GuiScreen.func_146272_n()) {
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.shift"));
        }
    }

    private static void addSubFrameToTooltip(SubFrame subFrame, List<String> tooltip) {
        List<String> list;
        if (subFrame == null) {
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.none"));
            return;
        }
        if (subFrame.getRecipeOutput() != null) {
            ItemStack recipeOutput = subFrame.getRecipeOutput();
            tooltip.add(I18n.func_74837_a((String)"item.super_crafting_frame.tooltip.recipe", (Object[])new Object[]{recipeOutput.func_82833_r(), recipeOutput.field_77994_a}));
        } else {
            list = TooltipHelper.getIngredientNames(subFrame.getRecipeItems());
            if (list.size() > 0) {
                tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.invalid"));
            } else {
                tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.none"));
            }
        }
        if (GuiScreen.func_146272_n()) {
            tooltip.add(I18n.func_74837_a((String)"item.super_crafting_frame.tooltip.mode", (Object[])new Object[]{I18n.func_74838_a((String)subFrame.getMode().getUnlocalizedName())}));
            tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.ingredient.header"));
            list = TooltipHelper.getIngredientNames(subFrame.getRecipeItems());
            if (list.size() > 0) {
                HashSet<String> unique = new HashSet<String>(list);
                tooltip.addAll(unique.stream().map(key -> I18n.func_74837_a((String)"item.super_crafting_frame.tooltip.recipe.ingredient", (Object[])new Object[]{key, Collections.frequency(list, key)})).collect(Collectors.toList()));
            } else {
                tooltip.add(I18n.func_74838_a((String)"item.super_crafting_frame.tooltip.recipe.ingredient.none"));
            }
            tooltip.add(" ");
        }
    }

    public static List<String> getIngredientNames(ItemStack[] ingredients) {
        ArrayList<String> list = new ArrayList<String>();
        if (ingredients != null) {
            for (ItemStack ingredient : ingredients) {
                if (ingredient == null) continue;
                list.add(ingredient.func_82833_r());
            }
        }
        return list;
    }
}

