/*
 * Decompiled with CFR 0.152.
 */
package edgarallen.mods.scf.blocks.craftingframe.core;

import com.google.common.collect.Maps;
import java.util.Map;

public enum PlayerInteractAction {
    NONE(0, "none"),
    CRAFT_ITEM(1, "craft_item"),
    CRAFT_STACK(2, "craft_stack"),
    OPEN_GUI(3, "open_gui"),
    INSTANT_BREAK(4, "instant_break");

    private final int index;
    private final String name;
    public static final PlayerInteractAction[] VALUES;
    public static final String[] VALID_NAMES;
    private static final Map<String, PlayerInteractAction> NAME_LOOKUP;

    private PlayerInteractAction(int index, String name) {
        this.index = index;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static PlayerInteractAction byName(String name) {
        return name == null ? null : NAME_LOOKUP.get(name.toLowerCase());
    }

    static {
        VALUES = new PlayerInteractAction[5];
        VALID_NAMES = new String[5];
        NAME_LOOKUP = Maps.newHashMap();
        PlayerInteractAction[] playerInteractActionArray = PlayerInteractAction.values();
        int n = playerInteractActionArray.length;
        for (int i = 0; i < n; ++i) {
            PlayerInteractAction a;
            PlayerInteractAction.VALUES[a.index] = a = playerInteractActionArray[i];
            NAME_LOOKUP.put(a.toString().toLowerCase(), a);
            PlayerInteractAction.VALID_NAMES[a.index] = a.toString().toLowerCase();
        }
    }
}

