/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api;

import com.feed_the_beast.ftbl.api.EnumTeamColor;
import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api.IForgePlayer;
import com.feed_the_beast.ftbl.api.ITeamMessage;
import com.feed_the_beast.ftbl.api.config.IConfigTree;
import com.feed_the_beast.ftbl.api.security.EnumTeamPrivacyLevel;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public interface IForgeTeam
extends IStringSerializable,
INBTSerializable<NBTTagCompound> {
    public static final int FLAG_FREE_TO_JOIN = 1;
    public static final int FLAG_INVALID = 2;

    public boolean isValid();

    @Nullable
    public INBTSerializable<?> getData(ResourceLocation var1);

    public IForgePlayer getOwner();

    public String getTitle();

    public String getDesc();

    public EnumTeamColor getColor();

    public EnumTeamStatus getHighestStatus(UUID var1);

    public boolean hasStatus(UUID var1, EnumTeamStatus var2);

    default public EnumTeamStatus getHighestStatus(IForgePlayer player) {
        return this.getHighestStatus(player.getId());
    }

    default public boolean hasStatus(IForgePlayer player, EnumTeamStatus status) {
        return this.hasStatus(player.getId(), status);
    }

    public void setStatus(UUID var1, EnumTeamStatus var2);

    public Collection<IForgePlayer> getPlayersWithStatus(Collection<IForgePlayer> var1, EnumTeamStatus var2);

    default public boolean canInteract(UUID playerId, EnumTeamPrivacyLevel level) {
        return this.hasStatus(playerId, level.getRequiredStatus());
    }

    public boolean addPlayer(IForgePlayer var1);

    public boolean removePlayer(IForgePlayer var1);

    public void changeOwner(IForgePlayer var1);

    public IConfigTree getSettings();

    public int getFlags();

    public void printMessage(ITeamMessage var1);

    public List<ITeamMessage> getMessages();
}

