/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.modularelements;

import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.EnumAlignment;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IMGuiListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;

public class MGuiButton
extends MGuiElementBase {
    protected static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("textures/gui/widgets.png");
    public String displayString = "";
    public List<String> toolTip = null;
    public int buttonId = -1;
    public String buttonName = "";
    public boolean disabled = false;
    protected IMGuiListener listener = null;
    public EnumAlignment alignment = EnumAlignment.CENTER;
    public boolean dropShadow = true;
    public int toolTipDelay = 10;
    public int hoverTime;
    public boolean mouseOver = false;
    public boolean trim = false;

    public MGuiButton(IModularGui modularGui) {
        super(modularGui);
        if (modularGui instanceof IMGuiListener) {
            this.listener = (IMGuiListener)((Object)modularGui);
        }
    }

    public MGuiButton(IModularGui gui, int buttonId, int xPos, int yPos, int xSize, int ySize, String buttonText) {
        super(gui, xPos, yPos, xSize, ySize);
        this.displayString = buttonText;
        this.buttonId = buttonId;
        if (this.modularGui instanceof IMGuiListener) {
            this.listener = (IMGuiListener)((Object)this.modularGui);
        }
    }

    public MGuiButton(IModularGui gui, String buttonName, int xPos, int yPos, int xSize, int ySize, String buttonText) {
        super(gui, xPos, yPos, xSize, ySize);
        this.displayString = buttonText;
        this.buttonName = buttonName;
        if (this.modularGui instanceof IMGuiListener) {
            this.listener = (IMGuiListener)((Object)this.modularGui);
        }
    }

    public MGuiButton(IModularGui gui, int xPos, int yPos, int xSize, int ySize, String buttonText) {
        super(gui, xPos, yPos, xSize, ySize);
        this.displayString = buttonText;
        if (this.modularGui instanceof IMGuiListener) {
            this.listener = (IMGuiListener)((Object)this.modularGui);
        }
    }

    public MGuiButton setListener(IMGuiListener listener) {
        this.listener = listener;
        return this;
    }

    protected int getRenderState(boolean hovered) {
        int i = 1;
        if (this.disabled) {
            i = 0;
        } else if (hovered) {
            i = 2;
        }
        return i;
    }

    @Override
    public void renderBackgroundLayer(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        String displayString = this.getDisplayString();
        FontRenderer fontrenderer = mc.field_71466_p;
        mc.func_110434_K().func_110577_a(BUTTON_TEXTURES);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean hovered = this.isMouseOver(mouseX, mouseY);
        int k = this.getRenderState(hovered);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.drawTexturedModalRect(this.xPos, this.yPos, 0, 46 + k * 20, this.xSize % 2 + this.xSize / 2, this.ySize);
        this.drawTexturedModalRect(this.xSize % 2 + this.xPos + this.xSize / 2, this.yPos, 200 - this.xSize / 2, 46 + k * 20, this.xSize / 2, this.ySize);
        if (this.ySize < 20) {
            this.drawTexturedModalRect(this.xPos, this.yPos + 3, 0, 46 + k * 20 + 20 - this.ySize + 3, this.xSize % 2 + this.xSize / 2, this.ySize - 3);
            this.drawTexturedModalRect(this.xSize % 2 + this.xPos + this.xSize / 2, this.yPos + 3, 200 - this.xSize / 2, 46 + k * 20 + 20 - this.ySize + 3, this.xSize / 2, this.ySize - 3);
        }
        if (this.trim && fontrenderer.func_78256_a(displayString) > this.xSize - 4) {
            displayString = fontrenderer.func_78269_a(displayString, this.xSize - 8) + "..";
        }
        int l = this.getTextColour(hovered, this.disabled);
        if (this.alignment == EnumAlignment.CENTER) {
            this.drawCenteredString(fontrenderer, displayString, this.xPos + this.xSize / 2, this.yPos + (this.ySize - 8) / 2, l, this.dropShadow);
        } else {
            int buffer = 1 + (this.ySize - fontrenderer.field_78288_b) / 2;
            if (this.alignment == EnumAlignment.LEFT) {
                this.drawString(fontrenderer, displayString, this.xPos + buffer, this.yPos + (this.ySize - 8) / 2, l, this.dropShadow);
            } else {
                this.drawString(fontrenderer, displayString, this.xPos + this.xSize - buffer - fontrenderer.func_78256_a(displayString), this.yPos + (this.ySize - 8) / 2, l, this.dropShadow);
            }
        }
    }

    @Override
    public void renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.mouseOver = this.isMouseOver(mouseX, mouseY);
        List<String> toolTip = this.getToolTip();
        if (this.mouseOver && this.hoverTime >= this.toolTipDelay && toolTip != null && !toolTip.isEmpty()) {
            this.drawHoveringText(toolTip, mouseX, mouseY, minecraft.field_71466_p, this.modularGui.screenWidth(), this.modularGui.screenHeight());
        }
        super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.isMouseOver(mouseX, mouseY) && !this.disabled) {
            this.modularGui.getMinecraft().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            if (this.listener != null) {
                this.listener.onMGuiEvent("BUTTON_PRESS", this);
            }
            this.onPressed(mouseX, mouseY, mouseButton);
            return true;
        }
        return false;
    }

    public void onPressed(int mouseX, int mouseY, int mouseButton) {
    }

    public MGuiButton setButtonId(int buttonId) {
        this.buttonId = buttonId;
        return this;
    }

    public MGuiButton setButtonName(String buttonName) {
        this.buttonName = buttonName;
        return this;
    }

    public MGuiButton setDisplayString(String displayString) {
        this.displayString = displayString;
        return this;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public MGuiButton setAlignment(EnumAlignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public MGuiButton setShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        return this;
    }

    public MGuiButton setToolTip(String[] toolTip) {
        this.toolTip = Arrays.asList(toolTip);
        return this;
    }

    public MGuiButton setToolTip(List<String> toolTip) {
        this.toolTip = toolTip;
        return this;
    }

    public List<String> getToolTip() {
        return this.toolTip;
    }

    public int getTextColour(boolean hovered, boolean disabled) {
        if (disabled) {
            return 0xA0A0A0;
        }
        return hovered ? 0xFFFFA0 : 0xE0E0E0;
    }

    public MGuiButton setToolTipDelay(int toolTipDelay) {
        this.toolTipDelay = toolTipDelay;
        return this;
    }

    @Override
    public boolean onUpdate() {
        this.hoverTime = this.mouseOver ? ++this.hoverTime : 0;
        return super.onUpdate();
    }

    public MGuiButton setTrim(boolean trim) {
        this.trim = trim;
        return this;
    }
}

