/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.modularelements;

import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import net.minecraft.client.Minecraft;

public class MGuiBackground
extends MGuiElementBase {
    private final int textureX;
    private final int textureY;
    private final String texture;

    public MGuiBackground(IModularGui modularGui, int xPos, int yPos, int textureX, int textureY, int xSize, int ySize, String texture) {
        super(modularGui, xPos, yPos, xSize, ySize);
        this.textureX = textureX;
        this.textureY = textureY;
        this.texture = texture;
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
        ResourceHelperBC.bindTexture(ResourceHelperBC.getResourceRAW(this.texture));
        this.drawTexturedModalRect(this.xPos, this.yPos, this.textureX, this.textureY, this.xSize, this.ySize);
    }

    public static MGuiBackground newGenericBackground(IModularGui modularGui, int xPos, int yPos, int xSize, int ySize) {
        return new MGuiBackground(modularGui, xPos, yPos, 0, 0, xSize, ySize, ""){

            @Override
            public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                ResourceHelperBC.bindTexture(ResourceHelperBC.getResourceRAW("brandonscore:textures/gui/base_gui.png"));
                this.drawTexturedModalRect(this.xPos, this.yPos, 0, 0, this.xSize / 2, this.ySize / 2);
                this.drawTexturedModalRect(this.xPos + this.xSize / 2, this.yPos, 255 - this.xSize / 2, 0, this.xSize / 2, this.ySize / 2);
                this.drawTexturedModalRect(this.xPos, this.yPos + this.ySize / 2, 0, 255 - this.ySize / 2, this.xSize / 2, this.ySize / 2);
                this.drawTexturedModalRect(this.xPos + this.xSize / 2, this.yPos + this.ySize / 2, 255 - this.xSize / 2, 255 - this.ySize / 2, this.xSize / 2, this.ySize / 2);
            }
        };
    }
}

