/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import com.brandon3055.brandonscore.api.IDataRetainerTile;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileInventoryBase
extends TileBCBase
implements IInventory,
IDataRetainerTile {
    private ItemStack[] inventoryStacks = new ItemStack[0];
    protected int stackLimit = 64;
    protected IItemHandler itemHandler = new InvWrapper((IInventory)this);

    protected void setInventorySize(int size) {
        this.inventoryStacks = new ItemStack[size];
    }

    public int func_70302_i_() {
        return this.inventoryStacks.length;
    }

    public ItemStack func_70301_a(int index) {
        return index < this.inventoryStacks.length && index >= 0 ? this.inventoryStacks[index] : null;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = this.func_70301_a(index);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= count) {
                this.func_70299_a(index, null);
            } else {
                itemstack = itemstack.func_77979_a(count);
                if (itemstack.field_77994_a == 0) {
                    this.func_70299_a(index, null);
                }
            }
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack item = this.func_70301_a(index);
        if (item != null) {
            this.func_70299_a(index, null);
        }
        return item;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index < 0 || index >= this.inventoryStacks.length) {
            return;
        }
        this.inventoryStacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return false;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) < 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventoryStacks = new ItemStack[this.inventoryStacks.length];
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    protected void writeInventoryToNBT(NBTTagCompound compound) {
        NBTTagCompound[] tag = new NBTTagCompound[this.inventoryStacks.length];
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            tag[i] = new NBTTagCompound();
            if (this.inventoryStacks[i] != null) {
                tag[i] = this.inventoryStacks[i].func_77955_b(tag[i]);
            }
            compound.func_74782_a("Item" + i, (NBTBase)tag[i]);
        }
    }

    protected void readInventoryFromNBT(NBTTagCompound compound) {
        NBTTagCompound[] tag = new NBTTagCompound[this.inventoryStacks.length];
        for (int i = 0; i < this.inventoryStacks.length; ++i) {
            tag[i] = compound.func_74775_l("Item" + i);
            this.inventoryStacks[i] = ItemStack.func_77949_a((NBTTagCompound)tag[i]);
        }
    }

    @Override
    public void writeRetainedData(NBTTagCompound dataCompound) {
        this.writeInventoryToNBT(dataCompound);
    }

    @Override
    public void readRetainedData(NBTTagCompound dataCompound) {
        this.readInventoryFromNBT(dataCompound);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getItemHandler(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    protected <T> T getItemHandler(Capability<T> capability, EnumFacing facing) {
        return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
    }
}

