/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.MekanismConfig;
import mekanism.api.util.CapabilityUtils;
import mekanism.common.base.IEnergyWrapper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.CapabilityWrapperManager;
import mekanism.common.integration.TeslaIntegration;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class TileEntityElectricBlock
extends TileEntityContainerBlock
implements IEnergyWrapper {
    public double electricityStored;
    public double BASE_MAX_ENERGY;
    public double maxEnergy;
    public boolean ic2Registered = false;
    private CapabilityWrapperManager teslaManager = new CapabilityWrapperManager<IEnergyWrapper, TeslaIntegration>(IEnergyWrapper.class, TeslaIntegration.class);

    public TileEntityElectricBlock(String name, double baseMaxEnergy) {
        super(name);
        this.maxEnergy = this.BASE_MAX_ENERGY = baseMaxEnergy;
    }

    @Optional.Method(modid="IC2")
    public void register() {
        IEnergyTile registered;
        if (!this.field_145850_b.field_72995_K && (registered = EnergyNet.instance.getTile(this.field_145850_b, this.func_174877_v())) != this) {
            if (registered instanceof IEnergyTile) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(registered));
            } else if (registered == null) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
                this.ic2Registered = true;
            }
        }
    }

    @Optional.Method(modid="IC2")
    public void deregister() {
        IEnergyTile registered;
        if (!this.field_145850_b.field_72995_K && (registered = EnergyNet.instance.getTile(this.field_145850_b, this.func_174877_v())) instanceof IEnergyTile) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(registered));
        }
    }

    @Override
    public void onUpdate() {
        if (!this.ic2Registered && MekanismUtils.useIC2()) {
            this.register();
        }
    }

    @Override
    public EnumSet<EnumFacing> getOutputtingSides() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    @Override
    public EnumSet<EnumFacing> getConsumingSides() {
        return EnumSet.allOf(EnumFacing.class);
    }

    @Override
    public double getMaxOutput() {
        return 0.0;
    }

    @Override
    public double getEnergy() {
        return this.electricityStored;
    }

    @Override
    public void setEnergy(double energy) {
        this.electricityStored = Math.max(Math.min(energy, this.getMaxEnergy()), 0.0);
        MekanismUtils.saveChunk(this);
    }

    @Override
    public double getMaxEnergy() {
        return this.maxEnergy;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.setEnergy(dataStream.readDouble());
        }
    }

    @Override
    public ArrayList<Object> getNetworkedData(ArrayList<Object> data) {
        super.getNetworkedData(data);
        data.add(this.getEnergy());
        return data;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (MekanismUtils.useIC2()) {
            this.register();
        }
    }

    public void onChunkUnload() {
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
        super.onChunkUnload();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (MekanismUtils.useIC2()) {
            this.deregister();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.electricityStored = nbtTags.func_74769_h("electricityStored");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74780_a("electricityStored", this.getEnergy());
        return nbtTags;
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.getEnergy() * (double)i / this.getMaxEnergy());
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (this.getConsumingSides().contains(from)) {
            double toAdd = (int)Math.min(this.getMaxEnergy() - this.getEnergy(), (double)maxReceive * MekanismConfig.general.FROM_RF);
            if (!simulate) {
                this.setEnergy(this.getEnergy() + toAdd);
            }
            return (int)Math.round(toAdd * MekanismConfig.general.TO_RF);
        }
        return 0;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (this.getOutputtingSides().contains(from)) {
            double toSend = Math.min(this.getEnergy(), Math.min(this.getMaxOutput(), (double)maxExtract * MekanismConfig.general.FROM_RF));
            if (!simulate) {
                this.setEnergy(this.getEnergy() - toSend);
            }
            return (int)Math.round(toSend * MekanismConfig.general.TO_RF);
        }
        return 0;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return this.getConsumingSides().contains(from) || this.getOutputtingSides().contains(from);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_RF);
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return (int)Math.round(this.getMaxEnergy() * MekanismConfig.general.TO_RF);
    }

    @Optional.Method(modid="IC2")
    public int getSinkTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public int getSourceTier() {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public void setStored(int energy) {
        this.setEnergy((double)energy * MekanismConfig.general.FROM_IC2);
    }

    @Optional.Method(modid="IC2")
    public int addEnergy(int amount) {
        this.setEnergy(this.getEnergy() + (double)amount * MekanismConfig.general.FROM_IC2);
        return (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public boolean isTeleporterCompatible(EnumFacing side) {
        return this.getOutputtingSides().contains(side);
    }

    @Override
    public boolean canOutputTo(EnumFacing side) {
        return this.getOutputtingSides().contains(side);
    }

    @Optional.Method(modid="IC2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing direction) {
        return this.getConsumingSides().contains(direction);
    }

    @Optional.Method(modid="IC2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing direction) {
        return this.getOutputtingSides().contains(direction) && receiver instanceof IEnergyConductor;
    }

    @Optional.Method(modid="IC2")
    public int getStored() {
        return (int)Math.round(this.getEnergy() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public int getCapacity() {
        return (int)Math.round(this.getMaxEnergy() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public int getOutput() {
        return (int)Math.round(this.getMaxOutput() * MekanismConfig.general.TO_IC2);
    }

    @Optional.Method(modid="IC2")
    public double getDemandedEnergy() {
        return (this.getMaxEnergy() - this.getEnergy()) * MekanismConfig.general.TO_IC2;
    }

    @Optional.Method(modid="IC2")
    public double getOfferedEnergy() {
        return Math.min(this.getEnergy(), this.getMaxOutput()) * MekanismConfig.general.TO_IC2;
    }

    @Override
    public boolean canReceiveEnergy(EnumFacing side) {
        return this.getConsumingSides().contains(side);
    }

    @Optional.Method(modid="IC2")
    public double getOutputEnergyUnitsPerTick() {
        return this.getMaxOutput() * MekanismConfig.general.TO_IC2;
    }

    @Optional.Method(modid="IC2")
    public double injectEnergy(EnumFacing direction, double amount, double voltage) {
        TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177972_a(direction));
        if (tile == null || CapabilityUtils.hasCapability((ICapabilityProvider)tile, Capabilities.GRID_TRANSMITTER_CAPABILITY, direction.func_176734_d())) {
            return amount;
        }
        return amount - this.transferEnergyToAcceptor(direction, amount * MekanismConfig.general.FROM_IC2) * MekanismConfig.general.TO_IC2;
    }

    @Optional.Method(modid="IC2")
    public void drawEnergy(double amount) {
        this.setEnergy(Math.max(this.getEnergy() - amount * MekanismConfig.general.FROM_IC2, 0.0));
    }

    @Override
    public double transferEnergyToAcceptor(EnumFacing side, double amount) {
        if (!this.getConsumingSides().contains(side) && side != null) {
            return 0.0;
        }
        double toUse = Math.min(this.getMaxEnergy() - this.getEnergy(), amount);
        this.setEnergy(this.getEnergy() + toUse);
        return toUse;
    }

    @Override
    public double removeEnergyFromProvider(EnumFacing side, double amount) {
        if (!this.getOutputtingSides().contains(side) && side != null) {
            return 0.0;
        }
        double toGive = Math.min(this.getEnergy(), amount);
        this.setEnergy(this.getEnergy() - toGive);
        return toGive;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == Capabilities.ENERGY_STORAGE_CAPABILITY || capability == Capabilities.ENERGY_ACCEPTOR_CAPABILITY || capability == Capabilities.CABLE_OUTPUTTER_CAPABILITY || capability == Capabilities.TESLA_HOLDER_CAPABILITY || capability == Capabilities.TESLA_CONSUMER_CAPABILITY && this.getConsumingSides().contains(facing) || capability == Capabilities.TESLA_PRODUCER_CAPABILITY && this.getOutputtingSides().contains(facing) || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == Capabilities.ENERGY_STORAGE_CAPABILITY || capability == Capabilities.ENERGY_ACCEPTOR_CAPABILITY || capability == Capabilities.CABLE_OUTPUTTER_CAPABILITY) {
            return (T)this;
        }
        if (capability == Capabilities.TESLA_HOLDER_CAPABILITY || capability == Capabilities.TESLA_CONSUMER_CAPABILITY && this.getConsumingSides().contains(facing) || capability == Capabilities.TESLA_PRODUCER_CAPABILITY && this.getOutputtingSides().contains(facing)) {
            return (T)this.teslaManager.getWrapper(this, facing);
        }
        return super.getCapability(capability, facing);
    }
}

